<?php

namespace EstatebudConnect\Configs;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class Defaults
{
    use Singleton;

    const PROPERTY_LISTING = [
        'slider_style' => 'contained',
        'contact_details' => 'agent',
        'contact_form' => '',
        'mortgage_calculator' => true,
        'similar_properties' => true,
        'map_style' => 'contained',
        'map_default_zoom' => '',
        'map_zoom_limit' => '',
        'brochure_template_id' => '3',
        'brochure_show_agent' => false,
        'brochure_white_label' => false,
        'show_availability_date' => true,
        'availability_offset' => '4',
        'legal_disclaimer' => '',
    ];

    const PROJECT_LISTING = [
        'slider_style' => 'contained',
        'contact_details' => 'agent',
        'contact_form' => '',
        'mortgage_calculator' => true,
        'map_style' => 'contained',
        'map_default_zoom' => '',
        'map_zoom_limit' => '',
        'brochure_template_id' => '3',
        'brochure_show_agent' => false,
        'brochure_white_label' => true,
        'legal_disclaimer' => '',
    ];

    const SETTINGS = [
        'estatebud_api_key' => '',
        'currencies' => [],
        'favorites' => true,
        'favorites_contact_form' => '',
        'map_provider' => 'openfreemap',
        'map_access_token' => '',
        'mapbox_style' => '',
        'captcha_provider' => '',
        'captcha_site_key' => '',
        'captcha_secret_key' => '',
        'branding_color' => '#5C73E5',
        'edge_style' => 'sharp',
        'field_style' => 'sharp',
        'button_style' => 'sharp',
        'icon_style' => 'solid',
        'icon_type' => 'sharp',
        'link_opening_behavior' => 'current_tab',
        'powered_by' => true,
        'ip_lookup' => true,
        'release_tier' => 'release',
        'log_level' => 'off',
        'custom_css' => '',
        'sharing_providers' => ['email', 'facebook', 'whatsapp', 'x'],
    ];

    const FORM = [
        'id' => '',
        'name' => '',
        'type' => 'property-search',
        'fields' => [],
        'is_button_available' => false,
        'button_label' => '',
        'button_icon_type' => '',
        'button_icon_position' => '',
        'button_width' => '',
        'button_destination_page' => '',
        'email_to' => '',
        'email_subject' => '',
        'email_message' => '',
        'email_from' => '',
        'email_from_name' => '',
        'email_reply_to' => '',
        'email_cc' => '',
        'email_bcc' => '',
        'email_meta_data' => [],
        'confirmation_email_subject' => '',
        'confirmation_email_message' => '',
        'confirmation_email_from' => '',
        'confirmation_email_from_name' => '',
        'confirmation_email_reply_to' => '',
        'confirmation_email_cc' => '',
        'confirmation_email_bcc' => '',
        'privacy_policy_page_id' => '',
        'pipeline_stage_id' => '',
        'google_ads_id' => '',
        'google_analytics_id' => '',
        'meta_id' => '',
    ];

    const SEARCH_EXPERIENCE = [
        'id' => '',
        'name' => 'Default name',
        'type' => 'property-search',
        'fields' => [],
    ];
}
