<?php

namespace EstatebudConnect\Configs;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class Icons
{
    public const STYLE_BRANDS = 'brands';
    public const STYLE_SOLID = 'solid';
    public const STYLE_REGULAR = 'regular';
    public const STYLE_LIGHT = 'light';

    public const SHAPE_DEFAULT = 'default';
    public const SHAPE_SHARP = 'sharp';
    public const SHAPE_ROUND = 'round';

    private $icon_color;

    public const brands_default = [
        'facebook' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M512 256C512 114.6 397.4 0 256 0S0 114.6 0 256C0 376 82.7 476.8 194.2 504.5l0-170.3-52.8 0 0-78.2 52.8 0 0-33.7c0-87.1 39.4-127.5 125-127.5 16.2 0 44.2 3.2 55.7 6.4l0 70.8c-6-.6-16.5-1-29.6-1-42 0-58.2 15.9-58.2 57.2l0 27.8 83.6 0-14.4 78.2-69.3 0 0 175.9C413.8 494.8 512 386.9 512 256z"/></svg>',
        'pinterest' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M504 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3 .8-3.4 5-20.3 6.9-28.1 .6-2.5 .3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2C161.5 437.2 163.5 467.4 165.6 487 73.4 450.9 8 361.1 8 256 8 119 119 8 256 8S504 119 504 256z"/></svg>',
        'telegram' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8a248 248 0 1 0 0 496 248 248 0 1 0 0-496zM371 176.7c-3.7 39.2-19.9 134.4-28.1 178.3-3.5 18.6-10.3 24.8-16.9 25.4-14.4 1.3-25.3-9.5-39.3-18.7-21.8-14.3-34.2-23.2-55.3-37.2-24.5-16.1-8.6-25 5.3-39.5 3.7-3.8 67.1-61.5 68.3-66.7 .2-.7 .3-3.1-1.2-4.4s-3.6-.8-5.1-.5c-2.2 .5-37.1 23.5-104.6 69.1-9.9 6.8-18.9 10.1-26.9 9.9-8.9-.2-25.9-5-38.6-9.1-15.5-5-27.9-7.7-26.8-16.3 .6-4.5 6.7-9 18.4-13.7 72.3-31.5 120.5-52.3 144.6-62.3 68.9-28.6 83.2-33.6 92.5-33.8 2.1 0 6.6 .5 9.6 2.9 2 1.7 3.2 4.1 3.5 6.7 .5 3.2 .6 6.5 .4 9.8z"/></svg>',
        'whatsapp' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1c-41.9-42-97.7-65.1-157-65.1-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480 117.7 449.1c32.4 17.7 68.9 27 106.1 27l.1 0c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3 18.6-68.1-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1s56.2 81.2 56.1 130.5c0 101.8-84.9 184.6-186.6 184.6zM325.1 300.5c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8s-14.3 18-17.6 21.8c-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7s-12.5-30.1-17.1-41.2c-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2s-9.7 1.4-14.8 6.9c-5.1 5.6-19.4 19-19.4 46.3s19.9 53.7 22.6 57.4c2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4s4.6-24.1 3.2-26.4c-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
        'x' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M357.2 48L427.8 48 273.6 224.2 455 464 313 464 201.7 318.6 74.5 464 3.8 464 168.7 275.5-5.2 48 140.4 48 240.9 180.9 357.2 48zM332.4 421.8l39.1 0-252.4-333.8-42 0 255.3 333.8z"/></svg>',
    ];

    public const solid_sharp = [
        'angle-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M19 256l22.6 22.6 160 160 22.6 22.6 45.3-45.3-160-160 137.4-137.4 22.6-22.6-45.3-45.3-22.6 22.6-160 160-22.6 22.6z"/></svg>',
        'angle-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M301.5 256L278.9 278.6 118.9 438.6 96.3 461.3 51 416 73.6 393.4 211 256 73.6 118.6 51 96 96.3 50.7 118.9 73.4 278.9 233.4 301.5 256z"/></svg>',
        'arrow-rotate-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64 32l0-32-64 0 0 192 192 0 0-64-79.1 0c35.2-39.3 86.3-64 143.1-64 106 0 192 86 192 192S362 448 256 448c-75 0-140-43-171.6-105.8L27.2 370.9C69.2 454.5 155.9 512 256 512 397.4 512 512 397.4 512 256S397.4 0 256 0C179.5 0 110.9 33.6 64 86.7L64 32z"/></svg>',
        'arrows-maximize' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M288 32l-32 0 0 64 82.7 0-114.7 114.7-114.7-114.7 82.7 0 0-64-192 0 0 192 64 0 0-82.7 114.7 114.7-114.7 114.7 0-82.7-64 0 0 192 192 0 0-64-82.7 0 114.7-114.7 114.7 114.7-82.7 0 0 64 192 0 0-192-64 0 0 82.7-114.7-114.7 114.7-114.7 0 82.7 64 0 0-192-160 0z"/></svg>',
        'ban' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M367.2 412.5L99.5 144.8c-22.4 31.4-35.5 69.8-35.5 111.2 0 106 86 192 192 192 41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3c22.4-31.4 35.5-69.8 35.5-111.2 0-106-86-192-192-192-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"/></svg>',
        'bed-front' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M480 32l-448 0 0 144 48 0 0-48 152 0 0 48 48 0 0-48 152 0 0 48 48 0 0-144zM32 224l-32 0 0 256 64 0 0-64 384 0 0 64 64 0 0-256-480 0z"/></svg>',
        'bus-simple' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 0l-448 0 0 448 32 0 0 64 96 0 0-64 192 0 0 64 96 0 0-64 32 0 0-448zM64 96l320 0 0 160-320 0 0-160zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"/></svg>',
        'car' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M120 32l-22.7 0-7.5 21.4-48.5 138.6-41.3 0 0 288 96 0 0-64 320 0 0 64 96 0 0-288-41.3 0-48.5-138.6-7.5-21.4-294.7 0zM402.9 192l-293.8 0 33.6-96 226.6 0 33.6 96zM64 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"/></svg>',
        'caret-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M440 160L224 392 8 160 440 160z"/></svg>',
        'check' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M493 88.9l-18.8 25.9-256 352-22 30.3c-.7-.7-52.2-52.2-154.5-154.5L19 320 64.3 274.7c1.9 1.9 43.3 43.3 124.1 124.1l234-321.7 18.8-25.9 51.8 37.6z"/></svg>',
        'check-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm97.1-319.6l-12.7 20.4-80 128-7 11.3-25.3 0-7.2-9.6c-37.6-50.1-58.4-77.9-62.4-83.2l38.4-28.8c7.5 10 21.3 28.4 41.4 55.2 49.1-78.5 73.8-118.1 74.2-118.7l40.7 25.4z"/></svg>',
        'chevron-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256.3 429.3l214.6-214.6 22.6-22.6-45.3-45.3-22.6 22.6-169.4 169.4-169.4-169.4-22.6-22.6-45.3 45.3 22.6 22.6 192 192 22.6 22.6z"/></svg>',
        'chevron-up' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256.3 82.7l22.6 22.6 214.6 214.6-45.3 45.3-22.6-22.6-169.4-169.4-169.4 169.4-22.6 22.6-45.3-45.3 22.6-22.6 192-192 22.6-22.6z"/></svg>',
        'copy' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M352 0l-224 0 0 384 320 0 0-288-96-96zM64 128l-64 0 0 384 320 0 0-80-64 0 0 16-192 0 0-256 16 0 0-64-16 0z"/></svg>',
        'envelope-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M441.8 187.3L256 48 70.2 187.3 256 320 441.8 187.3zM0 160l256-192 256 192 0 320-512 0 0-320z"/></svg>',
        'expand' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M32 32l-32 0 0 160 64 0 0-96 96 0 0-64-128 0zM64 352l0-32-64 0 0 160 160 0 0-64-96 0 0-64zM320 32l-32 0 0 64 96 0 0 96 64 0 0-160-128 0zM448 352l0-32-64 0 0 96-96 0 0 64 160 0 0-128z"/></svg>',
        'file-pdf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM240 380l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm96-80l-20 0 0 168 52 0c28.7 0 52-23.3 52-52l0-64c0-28.7-23.3-52-52-52l-32 0zm20 128l0-88 12 0c6.6 0 12 5.4 12 12l0 64c0 6.6-5.4 12-12 12l-12 0zm88-128l0 168 40 0 0-64 48 0 0-40-48 0 0-24 48 0 0-40-88 0z"/></svg>',
        'graduation-cap' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288 16l288 128 0 32-288 128-240-106.7 0 282.7-48 0 0-336 288-128zM96 271.2l172.5 76.7 19.5 8.7 19.5-8.7 172.5-76.7 0 112.8c0 53-86 96-192 96S96 437 96 384l0-112.8z"/></svg>',
        'heart' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M133.1 32C175.8 32 216 52.5 241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1 512 301.9 358.5 425.3 256 496 153.5 425.3 0 301.9 0 165.1 0 91.6 59.6 32 133.1 32z"/></svg>',
        'heart-crack' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M288 320l-128-112 80-80-63.3-88.7C162.8 34.5 148.1 32 133.1 32 59.6 32 0 91.6 0 165.1 0 301.9 153.5 425.3 256 496 358.5 425.3 512 301.9 512 165.1 512 91.6 452.4 32 378.9 32 350.1 32 322.6 41.3 300 57.9l20 70.1-96 80 64 112z"/></svg>',
        'house-user' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 416 0 0-240zM200 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm136 96l32 96-224 0 32-96 160 0z"/></svg>',
        'image' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 32l-448 0 0 448 448 0 0-448zM128 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm16 160l46.1 69.1 81.9-133.1 128 208-352 0 96-144z"/></svg>',
        'leaf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M512 24l0 186.9C512 342.1 403.9 448 273.2 448 196.2 448 129.8 398.5 105.7 329.3 70.4 360.1 48 405.4 48 456l0 24-48 0 0-24C0 381.1 38.2 315.1 96.1 276.3 131.3 252.8 173.5 240 216 240l104 0 0-48-104 0c-39.7 0-77.3 8.8-111 24.5 23.3-70 89.2-120.5 167-120.5 58 0 107.5-21.8 143.2-44.3 17.7-11.2 31.7-22.4 41.2-30.8 4.8-4.2 9.4-8.7 13.9-13.2L512 24z"/></svg>',
        'location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6C384 339.4 192 528 192 528S0 339.4 0 188.6zM192 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"/></svg>',
        'paper-plane' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M0 192L608-32 384 576 286.9 329.2 416 160 247.2 289.3 0 192z"/></svg>',
        'paper-plane-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M148 226.9L48-16 640 256 48 528 148 285.1 352 256 148 226.9z"/></svg>',
        'arrow-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M534.9 278.6l22.6-22.6-22.6-22.6-160-160-22.6-22.6-45.3 45.3c1.3 1.3 44 44 128 128l-402.7 0 0 64 402.7 0c-84 84-126.7 126.7-128 128l45.3 45.3 22.6-22.6 160-160z"/></svg>',
        'arrow-long-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M598.9 278.6L621.5 256 598.9 233.4 448.3 82.7 403 128c6.6 6.6 38.6 38.6 96 96l-466.7 0 0 64 466.7 0-96 96 45.3 45.3 150.6-150.6z"/></svg>',
        'map-location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M576 64l0-51.8c-19.2 9.6-73.4 36.7-162.5 81.2l-179.4-59.8-12.6-4.2-11.9 5.9-128 64-17.7 8.8 0 391.6c19.2-9.6 73.4-36.7 162.5-81.2L387 472.1c-7.1-11.9-13.8-24.3-19.8-37.1-6.1-13.2-11.6-27.4-15.8-42.2l-95.4-31.8 0-252.5 128 42.7 0 83.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 64zM512 224c-66.3 0-120 52.8-120 117.9 0 94.3 120 212.1 120 212.1S632 436.1 632 341.9C632 276.8 578.3 224 512 224zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"/></svg>',
        'percent' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M470.9 86.6l22.6-22.6-45.3-45.3-22.6 22.6-384 384-22.6 22.6 45.3 45.3 22.6-22.6 384-384zM32.3 32l0 160 160 0 0-160-160 0zm288 288l0 160 160 0 0-160-160 0z"/></svg>',
        'phone' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 64L128 0 224.8 128 144 208c33 70.4 89.6 127 160 160l80-80.8 128 96.8-64 128-16 0C193.4 512 0 318.6 0 80L0 64z"/></svg>',
        'plane-departure' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M404 143.1l-211.8-110.2-75.2 27.4 115.3 145.3-100.2 36.5-70-42.6-45.1 16.4 90.3 154.4 63.1-23 0 0 398.4-145c29.1-10.6 44-42.7 33.5-71.8s-42.7-44-71.8-33.5L404 143.1zM64.3 448l-32 0 0 64 576 0 0-64-544 0z"/></svg>',
        'ruler-triangle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64.3-29.3l0 509.3 509.3 0-77.7-77.7c-9.4 9.4-19.9 19.9-31.6 31.6L430.3 400c11.7-11.7 22.2-22.2 31.6-31.6l-46.1-46.1c-29.4 29.4-47.9 47.9-55.6 55.6L326.3 344c7.7-7.7 26.2-26.2 55.6-55.6l-46.1-46.1c-9.4 9.4-19.9 19.9-31.6 31.6L270.3 240c11.7-11.7 22.2-22.2 31.6-31.6l-46.1-46.1c-29.4 29.4-47.9 47.9-55.6 55.6L166.3 184c7.7-7.7 26.2-26.2 55.6-55.6L175.9 82.3c-9.4 9.4-19.9 19.9-31.6 31.6L110.3 80 141.9 48.4 64.3-29.3zm128 293l88.2 88.2-88.2 0 0-88.2z"/></svg>',
        'share' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M560.2 208l-239.8-215.9 0 135.9-112 0c-97.2 0-176 78.8-176 176 0 128 128 176 128 176s-32-32-32-80c0-61.9 50.1-112 112-112l80 0 0 135.9 239.8-215.9z"/></svg>',
        'share-nodes' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M384 192c53 0 96-43 96-96s-43-96-96-96-96 43-96 96c0 5.4 .5 10.8 1.3 16L159.6 184.1c-16.9-15-39.2-24.1-63.6-24.1-53 0-96 43-96 96s43 96 96 96c24.4 0 46.6-9.1 63.6-24.1L289.3 400c-.9 5.2-1.3 10.5-1.3 16 0 53 43 96 96 96s96-43 96-96-43-96-96-96c-24.4 0-46.6 9.1-63.6 24.1L190.7 272c.9-5.2 1.3-10.5 1.3-16s-.5-10.8-1.3-16l129.7-72.1c16.9 15 39.2 24.1 63.6 24.1z"/></svg>',
        'shop' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M16 256l0-64 80-160 384 0 80 160 0 64-48 0 0 224-64 0 0-224-96 0 0 224-288 0 0-224-48 0zm112 0l0 128 160 0 0-128-160 0z"/></svg>',
        'shower' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M32 32l-32 0 0 448 64 0 0-384 50.7 0 26.7 26.7c-21 38.9-17.4 87.5 10.9 123l-1.3 1.3-17 17 33.9 33.9 17-17 160-160 17-17-33.9-33.9-17 17-1.3 1.3c-35.5-28.3-84.1-31.9-123-10.9-28.5-28.5-43.7-43.7-45.5-45.5L32 32zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32-32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
        'table-layout' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 32l-448 0 0 448 448 0 0-448zM384 96l0 64-320 0 0-64 320 0zM64 224l64 0 0 192-64 0 0-192zm320 0l0 192-192 0 0-192 192 0z"/></svg>',
        'trowel-bricks' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M256.2 41.6l0-56.5C239.8-5.1 175.6 33.4 63.7 100.6L18 128c14.1 8.5 77.4 46.4 189.7 113.8l48.5 29.1 0-110.9 288 0 0-64-288 0 0-54.4zm64 182.4l0 128 224 0 0-128-224 0zm-128 160l-160 0 0 128 160 0 0-128zm352 0l-320 0 0 128 320 0 0-128z"/></svg>',
        'video' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M416 64l-384 0 0 384 384 0 0-384zM576 416l0-320-112 74.7 0 170.7 112 74.7z"/></svg>',
        'street-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 160l64 0c35.3 0 64 28.7 64 64l0 80-33.8 0-14.2 128-96 0-14.2-128-33.8 0 0-80c0-35.3 28.7-64 64-64zM412.4 400.2c-16.1-4.2-34.8-7.6-55.4-10.2l5.3-47.7c22.7 2.9 43.7 6.7 62.1 11.5 22.4 5.8 42.6 13.3 57.8 23.3 14.7 9.6 29.8 24.9 29.8 47s-15.1 37.4-29.8 47c-15.2 9.9-35.5 17.5-57.8 23.3-45.1 11.7-105.3 17.8-168.4 17.8s-123.3-6.1-168.4-17.8C65.2 488.4 45 480.9 29.8 471 15.1 461.4 0 446.1 0 424s15.1-37.4 29.8-47c15.2-9.9 35.5-17.5 57.8-23.3 18.5-4.8 39.5-8.6 62.1-11.5L155 390c-20.6 2.6-39.3 6.1-55.4 10.2-56.6 14.6-56.6 32.9 0 47.5 39.9 10.3 95.8 16.2 156.4 16.2s116.5-5.9 156.4-16.2c56.6-14.6 56.6-32.9 0-47.5z"/></svg>',
        'warning' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288-16L16 480 560 480 288-16zm24 192l0 144-48 0 0-144 48 0zM264 408l0-48 48 0 0 48-48 0z"/></svg>',
        'water' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M136.2 62.2l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 116.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6zm0 144l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 260.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6zm8.9 147.6l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c82.9 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.8-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 404.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6 8.9 3.6z"/></svg>',
        'water-ladder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M449.3 385.7l111.8 44.7c29.3-9.8 50.1-16.7 62.4-20.8l15.2 45.5-79.1 26.4-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-120-48-111.1 44.4-8.2 3.3-8.3-2.8-70.8-23.6 15.2-45.5c12.3 4.1 33.2 11 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6 111.1 44.4 120-48 8.9 3.6zM512.4 32c53 0 96 43 96 96l0 32-64 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 218.6-13.3-5.3-26.7-10.7-24 9.6 0-52.2-192 0 0 52.2-24-9.6-26.8 10.7-13.2 5.3 0-218.6c0-53 43-96 96-96s96 43 96 96l0 32-64 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96 192 0 0-96c0-53 43-96 96-96z"/></svg>',
        'xmark-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM172.1 305.9L222.1 256c-38.8-38.8-61.1-61.1-66.9-66.9l33.9-33.9 66.9 66.9c38.8-38.8 61.1-61.1 66.9-66.9l33.9 33.9c-5.8 5.8-28.1 28.1-66.9 66.9 38.8 38.8 61.1 61.1 66.9 66.9l-33.9 33.9c-5.8-5.8-28.1-28.1-66.9-66.9-38.8 38.8-61.1 61.1-66.9 66.9l-33.9-33.9 17-17z"/></svg>',
        'xmark-large' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M534.9 54.6L557.5 32 512.3-13.3 489.6 9.4 288.3 210.7 86.9 9.4 64.3-13.3 19 32 41.6 54.6 243 256 41.6 457.4 19 480 64.3 525.3 86.9 502.6 288.3 301.3 489.6 502.6 512.3 525.3 557.5 480 333.5 256 534.9 54.6z"/></svg>',
        'door-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M288 64l64 0 0 448 96 0 0-64-32 0 0-448-160 0 0 0-224 0 0 448-32 0 0 64 288 0 0-448zM160 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'toilet' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M24 0L0 0 0 48 32 48 32 196.9c-1.9 1.4-3.8 2.9-5.6 4.4-15.5 13.2-26.4 31.6-26.4 54.6 0 46.9 14.3 84.1 37 112.5 15.1 18.9 33.3 33.1 51.9 43.9L64 512 384 512 359.1 412.4c18.6-10.8 36.8-25 51.9-43.9 22.7-28.4 37-65.5 37-112.5 0-23.1-10.9-41.5-26.4-54.6-1.8-1.5-3.7-3-5.6-4.4l0-148.9 32 0 0-48-424 0zM96 64l64 0 0 32-64 0 0-32zM224 288c-88.4 0-160-14.3-160-32s71.6-32 160-32 160 14.3 160 32-71.6 32-160 32z"/></svg>',
        'bath' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64 0l-32 0 0 256-32 0 0 64 32 0 0 48c0 28.4 12.4 54 32 71.6l0 72.4 64 0 0-48 256 0 0 48 64 0 0-72.4c19.6-17.6 32-43.1 32-71.6l0-48 32 0 0-64-416 0 0-192 18.7 0 18.8 18.8c-3.6 9.1-5.5 18.9-5.5 29.2 0 19.6 7 37.5 18.7 51.4l-12.6 12.6 33.9 33.9 17-17 104-104 17-17-33.9-33.9-12.6 12.6C245.5 39 227.6 32 208 32 197.7 32 187.8 34 178.8 37.5 156.9 15.6 144.4 3.1 141.3 0L64 0z"/></svg>',
        'oven' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 0L448 0 448 512 0 512 0 0zM104 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm16 88l-320 0 0 224 320 0 0-224zM136 272l200 0 0 48-224 0 0-48 24 0z"/></svg>',
        'couch' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M64 64l512 0 0 112-80 0 0 128-352 0 0-128-80 0 0-112zM0 448l0-224 96 0 0 128 448 0 0-128 96 0 0 224-640 0z"/></svg>',
        'hotel' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M16 0l480 0 0 48-32 0 0 416 32 0 0 48-480 0 0-48 32 0 0-416-32 0 0-48zM288 384l62.7 0c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80l62.7 0 0 80 64 0 0-80zM112 96l0 64 64 0 0-64-64 0zm176 0l-64 0 0 64 64 0 0-64zm48 0l0 64 64 0 0-64-64 0zM176 192l-64 0 0 64 64 0 0-64zm48 0l0 64 64 0 0-64-64 0zm176 0l-64 0 0 64 64 0 0-64z"/></svg>',
        'moon-stars' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M448-32l16 48 48 16-48 16-16 48-16-48-48-16 48-16 16-48zM314.7 83.1c-76.2 18.9-132.7 87.8-132.7 169.9 0 96.6 78.3 175 175 175 16.2 0 31.9-2.2 46.8-6.3-40.8 54.8-106.1 90.3-179.8 90.3-123.7 0-224-100.3-224-224S100.3 64 224 64c32.3 0 63 6.8 90.7 19.1zM384 352L355.2 268.8 272 240 355.2 211.2 384 128 412.8 211.2 496 240 412.8 268.8 384 352z"/></svg>',
        'grid-2-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M192 32l-192 0 0 192 192 0 0-192zm0 256l-192 0 0 192 192 0 0-192zM256 32l0 192 192 0 0-192-192 0zM376 288l-48 0 0 72-72 0 0 48 72 0 0 72 48 0 0-72 72 0 0-48-72 0 0-72z"/></svg>',
        'layer-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M488-8l0-24-48 0 0 56-56 0 0 48 56 0 0 56 48 0 0-56 56 0 0-48-56 0 0-32zM16 224L288 352 560 224 288 96 16 224zm0 160L288 512 560 384 446.4 330.5 288 405 129.6 330.5 16 384z"/></svg>',
        'layer-group' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288 256L16 128 288 0 560 128 288 256zM95.6 218.5L288 309 480.4 218.5 560 256 288 384 16 256 95.6 218.5zM16 384L95.6 346.5 288 437 480.4 346.5 560 384 288 512 16 384z"/></svg>',
        'lamp' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M96 32L0 288 448 288 352 32 96 32zm0 384c0 38.2 16.8 72.5 43.3 96l169.3 0c26.6-23.5 43.3-57.8 43.3-96 0-30.3-10.5-58.1-28.1-80l-199.9 0C106.5 357.9 96 385.7 96 416z"/></svg>',
        'stairs' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M384 32l192 0 0 64-128 0 0 128-128 0 0 128-128 0 0 128-192 0 0-64 128 0 0-128 128 0 0-128 128 0 0-128z"/></svg>',
        'file-certificate' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M368 0l-240 0 0 144c97.2 0 176 78.8 176 176 0 46.8-18.2 89.3-48 120.8l0 71.2 256 0 0-368-144-144zm85.5 176L336 176 336 58.5 453.5 176zM208 419.9c29.3-23.5 48-59.5 48-99.9 0-70.7-57.3-128-128-128S0 249.3 0 320c0 40.4 18.7 76.5 48 99.9l0 132.1 80-40 80 40 0-132.1zM80 320a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"/></svg>',
        'chart-pie' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M544.5 240l-240 0 0-240c132.5 0 240 107.5 240 240zM256.5 32.5l0 240.1 5.5 6.7 153.6 185.4c-40 29.7-89.5 47.3-143.1 47.3-132.5 0-240-107.5-240-240 0-127.2 98.9-231.2 224-239.5zM512 288l64 0c-4.8 72.8-42 136.7-97.4 177.4L331.5 288 512 288z"/></svg>',
        'road' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M224 32l-118.6 0-105.4 448 224 0 0-96 64 0 0 96 224 0-105.4-448-118.6 0 0 96-64 0 0-96zm64 192l0 96-64 0 0-128 64 0 0 32z"/></svg>',
        'star' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288.2-52.8l-92.6 181.4-201.1 32 143.9 144.1-31.7 201.2 181.5-92.3 181.5 92.3-31.7-201.2 143.9-144.1-201.1-32-92.6-181.4z"/></svg>',
        'cube' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256.3-21l16 9.2 207.8 120 16 9.2 0 277-16 9.2-207.8 120-16 9.2-16-9.2-207.8-120-16-9.2 0-277 16-9.2 207.8-120 16-9.2zM432.2 357.5l0-166.1-143.8 83.1 0 166.1 143.8-83z"/></svg>',
        'house-window' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M512 272l-48 0 0 240-416 0 0-240-48 0 0-48 256-240 256 240 0 48zM320 352l0-128-128 0 0 128 128 0z"/></svg>',
        'window-frame' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 448l32 0 0 64-448 0 0-64 32 0 0-448 384 0 0 448zM352 224l0-160-96 0 0 160 96 0zm-96 64l0 160 96 0 0-160-96 0zm-64-64l0-160-96 0 0 160 96 0zM96 288l0 160 96 0 0-160-96 0z"/></svg>',
        'compass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm184-72l-56 200 200-56 56-200-200 56zm72 40a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"/></svg>',
        'hammer-brush' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M0 137.7C0 91.7 23 48.7 61.3 23.1 83.9 8 110.5 0 137.7 0l86.3 0 48 32 16 0 0-32 64 0 0 160-64 0 0-32-16 0-48 32-96 0-48-32-80 32 0-22.3zM224 208l0 304-96 0 0-304 96 0zM448 448l-32 64-96 0 0-176 288 0 0 176-128 0-32-64zM320 256l96-64 0-192 96 0 0 192 96 64 0 32-288 0 0-32z"/></svg>',
        'file-signature' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M64 0l240 0 144 144 0 123.7-132.3 132.3-28.8 0-33.4-66.7-6.6-13.3-42.2 0-7.2 8.8-72 88 37.2 30.4 58.5-71.5c23.5 47 35.5 71 36.1 72.3l29.7 0-10.7 64-212.2 0 0-512zM272 58.5L272 176 389.5 176 272 58.5zM544 239.9l80 80-52.8 52.8-80-80 52.8-52.8zm-208 208l132.6-132.6 80 80-132.6 132.6-96 16 16-96z"/></svg>',
        'key' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7l-161.3 161.3-7 7 0 113.9 128 0 0-64 64 0 0-64 49.9 0 7-7 33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"/></svg>',
        'coins' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M128 96l0-16c0-44.2 86-80 192-80S512 35.8 512 80l0 16c0 30.6-41.3 57.2-102 70.7-2.4-2.8-4.9-5.5-7.4-8-15.5-15.3-35.5-26.9-56.4-35.5-41.9-17.5-96.5-27.1-154.2-27.1-21.9 0-43.3 1.4-63.8 4.1-.2-1.3-.2-2.7-.2-4.1zM432 353l0-46.2c15.1-3.9 29.3-8.5 42.2-13.9 13.2-5.5 26.1-12.2 37.8-20.3l0 15.4c0 26.8-31.5 50.5-80 65zm0-96l0-33c0-4.5-.4-8.8-1-13 15.5-3.9 30-8.6 43.2-14.2s26.1-12.2 37.8-20.3l0 15.4c0 26.8-31.5 50.5-80 65zM0 240l0-16c0-44.2 86-80 192-80s192 35.8 192 80l0 16c0 44.2-86 80-192 80S0 284.2 0 240zm384 96c0 44.2-86 80-192 80S0 380.2 0 336l0-15.4c11.6 8.1 24.5 14.7 37.8 20.3 41.9 17.5 96.5 27.1 154.2 27.1s112.3-9.7 154.2-27.1c13.2-5.5 26.1-12.2 37.8-20.3l0 15.4zm0 80.6l0 15.4c0 44.2-86 80-192 80S0 476.2 0 432l0-15.4c11.6 8.1 24.5 14.7 37.8 20.3 41.9 17.5 96.5 27.1 154.2 27.1s112.3-9.7 154.2-27.1c13.2-5.5 26.1-12.2 37.8-20.3z"/></svg>',
        'object-exclude' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 0l352 0 0 160 160 0 0 352-352 0 0-160-160 0 0-352zM320 192l-128 0 0 128 128 0 0-128z"/></svg>',
        'square-dashed' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M32 32l80 0 0 64-48 0 0 48-64 0 0-112 32 0zM0 192l64 0 0 128-64 0 0-128zm384 0l64 0 0 128-64 0 0-128zm64-48l-64 0 0-48-48 0 0-64 112 0 0 112zm0 224l0 112-112 0 0-64 48 0 0-48 64 0zM64 368l0 48 48 0 0 64-112 0 0-112 64 0zM288 480l-128 0 0-64 128 0 0 64zM160 96l0-64 128 0 0 64-128 0z"/></svg>',
        'chart-pyramid' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M103.7 320l368.5 0-61.4-112-245.7 0-61.4 112zM77.4 368l-61.4 112 544 0-61.4-112-421.2 0zM288-16l-96.5 176 193 0-96.5-176z"/></svg>',
        'vector-square' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M384 0l128 0 0 128-32 0 0 256 32 0 0 128-128 0 0-32-256 0 0 32-128 0 0-128 32 0 0-256-32 0 0-128 128 0 0 32 256 0 0-32zM96 128l0 256 32 0 0 32 256 0 0-32 32 0 0-256-32 0 0-32-256 0 0 32-32 0z"/></svg>',
        'diagram-cells' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 32l0 192-448 0 0-192 448 0zM384 416l0-64-320 0 0 64 320 0zm64 64l-448 0 0-192 448 0 0 192z"/></svg>',
        'border-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 32l-448 0 0 64 448 0 0-64zM64 160l-64 0 0 64 64 0 0-64zM384 416l0 64 64 0 0-64-64 0zm64-128l-64 0 0 64 64 0 0-64zM384 160l0 64 64 0 0-64-64 0zM64 288l-64 0 0 64 64 0 0-64zM0 416l0 64 64 0 0-64-64 0zm192 0l-64 0 0 64 64 0 0-64zm64 0l0 64 64 0 0-64-64 0z"/></svg>',
        'border-none' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 416l0 64 64 0 0-64-64 0zM128 32l0 64 64 0 0-64-64 0zM256 416l0 64 64 0 0-64-64 0zM128 480l64 0 0-64-64 0 0 64zM256 32l0 64 64 0 0-64-64 0zM384 480l64 0 0-64-64 0 0 64zm0-384l64 0 0-64-64 0 0 64zM0 32l0 64 64 0 0-64-64 0zM384 352l64 0 0-64-64 0 0 64zM0 160l0 64 64 0 0-64-64 0zM0 352l64 0 0-64-64 0 0 64zM384 160l0 64 64 0 0-64-64 0z"/></svg>',
        'car-garage' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M0 512l0-416 288-96 288 96 0 416-64 0 0-320-448 0 0 320-64 0zM207.1 240l175.7 0 6.9 12.1 55.1 96 3.2 5.5 0 158.4-64 0 0-48-192 0 0 48-64 0 0-158.4 3.2-5.5 55.1-96 6.9-12.1 13.9 0zm175.4 96l-27.6-48-134 0-27.6 48 189.1 0zM208 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm184-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"/></svg>',
        'fence' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M80 32l-64 80 0 368 128 0 0-62.6 48 0 0 62.6 128 0 0-62.6 48 0 0 62.6 128 0 0-368-64-80-64 80 0 49.4-48 0 0-49.4-64-80-64 80 0 49.4-48 0 0-49.4-64-80zM368 225.4l0 128-48 0 0-128 48 0zm-176 0l0 128-48 0 0-128 48 0z"/></svg>',
        'tree' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256-32l-176 208 76.3 0-108.3 128 89.8 0-121.8 144 208 0 0 96 64 0 0-96 208 0-121.8-144 89.8 0-108.3-128 76.3 0-176-208z"/></svg>',
        'boxes-stacked' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M224 0l0 80 64 0 0-80 96 0 0 208-256 0 0-208 96 0zM512 512l-208 0 0-256 48 0 0 80 64 0 0-80 96 0 0 256zM256 256l0 256-256 0 0-256 96 0 0 80 64 0 0-80 96 0z"/></svg>',
        'users-viewfinder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M0 0l0 160 48 0 0-112 112 0 0-48-160 0zM576 0l-160 0 0 48 112 0 0 112 48 0 0-160zM24 512l136 0 0-48-112 0 0-112-48 0 0 160 24 0zm552 0l0-160-48 0 0 112-112 0 0 48 160 0zM352 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-176 0c0-16.8 3.7-32.8 10.4-47.2-3.4-.6-6.8-.8-10.4-.8-35.3 0-64 28.7-64 64s28.7 64 64 64c9.9 0 19.3-2.3 27.7-6.3-17.2-19.7-27.7-45.5-27.7-73.7zm224 80c35.3 0 64-28.7 64-64s-28.7-64-64-64c-3.5 0-7 .3-10.4 .8 6.7 14.3 10.4 30.3 10.4 47.2 0 28.2-10.4 54-27.7 73.7 8.4 4 17.8 6.3 27.7 6.3zM124.7 400l6.3-16.9 35.7-95.1-38.7 0-48 112 44.7 0zm326.5 0l44.7 0-48-112-38.7 0 35.7 95.1 6.3 16.9zM352 272l-128 0-48 128 224 0-48-128z"/></svg>',

        // UI
        'envelope' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 64l512 0 0 72-12.8 9.6-224 168-19.2 14.4-19.2-14.4-224-168-12.8-9.6 0-72zM0 196l256 192 256-192 0 252-512 0 0-252z"/></svg>',
        'grid-2' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M192 32l-192 0 0 192 192 0 0-192zm0 256l-192 0 0 192 192 0 0-192zM256 32l0 192 192 0 0-192-192 0zM448 288l-192 0 0 192 192 0 0-192z"/></svg>',
        'magnifying-glass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zm-208 144a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"/></svg>',
        'house-chimney' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 416 0 0-240zM320 464l-128 0 0-144 128 0 0 144z"/></svg>',
        'house-building' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M320 0l0 124.6 144 116.3 0 110.9-32 0 0 160.2 208 0 0-512-320 0zM440.2 160l-56.2-45.4 0-18.6 64 0 0 64-7.8 0zM576 96l0 64-64 0 0-64 64 0zM528 224l48 0 0 64-48 0 0-64zm48 128l0 64-64 0 0-64 64 0zM384 304l32 0 0-40-208-168-208 168 0 40 32 0 0 208 352 0 0-208zM256 272l0 96-96 0 0-96 96 0z"/></svg>',
        'input-pipe' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64 128l0 256 448 0 0-256-448 0zM0 64l576 0 0 384-576 0 0-384zM160 184l0 168-48 0 0-192 48 0 0 24z"/></svg>',
        'gear' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M200.1-16l112 0 19.7 95.5c14.1 6 27.3 13.7 39.3 22.8l92.6-30.7 56 97-72.9 64.8c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l72.9 64.8-56 97-92.6-30.7c-12.1 9.1-25.3 16.7-39.3 22.8l-19.7 95.5-112 0-19.7-95.5c-14.1-6-27.2-13.7-39.3-22.8l-92.6 30.7-56-97 72.9-64.8c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7l-72.9-64.8 56-97 92.6 30.7c12.1-9.1 25.3-16.7 39.3-22.8L200.1-16zm56 352a80 80 0 1 0 -.1-160 80 80 0 1 0 .1 160z"/></svg>',
        'gear-code' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M200.1-16l112 0 19.7 95.5c14.1 6 27.3 13.7 39.3 22.8l92.6-30.7 56 97-72.9 64.8c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l72.9 64.8-56 97-92.6-30.7c-12.1 9.1-25.3 16.7-39.3 22.8l-19.7 95.5-112 0-19.7-95.5c-14.1-6-27.2-13.7-39.3-22.8l-92.6 30.7-56-97 72.9-64.8c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7l-72.9-64.8 56-97 92.6 30.7c12.1-9.1 25.3-16.7 39.3-22.8L200.1-16zm99.5 172.5l4.5-19.5-39-9-4.5 19.5-48 208-4.5 19.5 39 9 4.5-19.5 48-208zM182.2 238.1l14.1-14.1-28.3-28.3c-6.5 6.5-21.8 21.8-46.1 46.1L107.8 256c6.5 6.5 21.8 21.8 46.1 46.1l14.1 14.1 28.3-28.3c-8.8-8.8-19.5-19.5-32-32l17.9-17.9zm176-28.3l-14.1-14.1-28.3 28.3c8.8 8.8 19.5 19.5 32 32-12.5 12.5-23.2 23.2-32 32l28.3 28.3c6.5-6.5 21.8-21.8 46.1-46.1L404.3 256c-6.5-6.5-21.8-21.8-46.1-46.1z"/></svg>',
        'pen' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M16 528L72 328 295 105 439 249 216 472 16 528zM473 215l-144-144 87-87 144 144-87 87z"/></svg>',
        'trash' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M144-16l-16 48-128 0 0 64 448 0 0-64-128 0-16-48-160 0zM416 144l-384 0 24 368 336 0 24-368z"/></svg>',
        'plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M256 64l0-32-64 0 0 192-192 0 0 64 192 0 0 192 64 0 0-192 192 0 0-64-192 0 0-160z"/></svg>',
        'circle-exclamation' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-368l0 144-48 0 0-144 48 0zM232 376l0-48 48 0 0 48-48 0z"/></svg>',
        'circle-question' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-336c-17.7 0-32 14.3-32 32l-48 0c0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.1-20.5 57.5-38.2 70-6.3 4.4-12.5 7.8-17.8 10.4l0 21.9-48 0 0-56.7c1.4-.4 2.7-.7 4.1-1.1 12.2-3.2 23.3-6.1 34.1-13.7 10.4-7.3 17.8-16.9 17.8-30.8 0-17.7-14.3-32-32-32zM232 344l48 0 0 48-48 0 0-48z"/></svg>',
        'info-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 336l24 0 0-64-48 0 0-48 96 0 0 112 32 0 0 48-128 0 0-48 24 0zm72-144l-64 0 0-64 64 0 0 64z"/></svg>',
        'clone' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M288 448l-224 0 0-224 48 0 0-64-112 0 0 352 352 0 0-112-64 0 0 48zm224-96l0-352-352 0 0 352 352 0z"/></svg>',
        'globe' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M351.6 280c-3.9 62.3-22.3 121.2-45.3 165.5-13 25-26.6 43.7-38.3 55.4-5.4 5.4-9.3 8.2-11.6 9.7-2.3-1.5-6.2-4.3-11.6-9.7-11.7-11.7-25.3-30.4-38.3-55.4-23-44.3-41.5-103.2-45.3-165.5l190.5 0zM161.1 232c3.9-62.3 22.3-121.2 45.3-165.5 13-25 26.6-43.7 38.3-55.4 5.4-5.4 9.3-8.2 11.6-9.7 2.3 1.5 6.2 4.3 11.6 9.7 11.7 11.7 25.3 30.4 38.3 55.4 23 44.3 41.5 103.2 45.3 165.5l-190.5 0zm-48.1 0L1.5 232C11.3 126.4 85.2 39.5 183.9 10.4 148.8 62.5 117.9 144 113.1 232zM1.5 280l111.6 0c4.9 88 35.7 169.5 70.9 221.6-98.7-29.1-172.6-116-182.4-221.6zm398.2 0l111.6 0c-9.8 105.6-83.7 192.5-182.4 221.6 35.2-52.1 66-133.6 70.9-221.6zm111.6-48l-111.6 0c-4.9-88-35.7-169.5-70.9-221.6 98.7 29.1 172.6 116 182.4 221.6z"/></svg>',

        // CD
        'grid-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 0H146.286V146.286H0V0ZM0 182.857H146.286V329.143H0V182.857ZM146.286 365.714V512H0V365.714H146.286ZM182.857 0H329.143V146.286H182.857V0ZM329.143 182.857V329.143H182.857V182.857H329.143ZM182.857 365.714H329.143V512H182.857V365.714ZM512 0V146.286H365.714V0H512ZM365.714 182.857H512V329.143H365.714V182.857ZM512 365.714V512H365.714V365.714H512Z"/></svg>',
        'list-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 0H512V146.286H0V0ZM0 182.857H512V329.143H0V182.857ZM512 365.714V512H0V365.714H512Z"/></svg>',
        'ellipse' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><circle cx="256" cy="256" r="256"/></svg>',
        'map-marker' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 49.5"><path d="M0,17.681C0,7.913,8.062,0,18,0s18,7.913,18,17.681c0,14.137-18,31.819-18,31.819,0,0-18-17.681-18-31.819Z" fill="#000000"/><circle cx="18" cy="18" r="6" fill="white"/></svg>',
    ];

    public const regular_sharp = [
        'angle-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M-1.5 256l17-17 160-160 17-17 33.9 33.9-17 17-143 143 143 143 17 17-33.9 33.9-17-17-160-160-17-17z"/></svg>',
        'angle-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M258.4 256l-17 17-160 160-17 17-33.9-33.9 17-17 143-143-143-143-17-17 33.9-33.9 17 17 160 160 17 17z"/></svg>',
        'arrow-rotate-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 0L48 102.1 75.1 75c100-100 262.1-100 362 0 50 50 75 115.5 75 181 0 141.4-114.6 256-256 256-102.4 0-190.7-60.1-231.6-146.8l43.4-20.5c33.3 70.6 105.1 119.3 188.2 119.3 114.9 0 208-93.1 208-208 0-53.3-20.3-106.5-60.9-147.1-81.2-81.2-212.9-81.2-294.2 0l-27.1 27.1 102.2 0 0 48-184.1 0 0-184 48 0z"/></svg>',
        'arrows-maximize' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M296 32l-24 0 0 48 94.1 0-142.1 142.1-142.1-142.1 94.1 0 0-48-176 0 0 176 48 0 0-94.1 142.1 142.1-142.1 142.1 0-94.1-48 0 0 176 176 0 0-48-94.1 0 142.1-142.1 142.1 142.1-94.1 0 0 48 176 0 0-176-48 0 0 94.1-142.1-142.1 142.1-142.1 0 94.1 48 0 0-176-152 0z"/></svg>',
        'ban' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M385.1 419.1L92.9 126.9c-28.1 35.5-44.9 80.3-44.9 129.1 0 114.9 93.1 208 208 208 48.8 0 93.7-16.8 129.1-44.9zm33.9-33.9c28.1-35.5 44.9-80.3 44.9-129.1 0-114.9-93.1-208-208-208-48.8 0-93.7 16.8-129.1 44.9L419.1 385.1zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"/></svg>',
        'bed-front' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M32 32l448 0 0 192 32 0 0 256-48 0 0-64-416 0 0 64-48 0 0-256 32 0 0-192zM432 144l-152 0 0 80 152 0 0-80zm-200 0l-152 0 0 80 152 0 0-80zM464 368l0-96-416 0 0 96 416 0z"/></svg>',
        'bus-simple' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M48 48l0 48 352 0 0-48-352 0zm0 96l0 64 352 0 0-64-352 0zM400 256l-352 0 0 144 352 0 0-144zM0 256l0-256 448 0 0 448-48 0 0 64-48 0 0-64-256 0 0 64-48 0 0-64-48 0 0-192zm128 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'car' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M112 32l-17.3 0-5.5 16.4-47.9 143.6-41.4 0 0 288 48 0 0-64 416 0 0 64 48 0 0-288-41.4 0-47.9-143.6-5.5-16.4-305.3 0zM420 192L92 192 129.3 80 382.7 80 420 192zM48 240l416 0 0 128-416 0 0-128zm64 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm320-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>',
        'caret-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M395.3 208L440 160 8 160c14.2 15.2 75.2 80.8 183.2 196.8L224 392c4.2-4.5 61.4-65.9 171.3-184zm-65.6 0L224 321.6 118.3 208 329.7 208z"/></svg>',
        'check' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M489.9 82.5l-14 19.5-264 368-16.5 23-20-20-136-136-17-17 33.9-33.9 17 17 116 116 247.5-345 14-19.5 39 28z"/></svg>',
        'check-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm97.1-319.6l-40.7-25.4c-.4 .6-25.1 40.1-74.2 118.7-20.1-26.8-33.9-45.2-41.4-55.2l-38.4 28.8c4 5.3 24.8 33.1 62.4 83.2l7.2 9.6 25.3 0 7-11.3 80-128 12.7-20.4z"/></svg>',
        'chevron-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256.4 425.9l17-17 200-200 17-17-33.9-33.9-17 17-183 183-183-183-17-17-33.9 33.9 17 17 200 200 17 17z"/></svg>',
        'chevron-up' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256.4 86.1l17 17 200 200 17 17-33.9 33.9-17-17-183-183-183 183-17 17-33.9-33.9 17-17 200-200 17-17z"/></svg>',
        'copy' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 336l-224 0 0-288 156.1 0 67.9 67.9 0 220.1zM448 96l-96-96-224 0 0 384 320 0 0-288zM48 128l-48 0 0 384 320 0 0-80-48 0 0 32-224 0 0-288 32 0 0-48-32 0z"/></svg>',
        'envelope-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 224.3l0 207.7 416 0 0-207.7-193.5 146.8-14.5 11-14.5-11-193.5-146.8zm402.8-50.2L256 28 61.2 174.1 256 321.9 450.8 174.1zM0 160l256-192 256 192 0 320-512 0 0-320z"/></svg>',
        'expand' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M136 32l24 0 0 48-112 0 0 112-48 0 0-160 136 0zM0 344l0-24 48 0 0 112 112 0 0 48-160 0 0-136zM424 32l24 0 0 160-48 0 0-112-112 0 0-48 136 0zM400 344l0-24 48 0 0 160-160 0 0-48 112 0 0-88z"/></svg>',
        'file-pdf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M208 48l-128 0 0 416 96 0 0 48-144 0 0-512 224 0 160 160 0 176-48 0 0-128-160 0 0-160zM348.1 160l-92.1-92.1 0 92.1 92.1 0zM240 380l32 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-12 0 0 48-40 0 0-168 20 0zm32 80c11 0 20-9 20-20s-9-20-20-20l-12 0 0 40 12 0zm96-80l32 0c28.7 0 52 23.3 52 52l0 64c0 28.7-23.3 52-52 52l-52 0 0-168 20 0zm32 128c6.6 0 12-5.4 12-12l0-64c0-6.6-5.4-12-12-12l-12 0 0 88 12 0zm76-128l88 0 0 40-48 0 0 24 48 0 0 40-48 0 0 64-40 0 0-168z"/></svg>',
        'graduation-cap' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288 16L23.1 133.7c-1.5 .7-9.2 4.1-23.1 10.3l0 336 48 0 0-282.7 48 21.3 0 165.3c0 53 86 96 192 96s192-43 192-96l0-165.3 72.9-32.4c1.5-.7 9.2-4.1 23.1-10.3l0-32c-13.9-6.2-21.6-9.6-23.1-10.3L288 16zM144 384l0-144 144 64 144-64 0 144c0 .1 0 .1 0 .3s-.1 .4-.3 .9c-.4 .9-1.3 2.7-3.4 5.2-4.4 5.2-12.6 11.9-26 18.6-26.8 13.4-67.1 23-114.3 23s-87.5-9.7-114.3-23c-13.4-6.7-21.6-13.4-26-18.6-2.1-2.5-3-4.3-3.4-5.2-.2-.5-.3-.8-.3-.9s0-.2 0-.3zM493.8 160L288 251.5 82.2 160 288 68.5 493.8 160z"/></svg>',
        'heart' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 496S0 319.4 0 167.7C0 94.2 58.6 32 133.1 32 167.7 32 200.5 45.4 225 68.8 237.1 80.3 246.3 94.4 256 107.9 265.7 94.4 274.9 80.3 287 68.8 311.5 45.4 344.4 32 378.9 32 453.5 32 512 94.2 512 167.7 512 319.4 256 496 256 496zm0-306.2l-53.9-74.5c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 33.3 15 64.6 32.5 92.2 21.3 33.7 50.6 67.1 81.2 97.2 30.4 30 61 55.6 84 73.8 3.6 2.9 7.1 5.5 10.3 8 3.2-2.5 6.6-5.1 10.3-8 23.1-18.2 53.6-43.8 84-73.8 30.6-30.1 59.8-63.6 81.2-97.3 17.5-27.6 32.6-58.8 32.6-92.2 0-47-38.1-85.1-85.1-85.1-27.3 0-53 13.1-69 35.2L256 189.8z"/></svg>',
        'heart-crack' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 167.7C0 319.4 256 496 256 496S512 319.4 512 167.7c0-73.5-58.5-135.7-133.1-135.7-34.5 0-67.3 13.4-91.9 36.8-10 9.5-18 20.8-25.9 32-1.7 2.4-3.4 4.7-5.1 7.1-1.7-2.4-3.4-4.7-5.1-7.1-8-11.2-15.9-22.4-25.9-32-24.5-23.4-57.4-36.8-91.9-36.8-74.6 0-133.1 62.2-133.1 135.7zM316.6 107c16-17.1 38.5-27 62.2-27 47 0 85.1 38.1 85.1 85.1 0 33.4-15 64.6-32.6 92.2-21.3 33.7-50.6 67.1-81.2 97.3-30.4 30-61 55.6-84 73.8-3.6 2.9-7.1 5.5-10.3 8-3.2-2.5-6.6-5.1-10.3-8-23.1-18.2-53.6-43.8-84-73.8-30.6-30.1-59.8-63.6-81.2-97.2-17.5-27.6-32.5-58.8-32.5-92.2 0-47 38.1-85.1 85.1-85.1 27.3 0 53 13.1 69 35.2l21.3 29.4-63.4 63.4 128 112-48-112 96-64-19.4-37z"/></svg>',
        'house-user' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288.4-8.2l16 14.4 232 208 17.9 16-32 35.7c-13.6-12.2-22.2-19.9-25.8-23.2l0 269.3-416 0 0-269.3c-3.7 3.3-12.3 11-25.8 23.2l-32-35.7 17.9-16 232-208 16-14.4zm0 64.5l-160 143.5 0 264.3 320 0 0-264.3-160-143.4zM232.4 224a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm136 96l32 96-224 0 32-96 160 0z"/></svg>',
        'image' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 80l0 352-352 0 0-352 352 0zM48 32l-48 0 0 448 448 0 0-448-400 0zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 48l-63.6 99.9-32.4-51.9-80 128 288 0-112-176z"/></svg>',
        'leaf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M512 24l0 186.9C512 342.1 403.9 448 273.2 448 191.7 448 121.9 392.4 101.8 316.8 68.7 347.5 48 391.3 48 440l0 40-48 0 0-40c0-75.1 38.3-141.2 96.4-179.9 6.1-91.7 82.4-164.1 175.6-164.1 58 0 107.5-21.8 143.2-44.3 19.9-12.6 38.4-27.3 55.1-43.9L512 24zM464 76.3c-7 5.1-14.7 10.6-23.2 15.9-40.4 25.5-98.8 51.7-168.8 51.7-57.6 0-106.4 38.1-122.4 90.4 20.9-6.8 43.2-10.4 66.4-10.4l104 0 0 48-104 0c-25.4 0-49.4 5.6-71 15.7 7.9 63.1 62.6 112.3 128.2 112.3 104.7 0 190.8-84.9 190.8-189.1l0-134.6z"/></svg>',
        'location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M48 188.6c0 28.1 9.1 61 25.6 96.5 16.3 35.1 38.4 70.1 61.3 101.5 20.3 28 40.8 52.5 57.2 71.1 16.4-18.6 36.8-43.1 57.2-71.1 22.9-31.4 45-66.4 61.3-101.5 16.4-35.5 25.6-68.4 25.6-96.5 0-76.8-63.7-140.6-144-140.6S48 111.7 48 188.6zm336 0c0 111.2-104.3 242.8-159.1 304.4-10.2 11.5-18.7 20.5-24.5 26.5-5.3 5.5-8.4 8.5-8.4 8.5s-3-3-8.4-8.5C177.8 513.5 169.3 504.4 159.1 493 104.3 431.4 0 299.8 0 188.6 0 84.4 86 0 192 0S384 84.4 384 188.6zM224 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-112 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"/></svg>',
        'paper-plane' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M322.2 287.8l185.1-185.1-124.7 338.4-60.4-153.4zm232.1-300L548.8-10.2 67.7 167.1 0 192C21.2 200.3 113.1 236.5 275.5 300.5 339.5 463 375.7 554.8 384 576l24.9-67.7 177.3-481.1 2-5.4 3.2-3.2-1.5-1.5 18.1-49.1-49.1 18.1-1.5-1.5-3.2 3.2zm-81 81L288.2 253.8 134.8 193.5 473.3 68.8z"/></svg>',
        'paper-plane-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M202 280L472.8 280 138.8 433.4 202 280zm270.8-48L202 232 138.8 78.6 472.8 232zM48-16C56.2 3.8 93.5 94.5 160 256 93.5 417.5 56.2 508.2 48 528L112 498.6 582.5 282.4 640 256 582.5 229.6 112 13.4 48-16z"/></svg>',
        'arrow-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M537.4 273l17-17-17-17-168-168-17-17-33.9 33.9 17 17 127 127-430.1 0 0 48 430.1 0-127 127-17 17 33.9 33.9 17-17 168-168z"/></svg>',
        'arrow-long-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M601.4 273l17-17-17-17-136-136-17-17-33.9 33.9 17 17 95 95-494.1 0 0 48 494.1 0-95 95-17 17 33.9 33.9 17-17 136-136z"/></svg>',
        'map-location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M576 48l0-38.6c-8 4-61.2 30.2-159.5 78.7l-184.8-62.8-9.2-3.1-8.8 4.1-136 64-13.8 6.5 0 405c7.3-3.4 61.2-28.8 161.5-76l167.3 55.8c-9.2-14.6-18.1-30.3-25.6-46.6-2.2-4.7-4.3-9.6-6.3-14.6l-104.9-35 0-301.1 128 43.5 0 106.7c13.4-15.6 29.7-28.6 48-38.4l0-62 96-47.4 0 90.1c16.8 1.6 32.9 5.6 48 11.7L576 48zM208 82.1l0 299-96 45.2 0-299 96-45.2zM512 224c-66.3 0-120 52.8-120 117.9 0 94.3 120 212.1 120 212.1S632 436.1 632 341.9C632 276.8 578.3 224 512 224zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"/></svg>',
        'pen' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M16 528c5.8-20.7 24.5-87.4 56-200L382.1 17.9 416-16C431.6-.4 468.3 36.3 526.1 94.1L560 128 526.1 161.9 216 472C103.4 503.5 36.8 522.2 16 528zm174.9-98.8L397.1 223 321 146.9 114.8 353 85.2 458.8 190.9 429.2zM431 189.1L492.1 128 416 51.9 354.9 113 431 189.1z"/></svg>',
        'percent' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M490.4 56l-17 17-400 400-17 17-33.9-33.9 17-17 400-400 17-17 33.9 33.9zM144.4 80l-64 0 0 64 64 0 0-64zm-64-48l112 0 0 160-160 0 0-160 48 0zm288 336l0 64 64 0 0-64-64 0zm-48-48l160 0 0 160-160 0 0-160z"/></svg>',
        'phone' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M220.6 195l51.8-51-96-160-144 80 0 16c0 238.6 193.4 432 432 432l16 0 80-144-160-96-51 51.8C290.2 301 243.4 254.2 220.6 195zM408.1 332.6l87.8 52.7-43.6 78.5C249.9 457.5 86.9 294.6 80.6 92.1l78.5-43.6 52.7 87.8c-17 16.8-32.8 32.3-47.3 46.6l11.3 29.4c27.7 71.9 84.5 128.6 156.3 156.3l29.4 11.3c14.3-14.5 29.8-30.3 46.6-47.3z"/></svg>',
        'plane-departure' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M517.9 132.9c16.6-6 35 2.5 41 19.1s-2.5 35-19.1 41l-338.3 123.1-7.5 2.7-48.8 17.8-65.6-112.3 1.2-.4 73 34.1 9 4.2 9.3-3.4c59.5-21.7 95.8-34.9 109-39.7-1.5-1.9-39.9-50.3-115.3-145.3l26.4-9.6 202.4 105.3 9.4 4.9 9.9-3.6 104-37.9zm86.1 2.7c-15.1-41.5-61-62.9-102.5-47.8l-94.1 34.2-202.4-105.3-9.4-4.9-9.9 3.6c-51.2 18.6-84.1 30.6-98.9 36 1.5 1.9 39.9 50.3 115.3 145.3l-37 13.5-73-34-9-4.2c-6.4 2.3-73.4 26.7-74 26.9l14.5 24.8 90.3 154.4 10.1 17.3c4.4-1.6 33.2-12.1 86.5-31.5l7.5-2.7 338.3-123.1c41.5-15.1 62.9-61 47.8-102.5zM56.4 464l-24 0 0 48 576 0 0-48-552 0z"/></svg>',
        'plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M248 56l0-24-48 0 0 200-200 0 0 48 200 0 0 200 48 0 0-200 200 0 0-48-200 0 0-176z"/></svg>',
        'minus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 232l448 0 0 48-448 0 0-48z"/></svg>',
        'ruler-triangle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64.3-29.3l0 509.3 509.3 0-48-48-413.3-413.3-48-48zm48 115.9L188 162.3c-14.4 14.4-27 27-37.7 37.7l33.9 33.9c10.7-10.7 23.2-23.2 37.7-37.7l46.1 46.1-21.7 21.7 33.9 33.9 17-17 4.7-4.7 46.1 46.1c-14.4 14.4-27 27-37.7 37.7l33.9 33.9c10.7-10.7 23.2-23.2 37.7-37.7l75.7 75.7-345.4 0 0-345.4zm80 185.1l0 80.2 80.2 0-80.2-80.2z"/></svg>',
        'share' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M82.7 427c35.8 37.4 77.7 53 77.7 53s-30.1-30.1-31.9-75.7c-.1-1.4-.1-2.8-.1-4.3 0-61.9 50.1-112 112-112l80 0 0 135.9c14-12.6 82-73.8 204-183.6L560.2 208c-3.9-3.5-67.9-61.1-191.8-172.7l-48-43.2 0 135.9-112 0c-97.2 0-176 78.8-176 176 0 54.8 23.5 95 50.3 123zm5.8-77.6c-5.1-13.3-8.2-28.4-8.2-45.4 0-70.7 57.3-128 128-128l112 0c26.5 0 48-21.5 48-48l0-28.1 120.1 108.1-120.1 108.1 0-28.1c0-26.5-21.5-48-48-48l-80 0c-70.7 0-130.6 45.8-151.8 109.4z"/></svg>',
        'share-nodes' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M432 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm48 0c0 53-43 96-96 96-27.4 0-52.1-11.5-69.6-29.9L188.9 231.8c2 7.7 3.1 15.8 3.1 24.2s-1.1 16.5-3.1 24.2l125.5 69.7c17.5-18.4 42.2-29.9 69.6-29.9 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-8.3 1.1-16.5 3.1-24.2L165.6 322.1C148.1 340.5 123.4 352 96 352 43 352 0 309 0 256s43-96 96-96c27.4 0 52.1 11.5 69.6 29.9l125.5-69.7c-2-7.7-3.1-15.8-3.1-24.2 0-53 43-96 96-96s96 43 96 96zM144 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM384 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/></svg>',
        'shop' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64 203.3l61.7-123.3 324.7 0 61.7 123.3 0 4.7-448 0 0-4.7zM16 256l48 0 0 224 288 0 0-224 112 0 0 224 48 0 0-224 48 0 0-64-80-160-384 0-80 160 0 64zm96 0l192 0 0 80-192 0 0-80zm0 128l192 0 0 48-192 0 0-48z"/></svg>',
        'shower' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M24 32l-24 0 0 448 48 0 0-400 62.1 0 17.8 17.8C99.1 142.2 104.1 202.1 143 241l7 7-16 16 33.9 33.9 17-17 160-160 17-17-33.9-33.9-16 16-7-7c-38.9-38.9-98.8-44-143.2-15.2L129.9 32 24 32zm153 81c26-26 68.1-26 94.1 0l7 7-94.1 94.1-7-7c-26-26-26-68.1 0-94.1zm239 79a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>',
        'table-layout' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 80l0 80-352 0 0-80 352 0zM0 160l0 320 448 0 0-448-448 0 0 128zM400 432l-240 0 0-224 240 0 0 224zm-288 0l-64 0 0-224 64 0 0 224z"/></svg>',
        'trash' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M144-16l160 0 24 64 120 0 0 48-448 0 0-48 120 0 24-64zM56 512l-27.3-368 48.1 0 23.7 320 246.8 0 23.7-320 48.1 0-27.3 368-336 0z"/></svg>',
        'trowel-bricks' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M224.2-8.6l0 112.6 288 0 0 48-288 0 0 112.6c-3.5-2.1-68.9-40.7-196.2-115.9L-7 128c2.5-1.5 67.5-39.9 195-115.2L224.2-8.6zM87.4 128l88.8 52.5 0-105-88.8 52.5zM288.2 336l0-128 224 0 0 304-512 0 0-176 288 0zm48 0l128 0 0-80-128 0 0 80zm-32 48l-48 0 0 80 208 0 0-80-160 0zm-256 0l0 80 160 0 0-80-160 0z"/></svg>',
        'video' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M80 112l0 288 288 0 0-288-288 0zM32 64l384 0 0 384-384 0 0-384zM528 384l-64-42.7 0-57.7 64 42.7 0-140.6-64 42.7 0-57.7c45.3-30.2 82.7-55.1 112-74.7l0 320-48-32z"/></svg>',
        'street-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 160l64 0c35.3 0 64 28.7 64 64l0 80-33.8 0-14.2 128-96 0-14.2-128-33.8 0 0-80c0-35.3 28.7-64 64-64zM412.4 400.2c-16.1-4.2-34.8-7.6-55.4-10.2l5.3-47.7c22.7 2.9 43.7 6.7 62.1 11.5 22.4 5.8 42.6 13.3 57.8 23.3 14.7 9.6 29.8 24.9 29.8 47s-15.1 37.4-29.8 47c-15.2 9.9-35.5 17.5-57.8 23.3-45.1 11.7-105.3 17.8-168.4 17.8s-123.3-6.1-168.4-17.8C65.2 488.4 45 480.9 29.8 471 15.1 461.4 0 446.1 0 424s15.1-37.4 29.8-47c15.2-9.9 35.5-17.5 57.8-23.3 18.5-4.8 39.5-8.6 62.1-11.5L155 390c-20.6 2.6-39.3 6.1-55.4 10.2-56.6 14.6-56.6 32.9 0 47.5 39.9 10.3 95.8 16.2 156.4 16.2s116.5-5.9 156.4-16.2c56.6-14.6 56.6-32.9 0-47.5z"/></svg>',
        'warning' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M16 480L42.3 432 260.6 33.9 288-16 315.4 33.9 533.7 432 560 480 16 480zM288 83.8L97.1 432 478.9 432 288 83.8zM264 200l0-8 48 0 0 128-48 0 0-120zm48 208l-48 0 0-48 48 0 0 48z"/></svg>',
        'water' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M136.2 62.2l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 116.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6zm0 144l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 260.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6zm8.9 147.6l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c82.9 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.8-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 404.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6 8.9 3.6z"/></svg>',
        'water-ladder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M449.2 385.7l111.8 44.7c29.3-9.8 50.1-16.7 62.5-20.8l15.2 45.5c-9.6 3.2-35.9 12-79.1 26.4l-8.2-3.3-111.1-44.4-120 48-120-48-111.1 44.4-8.2 3.3C37.9 467.2 11.6 458.4 2 455.2l15.2-45.5c12.4 4.1 33.2 11 62.4 20.8l111.8-44.7 8.9-3.6 120 48 120-48 8.9 3.6zM512.4 32c53 0 96 43 96 96l0 32-48 0 0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 212.2-24-9.6-24 9.6 0-68-208 0 0 61.6-8-3.2-26.8 10.7-13.2 5.3 0-218.6c0-53 43-96 96-96s96 43 96 96l0 32-48 0 0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 96.2 208 0 0-96.2c0-53 43-96 96-96z"/></svg>',
        'xmark-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM172.1 305.9l-17 17 33.9 33.9c5.8-5.8 28.1-28.1 66.9-66.9 38.8 38.8 61.1 61.1 66.9 66.9l33.9-33.9c-5.8-5.8-28.1-28.1-66.9-66.9 38.8-38.8 61.1-61.1 66.9-66.9l-33.9-33.9c-5.8 5.8-28.1 28.1-66.9 66.9l-66.9-66.9-33.9 33.9c5.8 5.8 28.1 28.1 66.9 66.9l-49.9 49.9z"/></svg>',
        'xmark-large' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M7.5 41C-1.8 31.6-1.8 16.4 7.5 7S32.1-2.3 41.5 7l215 215 215-215c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-215 215 215 215c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-215-215-215 215c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l215-215-215-215z"/></svg>',
        'door-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M80 48l0 416 192 0 0-416-192 0zm240 0l0 464-320 0 0-48 32 0 0-464 384 0 0 464 32 0 0 48-80 0 0-464-48 0zM240 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"/></svg>',
        'toilet' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 0l448 0 0 48-32 0 0 159.1 .4 .4c14.1 11.9 23.6 28.3 23.6 48.5 0 72.7-33.4 120.2-78.4 148.3-.9 .5-1.7 1.1-2.6 1.6 9.5 40.4 17.8 75.7 25 106.1L64 512c7.1-30.3 15.5-65.7 25-106.1-.9-.5-1.7-1-2.6-1.6-45-28.1-78.4-75.6-78.4-148.3 0-20.3 9.5-36.6 23.6-48.5L32 207.1 32 48 0 48 0 0zM133.5 426.1l-8.9 37.9 198.8 0-8.9-37.9C283.2 436.4 251.1 440 224 440s-59.2-3.6-90.5-13.9zm202.6-62.5c14.7-9.2 27.8-21.2 37.6-36.9-2.4 .8-4.9 1.5-7.4 2.3-38 10.9-88.7 14.9-142.4 14.9s-104.4-4-142.4-14.9c-2.5-.7-4.9-1.5-7.4-2.3 9.8 15.7 22.9 27.6 37.6 36.9 33.2 20.8 76.2 28.3 112.2 28.3s79-7.6 112.2-28.3zM62.6 268c6.1 5.1 16.5 10.4 32.3 15 31.5 9.1 76.8 13.1 129.1 13.1s97.7-4 129.1-13.1c15.8-4.5 26.2-9.8 32.2-15 5.4-4.6 6.6-8.2 6.6-12s-1.2-7.4-6.6-12c-6.1-5.1-16.5-10.4-32.2-15-31.5-9.1-76.8-13.1-129.1-13.1s-97.7 4-129.1 13.1c-15.8 4.5-26.2 9.8-32.3 15-5.4 4.6-6.6 8.2-6.6 12s1.2 7.4 6.6 12zM368 48l-288 0 0 135.4 1.6-.5C119.6 172 170.3 168 224 168s104.4 4 142.4 14.9l1.6 .5 0-135.4zM128 80l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"/></svg>',
        'bath' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M56 0l-24 0 0 256-32 0 0 48 32 0 0 64c0 28.4 12.4 54 32 71.6l0 72.4 48 0 0-49.3c5.2 .9 10.5 1.3 16 1.3l256 0c5.5 0 10.8-.5 16-1.3l0 49.3 48 0 0-72.4c19.6-17.6 32-43.1 32-71.6l0-64 32 0 0-48-432 0 0-208 30.1 0 11 11c-5.8 11.1-9.1 23.7-9.1 37 0 23.6 10.2 44.9 26.5 59.5l-12.5 12.5 33.9 33.9 17-17 104-104 17-17-33.9-33.9-12.5 12.5c-14.6-16.3-35.9-26.5-59.5-26.5-13.4 0-25.9 3.3-37 9.1L129.9 0 56 0zM217.5 76.6l-44.8 44.8c-7.7-5.8-12.6-15.1-12.6-25.5 0-17.7 14.3-32 32-32 10.4 0 19.6 4.9 25.5 12.6zM80 304l352 0 0 64c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-64z"/></svg>',
        'oven' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 48l0 128-352 0 0-128 352 0zm0 176l0 240-352 0 0-240 352 0zM48 0L0 0 0 512 448 512 448 0 48 0zm80 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm104-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 272l0 48 256 0 0-48-256 0z"/></svg>',
        'couch' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M88 64l-24 0 0 160-64 0 0 224 640 0 0-224-64 0 0-160-488 0zM528 224l-32 0 0 64-352 0 0-64-32 0 0-112 416 0 0 112zM48 400l0-128 48 0 0 64 448 0 0-64 48 0 0 128-544 0z"/></svg>',
        'hotel' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M512 0l-512 0 0 48 32 0 0 416-32 0 0 48 512 0 0-48-32 0 0-416 32 0 0-48zM432 464l-144 0 0-80 64 0c0-53-43-96-96-96s-96 43-96 96l64 0 0 80-144 0 0-416 352 0 0 416zM192 96l-64 0 0 64 64 0 0-64zm32 0l0 64 64 0 0-64-64 0zm160 0l-64 0 0 64 64 0 0-64zM128 192l0 64 64 0 0-64-64 0zm160 0l-64 0 0 64 64 0 0-64zm32 0l0 64 64 0 0-64-64 0z"/></svg>',
        'moon-stars' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M448-32l-16 48-48 16 48 16 16 48 16-48 48-16-48-16-16-48zM314.7 83.1c-23.7-10.5-49.6-17-76.8-18.7-4.6-.3-9.3-.4-13.9-.4-123.7 0-224 100.3-224 224S100.3 512 224 512c45.1 0 87.1-13.3 122.2-36.3 3.7-2.4 7.3-4.9 10.8-7.5 17.8-13.1 33.5-28.8 46.8-46.6-14.9 4.1-30.6 6.3-46.8 6.3-8.2 0-16.3-.6-24.2-1.7-85.2-11.8-150.8-84.9-150.8-173.3 0-56.7 26.9-107 68.7-139 18.7-14.4 40.5-25 64.1-30.9zM179.8 117.6c-28.7 37.5-45.8 84.5-45.8 135.4 0 92 55.8 171.1 135.3 205.1-14.5 3.8-29.7 5.9-45.3 5.9-97.2 0-176-78.8-176-176 0-81.9 56-150.8 131.8-170.4zM384 352L412.8 268.8 496 240 412.8 211.2 384 128 355.2 211.2 272 240 355.2 268.8 384 352z"/></svg>',
        'grid-2-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M144 80l0 96-96 0 0-96 96 0zM48 32l-48 0 0 192 192 0 0-192-144 0zm96 304l0 96-96 0 0-96 96 0zM48 288l-48 0 0 192 192 0 0-192-144 0zM304 80l96 0 0 96-96 0 0-96zM256 32l0 192 192 0 0-192-192 0zM376 288l-48 0 0 72-72 0 0 48 72 0 0 72 48 0 0-72 72 0 0-48-72 0 0-72z"/></svg>',
        'layer-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M488-8l0 32 56 0 0 48-56 0 0 56-48 0 0-56-56 0 0-48 56 0 0-56 48 0 0 24zM447.3 224L288 149 128.7 224 288 299 447.3 224zM288 352c-170.3-80.1-261-122.8-272-128 11-5.2 101.7-47.9 272-128 170.3 80.1 261 122.8 272 128-11 5.2-101.7 47.9-272 128zM72.4 357.5l57.3-27 56.4 26.5-57.3 27 159.3 75 159.3-75-57.3-27 56.4-26.5c38.3 18 76.2 35.9 113.6 53.5-11 5.2-101.7 47.9-272 128-170.3-80.1-261-122.8-272-128l56.4-26.5z"/></svg>',
        'layer-group' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288 203L128.7 128 288 53 447.3 128 288 203zM72.4 154.5L288 256C458.3 175.9 549 133.2 560 128 549 122.8 458.3 80.1 288 0 117.7 80.1 27 122.8 16 128l56.4 26.5zm23.3 64c-10 4.7-36.5 17.2-79.6 37.5 11 5.2 101.7 47.9 272 128 170.3-80.1 261-122.8 272-128-43.1-20.3-69.6-32.8-79.6-37.5L424 245 447.3 256 288 331 128.7 256 152 245 95.6 218.5zm-23.3 139L16 384c11 5.2 101.7 47.9 272 128 170.3-80.1 261-122.8 272-128-43.1-20.3-69.6-32.8-79.6-37.5l-56.4 26.5 23.3 11-159.3 75-159.3-75 23.3-11-56.4-26.5-23.3 11z"/></svg>',
        'lamp' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M51.3 288l-51.3 0 96-256 256 0 96 256-144 0 0 28.1c29.3 23.5 48 59.5 48 99.9 0 38.2-16.8 72.5-43.3 96l-169.3 0c-26.6-23.5-43.3-57.8-43.3-96 0-40.4 18.7-76.5 48-99.9l0-28.1-92.7 0zM144 240l234.7 0-60-160-189.5 0-60 160 74.7 0zm48 48l0 51.1-18 14.4c-18.4 14.7-30 37.2-30 62.5 0 18 5.9 34.6 16 48l128 0c10.1-13.4 16-30 16-48 0-25.2-11.6-47.7-30-62.5l-18-14.4 0-51.1-64 0z"/></svg>',
        'stairs' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M384 32l192 0 0 48-144 0 0 144-128 0 0 128-128 0 0 128-176 0 0-48 128 0 0-128 128 0 0-128 128 0 0-144z"/></svg>',
        'file-certificate' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M304 48l-128 0 0 102.6c-15.3-4.3-31.4-6.6-48-6.6l0-144 224 0 160 160 0 352-256 0 0-48 208 0 0-256-160 0 0-160zM444.1 160l-92.1-92.1 0 92.1 92.1 0zM208 419.9l0 132.1-80-40-80 40 0-132.1C18.7 396.5 0 360.4 0 320 0 249.3 57.3 192 128 192s128 57.3 128 128c0 40.4-18.7 76.5-48 99.9zM176 320a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/></svg>',
        'chart-pie' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M512 288l64 0c-4.8 72.8-42 136.7-97.4 177.4L331.5 288 512 288zM256.5 272.6c4 4.9 65.8 79.5 128.4 155l29.2 35.3 1.5 1.8c-13 9.6-26.9 18-41.7 24.9-30.8 14.4-65.2 22.4-101.4 22.4-132.5 0-240-107.5-240-240 0-110.4 74.5-203.4 176-231.4 15.4-4.3 31.5-7 48-8.1l0 240.1zm-37 30.6l-11-13.3 0-199c-74.6 26.4-128 97.5-128 181.1 0 106 86 192 192 192 24.5 0 48-4.6 69.5-12.9L219.5 303.3zM352.5 54l0 138 138 0c-17.4-67.5-70.5-120.6-138-138zm192 186l-240 0 0-240c16.4 0 32.5 1.7 48 4.8 94 19.1 168.1 93.2 187.2 187.2 3.1 15.5 4.8 31.6 4.8 48z"/></svg>',
        'road' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M60.6 432l171.4 0 0-64 48 0 0 64 171.4 0-82.8-352-88.6 0 0 64-48 0 0-64-88.6 0-82.8 352zM105.4 32l301.2 0 94.1 400 11.3 48-512 0 11.3-48 94.1-400zM280 216l0 104-48 0 0-128 48 0 0 24z"/></svg>',
        'star' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288.2-52.8c5.9 11.7 36.8 72.1 92.6 181.4 121.2 19.3 188.2 29.9 201.1 32-9.2 9.3-57.2 57.3-143.9 144.1 19.1 121.2 29.7 188.2 31.7 201.2-11.7-5.9-72.2-36.7-181.5-92.3-109.3 55.6-169.8 86.4-181.5 92.3 2-12.9 12.6-80 31.7-201.2-86.7-86.8-134.7-134.8-143.9-144.1 12.9-2.1 80-12.7 201.1-32 55.8-109.3 86.6-169.7 92.6-181.4zm0 105.6l-55.4 108.5-5.6 10.9-12.1 1.9-120.3 19.1 86.1 86.2 8.6 8.6-1.9 12.1-19 120.3 108.6-55.2 10.9-5.5 10.9 5.5 108.6 55.2-19-120.3-1.9-12.1 8.6-8.6 86.1-86.2-120.3-19.1-12.1-1.9-5.6-10.9-55.4-108.5z"/></svg>',
        'cube' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M16.5 117.5l239.8-138.5 239.8 138.5 0 277-239.8 138.5-239.8-138.5 0-277zm407.7 13.9l-167.8-96.9-167.8 96.9 167.8 96.9 167.8-96.9zM64.5 173l0 193.8 167.8 96.9 0-193.8-167.8-96.9zM280.3 463.7l167.8-96.9 0-193.8-167.8 96.9 0 193.8z"/></svg>',
        'house-window' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288.4-8.2l16 14.4 232 208 17.9 16-32 35.7c-13.6-12.2-22.2-19.9-25.8-23.2l0 269.3-416 0 0-269.3c-3.7 3.3-12.3 11-25.8 23.2l-32-35.7 17.9-16 232-208 16-14.4zm0 64.5l-160 143.5 0 264.3 320 0 0-264.3-160-143.4zM256.4 256l0 64 64 0 0-64-64 0zm-48-48l160 0 0 160-160 0 0-160z"/></svg>',
        'window-frame' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 464l32 0 0 48-448 0 0-48 32 0 0-464 384 0 0 464zM80 464l120 0 0-184-120 0 0 184zm0-232l120 0 0-184-120 0 0 184zm168 48l0 184 120 0 0-184-120 0zm120-48l0-184-120 0 0 184 120 0z"/></svg>',
        'compass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm184-72l200-56-56 200-200 56 56-200zm104 72a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>',
        'hammer-brush' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M120-16C53.7-16 0 37.7 0 104l0 40 89.4 0 22.6 13.6 0 354.4 128 0 0-354.4 22.6-13.6 41.4 0 0 16 48 0 0-160-48 0 0 16-38.1 0c-19.6-19.6-30.3-30.3-32-32l-9.9 0-104 0zm40 480l0-296 32 0 0 296-32 0zM304 64l0 32-54.6 0-5.7 3.4-34.3 20.6-66.7 0-34.3-20.6-5.7-3.4-54.2 0c4-36 34.5-64 71.6-64l94.1 0c19.6 19.6 30.3 30.3 32 32l9.9 0 48 0zM424 0l-24 0 0 197.3-72.1 64.8-7.9 7.2 0 242.7 288 0 0-242.7-7.9-7.2-72.1-64.8 0-197.3-104 0zm24 208l0-160 32 0 0 170.7 7.9 7.2 69.1 62.2-186 0 69.1-62.2 7.9-7.2 0-10.7zM368 336l192 0 0 128-96 0 0-80-48 0 0 80-48 0 0-128z"/></svg>',
        'file-signature' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M112 48l128 0 0 160 160 0 0 107.7 48-48 0-107.7-160-160-224 0 0 512 212.2 0 8-48-172.2 0 0-416zM302.8 368l-33.4-66.7-6.6-13.3-42.2 0-7.2 8.8-72 88 37.2 30.4 58.5-71.5c23.5 46.9 35.5 71 36.1 72.3l26.5 0 48-48-44.8 0zM288 67.9l92.1 92.1-92.1 0 0-92.1zm256 172l-52.8 52.8 80 80 52.8-52.8-80-80zm-208 208l-16 96 96-16 132.6-132.6-80-80-132.6 132.6z"/></svg>',
        'key' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M315.7 302.4l-24.2-3.8c-11.1 11.1-23.6 23.6-37.4 37.4l-78.1 0 0 64-64 0 0 64-64 0 0-78.1 148.1-148.1 17.3-17.3-3.8-24.2c-1-6.6-1.6-13.4-1.6-20.3 0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128c-6.9 0-13.7-.6-20.3-1.6zM272 384l1.9 0c1.3-1.3 12.7-12.7 34.2-34.2 9.1 1.4 18.4 2.2 27.9 2.2 97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 9.5 .7 18.8 2.2 27.9l-155.2 155.2-7 7 0 145.9 160 0 0-64 64 0 0-64 48 0zm96-208a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
        'coins' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M320 0c48.9 0 93.9 8.4 127.6 21.7 16.7 6.6 31.8 14.9 43.1 24.8 11 9.7 21.3 23.7 21.3 41.5l0 208c0 17.8-10.4 31.8-21.3 41.5-11.3 10-26.3 18.2-43.1 24.8-5 2-10.2 3.8-15.6 5.5l0-51c12.6-5.2 21.5-10.6 26.9-15.4 3.9-3.4 4.9-5.4 5.1-6l0-40.2c-9.8 4.1-20.6 7.7-32 10.8l0-50.1c7.8-2.6 14.7-5.3 20.5-8.2 4.9-2.4 8.6-4.7 11.5-6.7l0-52.7c-5.3 2.6-10.9 5-16.7 7.2-9.1 3.5-19.1 6.6-29.7 9.2-6.7-11.2-14.9-20.3-22.7-27.3-5.3-4.8-10.9-9.1-16.8-13 50.5-6.2 85.8-20.3 85.8-36.6 0-20-64.5-40-144-40-69.1 0-126.8 15.1-140.8 32.2-17.4 .4-34.5 1.7-51.1 3.9 1.4-15.9 11-28.6 21.2-37.5 11.3-10 26.3-18.2 43.1-24.8 33.7-13.3 78.7-21.7 127.6-21.7zM64.4 149.7C98.1 136.4 143.1 128 192 128s93.9 8.4 127.6 21.7c16.7 6.6 31.8 14.9 43.1 24.8 11 9.7 21.3 23.7 21.3 41.5l0 208c0 17.8-10.4 31.8-21.3 41.5-11.3 10-26.3 18.2-43.1 24.8-33.7 13.3-78.7 21.7-127.6 21.7s-93.9-8.4-127.6-21.7c-16.7-6.6-31.8-14.9-43.1-24.8-11-9.7-21.3-23.7-21.3-41.5L0 216c0-17.8 10.4-31.8 21.3-41.5 11.3-10 26.3-18.2 43.1-24.8zm254.9 134C285.6 296.5 240.5 304 192 304s-93.6-7.5-127.3-20.3c-5.8-2.2-11.4-4.6-16.7-7.2l0 52.7c2.8 2.1 6.6 4.3 11.5 6.7 9.1 4.5 20.8 8.7 34.7 12.4 27.7 7.3 62.2 11.8 97.8 11.8s70.1-4.5 97.8-11.8c13.9-3.7 25.6-7.9 34.7-12.4 4.9-2.4 8.6-4.7 11.5-6.7l0-52.7c-5.3 2.6-10.9 5-16.7 7.2zM48 383.3l0 40.2c.2 .6 1.2 2.6 5.1 6 5.7 5 15.3 10.8 28.9 16.2 27.1 10.7 66.1 18.3 110 18.3s82.8-7.6 110-18.3c13.7-5.4 23.2-11.1 28.9-16.2 3.9-3.4 4.9-5.4 5.1-6l0-40.2c-10.4 4.4-21.8 8.1-33.9 11.3-32.1 8.5-70.8 13.3-110.1 13.3s-77.9-4.9-110-13.3c-12.1-3.2-23.6-7-34-11.3zM336 216c0-20-64.5-40-144-40S48 196 48 216c0 22.1 64.5 40 144 40s144-17.9 144-40z"/></svg>',
        'object-exclude' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 48l256 0 0 64 48 0 0-112-352 0 0 352 112 0 0-48-64 0 0-256zM208 160l-48 0 0 64 48 0 0-16 48 0 0-48-48 0zM160 272l0 80 48 0 0-80-48 0zm96 80l96 0 0-64-48 0 0 16-48 0 0 48zm96-192l-48 0 0 80 48 0 0-80zM160 400l0 112 352 0 0-352-112 0 0 48 64 0 0 256-256 0 0-64-48 0z"/></svg>',
        'square-dashed' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M24 32l88 0 0 48-64 0 0 64-48 0 0-112 24 0zM0 192l48 0 0 128-48 0 0-128zm400 0l48 0 0 128-48 0 0-128zm48-48l-48 0 0-64-64 0 0-48 112 0 0 112zm0 224l0 112-112 0 0-48 64 0 0-64 48 0zM48 368l0 64 64 0 0 48-112 0 0-112 48 0zM288 480l-128 0 0-48 128 0 0 48zM160 80l0-48 128 0 0 48-128 0z"/></svg>',
        'chart-pyramid' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M16 480L42.3 432 260.6 33.9 288-16 315.4 33.9 533.7 432 560 480 16 480zM435.1 352l-294.1 0-43.9 80 381.9 0-43.9-80zm-26.3-48l-43.9-80-153.7 0-43.9 80 241.5 0zM237.5 176l101.1 0-50.5-92.2-50.5 92.2z"/></svg>',
        'vector-square' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M424 40l0 48 48 0 0-48-48 0zM384 0l128 0 0 128-40 0 0 256 40 0 0 128-128 0 0-40-256 0 0 40-128 0 0-128 40 0 0-256-40 0 0-128 128 0 0 40 256 0 0-40zm0 88l-256 0 0 40-40 0 0 256 40 0 0 40 256 0 0-40 40 0 0-256-40 0 0-40zM88 424l-48 0 0 48 48 0 0-48zm384 0l-48 0 0 48 48 0 0-48zM88 40l-48 0 0 48 48 0 0-48z"/></svg>',
        'diagram-cells' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 80l-352 0 0 96 352 0 0-96zm48 96l0 48-448 0 0-192 448 0 0 144zM400 336l-352 0 0 96 352 0 0-96zm48 96l0 48-448 0 0-192 448 0 0 144z"/></svg>',
        'border-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 32l448 0 0 48-448 0 0-48zM0 160l64 0 0 64-64 0 0-64zm448 0l0 64-64 0 0-64 64 0zM0 288l64 0 0 64-64 0 0-64zm448 0l0 64-64 0 0-64 64 0zM0 416l64 0 0 64-64 0 0-64zm448 0l0 64-64 0 0-64 64 0zm-320 0l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0z"/></svg>',
        'border-none' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 416l0 64 64 0 0-64-64 0zM128 32l0 64 64 0 0-64-64 0zM256 416l0 64 64 0 0-64-64 0zM128 480l64 0 0-64-64 0 0 64zM256 32l0 64 64 0 0-64-64 0zM384 480l64 0 0-64-64 0 0 64zm0-384l64 0 0-64-64 0 0 64zM0 32l0 64 64 0 0-64-64 0zM384 352l64 0 0-64-64 0 0 64zM0 160l0 64 64 0 0-64-64 0zM0 352l64 0 0-64-64 0 0 64zM384 160l0 64 64 0 0-64-64 0z"/></svg>',
        'car-garage' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M528 192l-480 0 0 320-48 0 0-400 288-112 288 112 0 400-48 0 0-320zm-2.1-48L288 51.5 50.1 144 525.9 144zM207.1 240l175.1 0 7.1 11.3 55.1 88 3.7 5.8 0 164.9-48 0 0-46-224 0 0 46-48 0 0-164.9 3.7-5.8 55.1-88 7.1-11.3 13.3 0zM400 416l0-32-224 0 0 32 224 0zM355.6 288l-135.2 0-30.1 48 195.3 0-30.1-48z"/></svg>',
        'fence' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 432l48 0 0-301.6-24-26.7-24 26.7 0 301.6zM0 112c27.7-30.8 51.7-57.5 72-80 20.3 22.5 44.3 49.2 72 80l0 49.4 40 0 0-49.4c27.7-30.8 51.7-57.5 72-80 20.3 22.5 44.3 49.2 72 80l0 49.4 40 0 0-49.4c27.7-30.8 51.7-57.5 72-80 20.3 22.5 44.3 49.2 72 80l0 368-144 0 0-80-40 0 0 80-144 0 0-80-40 0 0 80-144 0 0-368zM368 352l0-142.6-40 0 0 142.6 40 0zM144 209.4l0 142.6 40 0 0-142.6-40 0zm88-79l0 301.6 48 0 0-301.6-24-26.7-24 26.7zM416 432l48 0 0-301.6-24-26.7-24 26.7 0 301.6z"/></svg>',
        'tree' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M274.4-23.5l136 160 33.6 39.5-65.7 0c49.7 68.6 80.7 111.2 92.8 128l-73.9 0c60.4 81.8 95.9 129.7 106.4 144l-223.6 0 0 96-48 0 0-96-223.6 0c10.5-14.2 46-62.3 106.4-144L41 304c12.1-16.8 43.1-59.4 92.8-128l-65.7 0 33.6-39.5 136-160 18.3-21.5 18.3 21.5zM171.9 128l56 0c-12.2 16.8-43.1 59.4-92.8 128l74.9 0c-10.5 14.2-46 62.3-106.4 144l304.9 0c-60.4-81.8-95.9-129.7-106.4-144l74.9 0c-49.7-68.6-80.6-111.2-92.8-128l56 0-84.1-99-84.1 99z"/></svg>',
        'boxes-stacked' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M368 48l0 128 48 0 0-176-320 0 0 176 48 0 0-128 64 0 0 80 96 0 0-80 64 0zM336 512l176 0 0-288-176 0 0 128 80 0 0-80 48 0 0 192-128 0 0 48zM240 272l0 192-192 0 0-192 48 0 0 80 96 0 0-80 48 0zM48 224l-48 0 0 288 288 0 0-288-240 0z"/></svg>',
        'users-viewfinder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M0 0l0 160 48 0 0-112 112 0 0-48-160 0zM576 0l-160 0 0 48 112 0 0 112 48 0 0-160zM24 512l136 0 0-48-112 0 0-112-48 0 0 160 24 0zm552 0l0-160-48 0 0 112-112 0 0 48 160 0zM256 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM176 416l49.5 0 20-80 85 0 20 80 49.5 0-32-128-160 0-32 128zM154.6 304l-42.6 0-32 112 46.5 0 2.9-11.6 24.4-97.7c.2-.9 .5-1.8 .7-2.7zM449.5 416l46.5 0-32-112-42.6 0c.2 .9 .5 1.8 .7 2.7l24.4 97.7 2.9 11.6zM168.7 113.6c-32.4 7-56.7 35.9-56.7 70.4 0 39.8 32.2 72 72 72 5.9 0 11.6-.7 17.1-2-25.3-23.4-41.1-56.8-41.1-94 0-16.4 3.1-32 8.7-46.4zM374.9 254c5.5 1.3 11.2 2 17.1 2 39.8 0 72-32.2 72-72 0-34.5-24.3-63.3-56.7-70.4 5.6 14.4 8.7 30 8.7 46.4 0 37.1-15.8 70.6-41.1 94z"/></svg>',

        // UI
        'grid-2' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M48 80l0 96 96 0 0-96-96 0zM0 32l192 0 0 192-192 0 0-192zM48 336l0 96 96 0 0-96-96 0zM0 288l192 0 0 192-192 0 0-192zM400 80l-96 0 0 96 96 0 0-96zM304 32l144 0 0 192-192 0 0-192 48 0zm0 304l0 96 96 0 0-96-96 0zm-48-48l192 0 0 192-192 0 0-192z"/></svg>',
        'magnifying-glass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M400.4 208a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM369.6 371.1c-35.5 28.1-80.3 44.9-129.1 44.9-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208c0 48.8-16.8 93.7-44.9 129.1l133.9 133.9 17 17-33.9 33.9-17-17-133.9-133.9z"/></svg>',
        'house-chimney' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M304.4 6.1l-16-14.4-16 14.4-232 208-17.9 16 32 35.7c13.6-12.2 22.2-19.9 25.8-23.2l0 269.3 416 0 0-269.3c3.7 3.3 12.3 11 25.8 23.2l32-35.7c-8.2-7.4-27.5-24.7-57.9-51.9l0-114.2-48 0 0 71.2-144-129.1zm144 193.6l0 264.3-64 0 0-176.5-192 0 0 176.5-64 0 0-264.3 160-143.5 160 143.4zM240.4 464l0-128.5 96 0 0 128.5-96 0z"/></svg>',
        'house-building' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M336 48l256 0 0 416-160 0 0 48 208 0 0-512-352 0 0 94.2 48 41.7 0-87.9zM544 96l-64 0 0 64 64 0 0-64zM384 96l0 64 64 0 0-64-64 0zM32 289.2l0 222.8 352 0 0-222.8 23.7-27.3-184-160-15.7-13.7-15.7 13.7-184 160 23.8 27.3zm48-26.1l128-111.3 128 111.3 0 200.9-256 0 0-200.9zM256 272l-96 0 0 96 96 0 0-96zm288-80l-64 0 0 64 64 0 0-64zm-64 96l0 64 64 0 0-64-64 0z"/></svg>',
        'input-pipe' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M48 112l0 288 480 0 0-288-480 0zM0 64l576 0 0 384-576 0 0-384zM160 184l0 168-48 0 0-192 48 0 0 24z"/></svg>',
        'gear' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232.2-16L213-16c-1 4.2-7.5 33.2-19.6 86.8-6.3 3.2-12.3 6.7-18.2 10.5l-85-26.4-9.6 16.6-56 97-9.6 16.6c3.2 2.9 25 23.1 65.4 60.4-.3 6.9-.3 14 0 21-40.4 37.3-62.2 57.5-65.4 60.4l9.6 16.6 56 97 9.6 16.6c4.2-1.3 32.5-10.1 85-26.4 5.9 3.8 11.9 7.3 18.2 10.5 12.1 53.6 18.6 82.6 19.6 86.8l150.4 0c1-4.2 7.5-33.2 19.6-86.8 6.2-3.2 12.3-6.7 18.2-10.5 52.5 16.3 80.8 25.1 85 26.4l9.6-16.6 56-97 9.6-16.6c-3.2-2.9-25-23.1-65.4-60.4 .3-6.9 .3-14 0-21 40.4-37.3 62.2-57.5 65.4-60.4l-9.6-16.6-56-97-9.6-16.6c-4.2 1.3-32.5 10.1-85 26.4-5.9-3.8-11.9-7.3-18.2-10.5-12.1-53.6-18.6-82.6-19.6-86.8L232.2-16zm5.5 108.7l13.7-60.7 73.6 0 13.7 60.7 2.7 11.8 11.1 4.9c10.8 4.8 21 10.7 30.4 17.6l9.8 7.2 11.6-3.6 59.5-18.5 36.8 63.8-45.8 42.3-8.9 8.2 1.3 12c.6 5.8 1 11.6 1 17.6s-.3 11.8-1 17.6l-1.3 12 8.9 8.2 45.8 42.3-36.8 63.8-59.5-18.5-11.6-3.6-9.8 7.2c-9.4 6.9-19.6 12.9-30.4 17.6l-11.1 4.9-2.7 11.8-13.7 60.7-73.6 0-13.7-60.7-2.7-11.8-11.1-4.9c-10.8-4.8-21-10.7-30.4-17.6l-9.8-7.2-11.6 3.6-59.5 18.5-36.8-63.8 45.8-42.3 8.9-8.2-1.3-12c-.6-5.8-1-11.6-1-17.6s.3-11.8 1-17.6l1.3-12-8.9-8.2-45.8-42.3 36.8-63.8 59.5 18.5 11.6 3.6 9.8-7.2c9.4-6.9 19.6-12.9 30.4-17.6l11.1-4.9 2.7-11.8zM335.8 256a47.8 47.8 0 1 1 -95.7 0 47.8 47.8 0 1 1 95.7 0zm-47.7-96a96 96 0 1 0 -.3 192 96 96 0 1 0 .3-192z"/></svg>',
        'gear-code' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232.2-16L213-16c-1 4.2-7.5 33.2-19.6 86.8-6.3 3.2-12.3 6.7-18.2 10.5l-85-26.4-9.6 16.6-56 97-9.6 16.6c3.2 2.9 25 23.1 65.4 60.4-.3 6.9-.3 14 0 21-40.4 37.3-62.2 57.5-65.4 60.4l9.6 16.6 56 97 9.6 16.6c4.2-1.3 32.5-10.1 85-26.4 5.9 3.8 11.9 7.3 18.2 10.5 12.1 53.6 18.6 82.6 19.6 86.8l150.4 0c1-4.2 7.5-33.2 19.6-86.8 6.2-3.2 12.3-6.7 18.2-10.5 52.5 16.3 80.8 25.1 85 26.4l9.6-16.6 56-97 9.6-16.6c-3.2-2.9-25-23.1-65.4-60.4 .3-6.9 .3-14 0-21 40.4-37.3 62.2-57.5 65.4-60.4l-9.6-16.6-56-97-9.6-16.6c-4.2 1.3-32.5 10.1-85 26.4-5.9-3.8-11.9-7.3-18.2-10.5-12.1-53.6-18.6-82.6-19.6-86.8L232.2-16zm5.5 108.7l13.7-60.7 73.6 0 13.7 60.7 2.7 11.8 11.1 4.9c10.8 4.8 21 10.7 30.4 17.6l9.8 7.2 11.6-3.6 59.5-18.5 36.8 63.8-45.8 42.3-8.9 8.2 1.3 12c.6 5.8 1 11.6 1 17.6s-.3 11.8-1 17.6l-1.3 12 8.9 8.2 45.8 42.3-36.8 63.8-59.5-18.5-11.6-3.6-9.8 7.2c-9.4 6.9-19.6 12.9-30.4 17.6l-11.1 4.9-2.7 11.8-13.7 60.7-73.6 0-13.7-60.7-2.7-11.8-11.1-4.9c-10.8-4.8-21-10.7-30.4-17.6l-9.8-7.2-11.6 3.6-59.5 18.5-36.8-63.8 45.8-42.3 8.9-8.2-1.3-12c-.6-5.8-1-11.6-1-17.6s.3-11.8 1-17.6l1.3-12-8.9-8.2-45.8-42.3 36.8-63.8 59.5 18.5 11.6 3.6 9.8-7.2c9.4-6.9 19.6-12.9 30.4-17.6l11.1-4.9 2.7-11.8zm86.3 70.5l3.3-19.7-39.5-6.6-3.3 19.7-32 192-3.3 19.7 39.5 6.6 3.3-19.7 32-192zm-93.6 66.9l14.1-14.1-28.3-28.3-68.3 68.3c5.1 5.1 23.2 23.2 54.1 54.1l14.1 14.1 28.3-28.3c-7.5-7.5-20.8-20.8-40-40l25.9-25.9zm144-28.3l-14.1-14.1-28.3 28.3c7.5 7.5 20.8 20.8 40 40-19.2 19.2-32.5 32.5-40 40l28.3 28.3c5.1-5.1 23.2-23.2 54.1-54.1L428.4 256c-5.1-5.1-23.2-23.2-54.1-54.1z"/></svg>',
        'circle-question' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256-80c-17.7 0-32 14.3-32 32l-48 0c0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.1-20.5 57.5-38.2 70-6.3 4.4-12.5 7.8-17.8 10.4l0 21.9-48 0 0-56.7c1.4-.4 2.7-.7 4.1-1.1 12.2-3.2 23.3-6.1 34.1-13.7 10.4-7.3 17.8-16.9 17.8-30.8 0-17.7-14.3-32-32-32zM232 344l48 0 0 48-48 0 0-48z"/></svg>',
        'info-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 336l-24 0 0 48 128 0 0-48-32 0 0-112-96 0 0 48 48 0 0 64-24 0zm72-144l0-64-64 0 0 64 64 0z"/></svg>',
        'globe' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M128.8 280c4.6 66.4 27.5 128 54.9 171.1-72.1-26.7-125.3-92.2-134.4-171.1l79.5 0zm48.1 0L335 280c-3.9 49.3-19.5 95.8-38.9 131.1-11.2 20.5-22.9 35.6-32.7 44.9-3.2 3-5.7 5-7.5 6.2-1.8-1.3-4.3-3.2-7.5-6.2-9.8-9.3-21.4-24.4-32.7-44.9-19.4-35.3-34.9-81.8-38.9-131.1zM335 232L177 232c3.9-49.3 19.5-95.8 38.9-131.1 11.2-20.5 22.9-35.6 32.7-44.9 3.2-3 5.7-5 7.5-6.2 1.8 1.3 4.3 3.2 7.5 6.2 9.8 9.3 21.4 24.4 32.7 44.9 19.4 35.3 34.9 81.8 38.9 131.1zm48.1 48l79.5 0c-9.1 78.9-62.3 144.4-134.4 171.1 27.3-43.1 50.3-104.7 54.9-171.1zm79.5-48l-79.5 0c-4.6-66.4-27.5-128-54.9-171.1 72.1 26.7 125.3 92.2 134.4 171.1zm-333.8 0l-79.5 0c9.1-78.9 62.3-144.4 134.4-171.1-27.3 43.1-50.3 104.7-54.9 171.1zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"/></svg>',
    ];

    public const light_sharp = [
        'ban' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M402.7 425.3l-316-316c-34.1 39.3-54.7 90.6-54.7 146.7 0 123.7 100.3 224 224 224 56.1 0 107.4-20.6 146.7-54.7zm22.6-22.6c34.1-39.3 54.7-90.6 54.7-146.7 0-123.7-100.3-224-224-224-56.1 0-107.4 20.6-146.7 54.7l316 316zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"/></svg>',
    ];

    public const solid_round = [
        'angle-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z"/></svg>',
        'angle-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M247.1 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L179.2 256 41.9 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"/></svg>',
        'arrow-rotate-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 64c-56.8 0-107.9 24.7-143.1 64l47.1 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 192c-17.7 0-32-14.3-32-32L0 32C0 14.3 14.3 0 32 0S64 14.3 64 32l0 54.7C110.9 33.6 179.5 0 256 0 397.4 0 512 114.6 512 256S397.4 512 256 512c-87 0-163.9-43.4-210.1-109.7-10.1-14.5-6.6-34.4 7.9-44.6s34.4-6.6 44.6 7.9c34.8 49.8 92.4 82.3 157.6 82.3 106 0 192-86 192-192S362 64 256 64z"/></svg>',
        'arrows-maximize' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M288 32c-17.7 0-32 14.3-32 32s14.3 32 32 32L338.7 96 224 210.7 109.3 96 160 96c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64L0 192c0 17.7 14.3 32 32 32s32-14.3 32-32L64 141.3 178.7 256 64 370.7 64 320c0-17.7-14.3-32-32-32S0 302.3 0 320L0 448c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L109.3 416 224 301.3 338.7 416 288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32L384 370.7 269.3 256 384 141.3 384 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L288 32z"/></svg>',
        'ban' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M367.2 412.5L99.5 144.8c-22.4 31.4-35.5 69.8-35.5 111.2 0 106 86 192 192 192 41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3c22.4-31.4 35.5-69.8 35.5-111.2 0-106-86-192-192-192-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"/></svg>',
        'bed-front' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 95c-14.7-7.3-30.9-12.2-48-14.1l0-16.9c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 16-32 0 0-16c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 16.9c-17.1 1.9-33.3 6.8-48 14.1l0-95zM0 320c0-53 43-96 96-96l320 0c53 0 96 43 96 96l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-384 0 0 32c0 17.7-14.3 32-32 32S0 465.7 0 448L0 320z"/></svg>',
        'bus-simple' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M96 0C43 0 0 43 0 96L0 384c0 29.8 20.4 54.9 48 62l0 34c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 192 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-34c27.6-7.1 48-32.2 48-62l0-288c0-53-43-96-96-96L96 0zM64 128c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32l0-96zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"/></svg>',
        'car' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M135.2 117.4l-26.1 74.6 293.8 0-26.1-74.6C372.3 104.6 360.2 96 346.6 96L165.4 96c-13.6 0-25.7 8.6-30.2 21.4zM39.6 196.8L74.8 96.3C88.3 57.8 124.6 32 165.4 32l181.2 0c40.8 0 77.1 25.8 90.6 64.3l35.2 100.5c23.2 9.6 39.6 32.5 39.6 59.2l0 192c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-320 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 256c0-26.7 16.4-49.6 39.6-59.2zM128 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
        'caret-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M352 160c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-160 160c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-9.2-9.2-11.9-22.9-6.9-34.9S19.1 160 32 160l320 0z"/></svg>',
        'check' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M434.8 70.1c14.3 10.4 17.5 30.4 7.1 44.7l-256 352c-5.5 7.6-14 12.3-23.4 13.1s-18.5-2.7-25.1-9.3l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l101.5 101.5 234-321.7c10.4-14.3 30.4-17.5 44.7-7.1z"/></svg>',
        'check-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm84.4-299.3l-80 128c-4.2 6.7-11.4 10.9-19.3 11.3s-15.5-3.2-20.2-9.6l-48-64c-8-10.6-5.8-25.6 4.8-33.6s25.6-5.8 33.6 4.8l27 36 61.4-98.3c7-11.2 21.8-14.7 33.1-7.6s14.7 21.8 7.6 33.1z"/></svg>',
        'chevron-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M201.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 338.7 54.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z"/></svg>',
        'chevron-up' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M201.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 173.3 54.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"/></svg>',
        'copy' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M192 0c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-200.6c0-17.4-7.1-34.1-19.7-46.2L370.6 17.8C358.7 6.4 342.8 0 326.3 0L192 0zM64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-16-64 0 0 16-192 0 0-256 16 0 0-64-16 0z"/></svg>',
        'envelope-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64.4 175.8L256 33.9 447.6 175.8 289.5 293c-9.7 7.2-21.4 11-33.5 11s-23.8-3.9-33.5-11L64.4 175.8zM256-32c-12.1 0-23.8 3.9-33.5 11L25.9 124.7C9.6 136.8 0 155.8 0 176.1L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-239.9c0-20.3-9.6-39.4-25.9-51.4L289.5-21c-9.7-7.2-21.4-11-33.5-11z"/></svg>',
        'expand' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M32 32C14.3 32 0 46.3 0 64l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM64 352c0-17.7-14.3-32-32-32S0 334.3 0 352l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-64zM320 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0zM448 352c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96z"/></svg></svg>',
        'file-pdf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l80 0 0-112c0-35.3 28.7-64 64-64l176 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM240 380c-11 0-20 9-20 20l0 128c0 11 9 20 20 20s20-9 20-20l0-28 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm96-80c-11 0-20 9-20 20l0 128c0 11 9 20 20 20l32 0c28.7 0 52-23.3 52-52l0-64c0-28.7-23.3-52-52-52l-32 0zm20 128l0-88 12 0c6.6 0 12 5.4 12 12l0 64c0 6.6-5.4 12-12 12l-12 0zm88-108l0 128c0 11 9 20 20 20s20-9 20-20l0-44 28 0c11 0 20-9 20-20s-9-20-20-20l-28 0 0-24 28 0c11 0 20-9 20-20s-9-20-20-20l-48 0c-11 0-20 9-20 20z"/></svg>',
        'gear' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M195.1 9.5C198.1-5.3 211.2-16 226.4-16l59.8 0c15.2 0 28.3 10.7 31.3 25.5L332 79.5c14.1 6 27.3 13.7 39.3 22.8l67.8-22.5c14.4-4.8 30.2 1.2 37.8 14.4l29.9 51.8c7.6 13.2 4.9 29.8-6.5 39.9L447 233.3c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l53.4 47.5c11.4 10.1 14 26.8 6.5 39.9l-29.9 51.8c-7.6 13.1-23.4 19.2-37.8 14.4l-67.8-22.5c-12.1 9.1-25.3 16.7-39.3 22.8l-14.4 69.9c-3.1 14.9-16.2 25.5-31.3 25.5l-59.8 0c-15.2 0-28.3-10.7-31.3-25.5l-14.4-69.9c-14.1-6-27.2-13.7-39.3-22.8L73.5 432.3c-14.4 4.8-30.2-1.2-37.8-14.4L5.8 366.1c-7.6-13.2-4.9-29.8 6.5-39.9l53.4-47.5c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7L12.3 185.8c-11.4-10.1-14-26.8-6.5-39.9L35.7 94.1c7.6-13.2 23.4-19.2 37.8-14.4l67.8 22.5c12.1-9.1 25.3-16.7 39.3-22.8L195.1 9.5zM256.3 336a80 80 0 1 0 -.6-160 80 80 0 1 0 .6 160z"/></svg>',
        'gear-code' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M195.1 9.5C198.1-5.3 211.2-16 226.4-16l59.8 0c15.2 0 28.3 10.7 31.3 25.5L332 79.5c14.1 6 27.3 13.7 39.3 22.8l67.8-22.5c14.4-4.8 30.2 1.2 37.8 14.4l29.9 51.8c7.6 13.2 4.9 29.8-6.5 39.9L447 233.3c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l53.4 47.5c11.4 10.1 14 26.8 6.5 39.9l-29.9 51.8c-7.6 13.1-23.4 19.2-37.8 14.4l-67.8-22.5c-12.1 9.1-25.3 16.7-39.3 22.8l-14.4 69.9c-3.1 14.9-16.2 25.5-31.3 25.5l-59.8 0c-15.2 0-28.3-10.7-31.3-25.5l-14.4-69.9c-14.1-6-27.2-13.7-39.3-22.8L73.5 432.3c-14.4 4.8-30.2-1.2-37.8-14.4L5.8 366.1c-7.6-13.2-4.9-29.8 6.5-39.9l53.4-47.5c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7L12.3 185.8c-11.4-10.1-14-26.8-6.5-39.9L35.7 94.1c7.6-13.2 23.4-19.2 37.8-14.4l67.8 22.5c12.1-9.1 25.3-16.7 39.3-22.8L195.1 9.5zm104.7 147c2.5-10.8-4.2-21.5-15-24s-21.5 4.2-24 15l-48 208c-2.5 10.8 4.2 21.5 15 24s21.5-4.2 24-15l48-208zM182.5 238.1c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0l-32 32c-7.8 7.8-7.8 20.5 0 28.3l32 32c7.8 7.8 20.5 7.8 28.3 0s7.8-20.5 0-28.3l-17.9-17.9 17.9-17.9zm176-28.3c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3L348 256 330.2 273.9c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l32-32c7.8-7.8 7.8-20.5 0-28.3l-32-32z"/></svg>',
        'graduation-cap' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M48 195.8l209.2 86.1c9.8 4 20.2 6.1 30.8 6.1s21-2.1 30.8-6.1l242.4-99.8c9-3.7 14.8-12.4 14.8-22.1s-5.8-18.4-14.8-22.1L318.8 38.1C309 34.1 298.6 32 288 32s-21 2.1-30.8 6.1L14.8 137.9C5.8 141.6 0 150.3 0 160L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-260.2zm48 71.7L96 384c0 53 86 96 192 96s192-43 192-96l0-116.6-142.9 58.9c-15.6 6.4-32.2 9.7-49.1 9.7s-33.5-3.3-49.1-9.7L96 267.4z"/></svg>',
        'grid-2' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M192 80c0-26.5-21.5-48-48-48L48 32C21.5 32 0 53.5 0 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96zm0 256c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96zM256 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zM448 336c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96z"/></svg>',
        'heart' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 112.2-139.9 242.5-212.9 298.2-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C139.9 410.2 0 279.9 0 167.7l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1z"/></svg>',
        'heart-crack' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M133.1 32c17.3 0 34.2 3.4 49.9 9.7l54.8 85.2-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.4 60.6C319.6 42.3 348.6 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 112.2-139.9 242.5-212.9 298.2-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C139.9 410.2 0 279.9 0 167.7l0-2.6C0 91.6 59.6 32 133.1 32z"/></svg>',
        'house-building' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M320 64l0 52.1 118.2 103.4c16.4 14.3 25.8 35.1 25.8 56.8 0 25.5-12.6 48.1-32 61.7l0 121.2c0 19.4-5.5 37.4-14.9 52.8L576 512c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L384 0c-35.3 0-64 28.7-64 64zm120.4 93.6l-56-49c1.6-7.2 8-12.6 15.6-12.6l32 0c8.8 0 16 7.2 16 16l0 32c0 5.8-3 10.8-7.6 13.6zM528 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM512 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 112l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM384 304l4.5 0c15.2 0 27.5-12.3 27.5-27.5 0-7.9-3.4-15.5-9.4-20.7L236 106.5C228.3 99.7 218.3 96 208 96s-20.3 3.7-28 10.5L9.4 255.8C3.4 261 0 268.6 0 276.5 0 291.7 12.3 304 27.5 304l4.5 0 0 155.4C32 488.4 55.6 512 84.6 512l246.8 0c29.1 0 52.6-23.6 52.6-52.6L384 304zm-224-8c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"/></svg>',
        'house-user' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M277.8 8.6c-12.3-11.4-31.3-11.4-43.5 0l-224 208c-9.6 9-12.8 22.9-8 35.1S18.8 272 32 272l16 0 0 176c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-176 16 0c13.2 0 25-8.1 29.8-20.3s1.6-26.2-8-35.1l-224-208zM200 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM144 432c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"/></svg>',
        'image' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM272 224c8.4 0 16.1 4.4 20.5 11.5l88 144c4.5 7.4 4.7 16.7 .5 24.3S368.7 416 360 416L88 416c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l26.4 37.8 61.4-100.5c4.4-7.1 12.1-11.5 20.5-11.5z"/></svg>',
        'input-pipe' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64 128l0 256 448 0 0-256-448 0zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm160 56l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24z"/></svg>',
        'leaf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M471.3 6.7C477.7 .6 487-1.6 495.6 1.2 505.4 4.5 512 13.7 512 24l0 186.9c0 131.2-108.1 237.1-238.8 237.1-77 0-143.4-49.5-167.5-118.7-35.4 30.8-57.7 76.1-57.7 126.7 0 13.3-10.7 24-24 24S0 469.3 0 456C0 381.1 38.2 315.1 96.1 276.3 131.4 252.7 173.5 240 216 240l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-39.7 0-77.3 8.8-111 24.5 23.3-70 89.2-120.5 167-120.5 66.4 0 115.8-22.1 148.7-44 19.2-12.8 35.5-28.1 50.7-45.3z"/></svg>',
        'location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6c0 119.3-120.2 262.3-170.4 316.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zM192 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"/></svg>',
        'paper-plane' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M536.4-26.3c9.8-3.5 20.6-1 28 6.3s9.8 18.2 6.3 28l-178 496.9c-5 13.9-18.1 23.1-32.8 23.1-14.2 0-27-8.6-32.3-21.7l-64.2-158c-4.5-11-2.5-23.6 5.2-32.6l94.5-112.4c5.1-6.1 4.7-15-.9-20.6s-14.6-6-20.6-.9L229.2 276.1c-9.1 7.6-21.6 9.6-32.6 5.2L38.1 216.8c-13.1-5.3-21.7-18.1-21.7-32.3 0-14.7 9.2-27.8 23.1-32.8l496.9-178z"/></svg>',
        'paper-plane-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M78.5 3L554.2 222c13.3 6.1 21.8 19.4 21.8 34s-8.5 27.9-21.8 34L78.5 509c-4.3 2-9 3-13.7 3-18.1 0-32.8-14.8-32.8-33 0-4.6 1-9.2 2.8-13.4l72-161.9c4.7-10.6 14.9-17.9 26.5-18.9l156.7-13.6c7.9-.7 13.9-7.3 13.9-15.2s-6.1-14.5-13.9-15.2L133.3 227.2c-11.6-1-21.8-8.2-26.5-18.9L34.8 46.4C33 42.2 32 37.6 32 33 32 14.8 46.7 0 64.8 0 69.5 0 74.2 1 78.5 3z"/></svg>',
        'arrow-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l370.7 0-105.4 105.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"/></svg>',
        'arrow-long-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M566.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L466.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l434.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"/></svg>',
        'magnifying-glass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"/></svg>',
        'map-location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M576 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L413.5 77.5 234.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C70.8 88.8 64 99.9 64 112l0 352c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 173.3 57.8c-4.3-6.4-8.5-13.1-12.6-19.9-11-18.3-21.9-39.3-30-61.8l-101.2-33.7 0-284.5 128 42.7 0 99.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 48zM512 224c-66.3 0-120 52.8-120 117.9 0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"/></svg>',
        'pen' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M352.9 21.2L308 66.1 445.9 204 490.8 159.1C504.4 145.6 512 127.2 512 108s-7.6-37.6-21.2-51.1L455.1 21.2C441.6 7.6 423.2 0 404 0s-37.6 7.6-51.1 21.2zM274.1 100L58.9 315.1c-10.7 10.7-18.5 24.1-22.6 38.7L.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6L412 237.9 274.1 100z"/></svg>',
        'percent' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M192 128a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM448 384a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM438.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-384 384c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l384-384z"/></svg>',
        'phone' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M160.2 25C152.3 6.1 131.7-3.9 112.1 1.4l-5.5 1.5c-64.6 17.6-119.8 80.2-103.7 156.4 37.1 175 174.8 312.7 349.8 349.8 76.3 16.2 138.8-39.1 156.4-103.7l1.5-5.5c5.4-19.7-4.7-40.3-23.5-48.1l-97.3-40.5c-16.5-6.9-35.6-2.1-47 11.8l-38.6 47.2C233.9 335.4 177.3 277 144.8 205.3L189 169.3c13.9-11.3 18.6-30.4 11.8-47L160.2 25z"/></svg>',
        'plane-departure' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M372 143.9L172.7 40.2c-8-4.1-17.3-4.8-25.7-1.7l-41.1 15c-10.3 3.7-13.8 16.4-7.1 25L200.3 206.4 100.1 242.8 40 206.2c-6.2-3.8-13.8-4.5-20.7-2.1L3 210.1c-9.4 3.4-13.4 14.5-8.3 23.1l53.6 91.8c15.6 26.7 48.1 38.4 77.1 27.8l12.9-4.7 0 0 398.4-145c29.1-10.6 44-42.7 33.5-71.8s-42.7-44-71.8-33.5L372 143.9zM32.2 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-512 0z"/></svg>',
        'plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M256 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160-160 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0 0-160z"/></svg>',
        'circle-question' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-336c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 47.2-36 67.2-56 74.5l0 3.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8.1c0-20.5 14.8-35.2 30.1-40.2 6.4-2.1 13.2-5.5 18.2-10.3 4.3-4.2 7.7-10 7.7-19.6 0-17.7-14.3-32-32-32zM224 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'ruler-triangle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M86.6 9.4C77.5 .2 63.7-2.5 51.8 2.4S32 19.1 32 32l0 416c0 17.7 14.3 32 32 32l416 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-31-31-14.6 14.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l14.6-14.6-46.1-46.1-38.6 38.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l38.6-38.6-46.1-46.1-14.6 14.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l14.6-14.6-46.1-46.1-38.6 38.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L197.7 120.4 151.6 74.3 137 89c-9.4 9.4-24.6 9.4-33.9 0S93.7 64.4 103 55l14.6-14.6-31-31zM160 263.8l88.2 88.2-88.2 0 0-88.2z"/></svg>',
        'share' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M307.8 18.4c-12 5-19.8 16.6-19.8 29.6l0 80-112 0c-97.2 0-176 78.8-176 176 0 113.3 81.5 163.9 100.2 174.1 2.5 1.4 5.3 1.9 8.1 1.9 10.9 0 19.7-8.9 19.7-19.7 0-7.5-4.3-14.4-9.8-19.5-9.4-8.8-22.2-26.4-22.2-56.7 0-53 43-96 96-96l96 0 0 80c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9z"/></svg>',
        'share-nodes' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M384 192c53 0 96-43 96-96s-43-96-96-96-96 43-96 96c0 5.4 .5 10.8 1.3 16L159.6 184.1c-16.9-15-39.2-24.1-63.6-24.1-53 0-96 43-96 96s43 96 96 96c24.4 0 46.6-9.1 63.6-24.1L289.3 400c-.9 5.2-1.3 10.5-1.3 16 0 53 43 96 96 96s96-43 96-96-43-96-96-96c-24.4 0-46.6 9.1-63.6 24.1L190.7 272c.9-5.2 1.3-10.5 1.3-16s-.5-10.8-1.3-16l129.7-72.1c16.9 15 39.2 24.1 63.6 24.1z"/></svg>',
        'shop' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M21.5 181.1L78.3 67.4C89.2 45.7 111.3 32 135.6 32l304.9 0c24.2 0 46.4 13.7 57.2 35.4l56.8 113.7c3.6 7.2 5.5 15.1 5.5 23.2 0 27.3-21.2 49.7-48 51.6L512 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192-96 0 0 176c0 26.5-21.5 48-48 48l-192 0c-26.5 0-48-21.5-48-48l0-176.1c-26.8-1.9-48-24.3-48-51.6 0-8 1.9-16 5.5-23.2zM128 256l0 112c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-112-160 0z"/></svg>',
        'shower' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64 131.9c0-19.8 16.1-35.9 35.9-35.9 9.5 0 18.6 3.8 25.4 10.5l16.2 16.2c-21 38.9-17.4 87.5 10.9 123L151 247c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L345 121c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-1.3 1.3c-35.5-28.3-84.1-31.9-123-10.9L170.5 61.3C151.8 42.5 126.4 32 99.9 32 44.7 32 0 76.7 0 131.9L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-316.1zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32-32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
        'table-layout' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM384 96l0 64-320 0 0-64 320 0zM64 224l64 0 0 192-64 0 0-192zm320 0l0 192-192 0 0-192 192 0z"/></svg>',
        'trash' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M136.7 5.9L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-8.7-26.1C306.9-7.2 294.7-16 280.9-16L167.1-16c-13.8 0-26 8.8-30.4 21.9zM416 144L32 144 53.1 467.1C54.7 492.4 75.7 512 101 512L347 512c25.3 0 46.3-19.6 47.9-44.9L416 144z"/></svg>',
        'trowel-bricks' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M224 32c0-11.5-6.2-22.2-16.2-27.8s-22.3-5.5-32.2 .4l-160 96C5.9 106.3 0 116.8 0 128s5.9 21.7 15.5 27.4l160 96c9.9 5.9 22.2 6.1 32.2 .4S224 235.5 224 224l0-64 256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0 0-64zm96 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-160 0zM0 416l0 64c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32zm224-32c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-256 0z"/></svg>',
        'video' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M96 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L96 64zM464 336l73.5 58.8c4.2 3.4 9.4 5.2 14.8 5.2 13.1 0 23.7-10.6 23.7-23.7l0-240.6c0-13.1-10.6-23.7-23.7-23.7-5.4 0-10.6 1.8-14.8 5.2L464 176 464 336z"/></svg>',
        'street-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 160l64 0c35.3 0 64 28.7 64 64l0 48c0 17.7-14.3 32-32 32l-1.8 0-11.1 99.5c-1.8 16.2-15.5 28.5-31.8 28.5l-38.7 0c-16.3 0-30-12.3-31.8-28.5l-11.1-99.5-1.8 0c-17.7 0-32-14.3-32-32l0-48c0-35.3 28.7-64 64-64zM412.4 400.2c-16.1-4.2-34.8-7.6-55.4-10.2l5.3-47.7c22.7 2.9 43.7 6.7 62.1 11.5 22.4 5.8 42.6 13.3 57.8 23.3 14.7 9.6 29.8 24.9 29.8 47s-15.1 37.4-29.8 47c-15.2 9.9-35.5 17.5-57.8 23.3-45.1 11.7-105.3 17.8-168.4 17.8s-123.3-6.1-168.4-17.8C65.2 488.4 45 480.9 29.8 471 15.1 461.4 0 446.1 0 424s15.1-37.4 29.8-47c15.2-9.9 35.5-17.5 57.8-23.3 18.5-4.8 39.5-8.6 62.1-11.5L155 390c-20.6 2.6-39.3 6.1-55.4 10.2-56.6 14.6-56.6 32.9 0 47.5 39.9 10.3 95.8 16.2 156.4 16.2s116.5-5.9 156.4-16.2c56.6-14.6 56.6-32.9 0-47.5z"/></svg>',
        'warning' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5S486.1 480 472 480L40 480c-14.1 0-27.1-7.4-34.4-19.5s-7.5-27.1-.8-39.5l216-400c7-12.9 20.5-21 35.2-21zm0 168c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm26.7 216a26.7 26.7 0 1 0 -53.3 0 26.7 26.7 0 1 0 53.3 0z"/></svg>',
        'water' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.6 124.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm0 144c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.7-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm-71.2 144c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9z"/></svg>',
        'water-ladder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M374.5 405.7c38.4-29 90.5-29 129 0 16.9 12.7 32.9 21.5 47.8 24.6 13.7 2.8 27.4 .9 42.3-10.3 10.6-8 25.6-5.9 33.6 4.7s5.8 25.7-4.8 33.6c-26.4 19.9-54.2 24.4-80.7 19.1-25.3-5.1-48.1-18.9-67.2-33.3-21.3-16.1-49.9-16.1-71.2 0-24.2 18.3-52.3 35.9-83.4 35.9s-59.1-17.7-83.3-35.9c-21.3-16.1-49.9-16.1-71.2 0-23.8 17.9-54.1 35.5-88.1 35.3-20.4-.1-40.7-6.7-59.8-21.1-10.6-8-12.7-23-4.7-33.6s23-12.7 33.6-4.7c11.3 8.5 21.6 11.4 31.2 11.5 17.6 .1 37.3-9.4 58.9-25.7 38.4-29 90.6-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3zM511.8 32c48.3 0 89 36 95 83.9l1 8.2c2.2 17.5-10.2 33.5-27.8 35.7s-33.5-10.2-35.7-27.8l-1-8.2c-2-15.9-15.5-27.8-31.5-27.8-17.5 0-31.8 14.2-31.8 31.8l0 211.8c-23.1-5.1-44.9-4.4-64-.4l0-51.2-192 0 0 48.7c-5.3-.5-10.7-.8-16-.7-16.2 .1-32.4 2.7-48 8l0-216.2c0-52.9 42.9-95.8 95.7-95.8 48.3 0 89 36 95 83.9l1 8.2c2.2 17.5-10.2 33.5-27.8 35.7s-33.5-10.2-35.7-27.8l-1-8.2c-2-15.9-15.5-27.8-31.5-27.8-17.5 0-31.7 14.2-31.7 31.8l0 96.2 192 0 0-96.2C416 74.9 458.9 32 511.8 32z"/></svg>',
        'xmark-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM167 167c9.4-9.4 24.6-9.4 33.9 0l55 55 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-55 55 55 55c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-55-55-55 55c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l55-55-55-55c-9.4-9.4-9.4-24.6 0-33.9z"/></svg>',
        'xmark-large' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 210.7 54.6 9.4C42.1-3.1 21.9-3.1 9.4 9.4s-12.5 32.8 0 45.3L210.7 256 9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L256 301.3 457.4 502.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L301.3 256 502.6 54.6z"/></svg>',
        'door-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M288 64l64 0 0 416c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-384c0-35.3-28.7-64-64-64l-96 0 0 0-160 0C60.7 0 32 28.7 32 64l0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-416zM160 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'toilet' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l8 0 0 148.9c-1.9 1.4-3.8 2.9-5.6 4.4-15.5 13.2-26.4 31.6-26.4 54.6 0 46.9 14.3 84.1 37 112.5 14.2 17.7 31.1 31.3 48.5 41.8L65.6 469.9c-3.3 9.8-1.6 20.5 4.4 28.8S85.7 512 96 512l256 0c10.3 0 19.9-4.9 26-13.3s7.7-19.1 4.4-28.8l-19.8-59.5c17.4-10.5 34.3-24.1 48.5-41.8 22.7-28.4 37-65.5 37-112.5 0-23.1-10.9-41.5-26.4-54.6-1.8-1.5-3.7-3-5.6-4.4l0-148.9 8 0c13.3 0 24-10.7 24-24S437.3 0 424 0L24 0zM96 80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zM224 288c-88.4 0-160-14.3-160-32s71.6-32 160-32 160 14.3 160 32-71.6 32-160 32z"/></svg>',
        'bath' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M96 77.3c0-7.3 5.9-13.3 13.3-13.3 3.5 0 6.9 1.4 9.4 3.9l14.9 14.9c-3.6 9.1-5.5 18.9-5.5 29.2 0 19.9 7.2 38 19.2 52-5.3 9.2-4 21.1 3.8 29 9.4 9.4 24.6 9.4 33.9 0L289 89c9.4-9.4 9.4-24.6 0-33.9-7.8-7.9-19.8-9.1-29-3.8-14-12-32.1-19.2-52-19.2-10.3 0-20.2 2-29.2 5.5L163.9 22.6C149.4 8.1 129.7 0 109.3 0 66.6 0 32 34.6 32 77.3L32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 48c0 28.4 12.4 54 32 71.6L64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-16 256 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-40.4c19.6-17.6 32-43.1 32-71.6l0-48c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 256 96 77.3z"/></svg>',
        'shower' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64 131.9C64 112.1 80.1 96 99.9 96c9.5 0 18.6 3.8 25.4 10.5l16.2 16.2c-21 38.9-17.4 87.5 10.9 123L151 247c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L345 121c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-1.3 1.3c-35.5-28.3-84.2-31.9-123-10.9L170.5 61.3C151.8 42.5 126.4 32 99.9 32C44.7 32 0 76.7 0 131.9L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-316.1zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32-32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
        'oven' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 96C0 43 43 0 96 0L352 0c53 0 96 43 96 96l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96zm104 16a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm16 88l-320 0 0 224 320 0 0-224zM136 272l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"/></svg>',
        'couch' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M144 272C144 224.7 109.8 185.4 64.8 177.5 72 113.6 126.2 64 192 64l256 0c65.8 0 120 49.6 127.2 113.5-45 8-79.2 47.2-79.2 94.5l0 32-352 0 0-32zM0 384L0 272c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 448 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 112c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64z"/></svg>',
        'hotel' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M16 24C16 10.7 26.7 0 40 0L472 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 416 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L40 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-416-8 0C26.7 48 16 37.3 16 24zm208 88l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM128 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm96 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM352 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM112 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm240-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM288 384l43.8 0c9.9 0 17.5-9 14-18.2-13.8-36.1-48.8-61.8-89.7-61.8s-75.9 25.7-89.7 61.8c-3.5 9.2 4.1 18.2 14 18.2l43.8 0 0 80 64 0 0-80z"/></svg>',
        'moon-stars' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M439.8 89.8c1 3.6 4.4 6.2 8.2 6.2s7.1-2.5 8.2-6.2l11-38.6 38.6-11c3.6-1 6.2-4.4 6.2-8.2s-2.5-7.1-6.2-8.2l-38.6-11-11-38.6c-1-3.6-4.4-6.2-8.2-6.2s-7.1 2.5-8.2 6.2l-11 38.6-38.6 11c-3.6 1-6.2 4.4-6.2 8.2s2.5 7.1 6.2 8.2l38.6 11 11 38.6zM224 64C100.3 64 0 164.3 0 288S100.3 512 224 512c60.2 0 114.9-23.8 155.1-62.4 6.4-6.1 8.2-15.7 4.6-23.8s-12-13-20.8-12.3c-4.3 .3-8.6 .5-12.9 .5-88.9 0-161-72.1-161-161 0-63.1 36.3-117.8 89.3-144.2 7.9-4 12.6-12.5 11.5-21.3s-7.6-16-16.2-18C257.6 65.9 241 64 224 64zM355.2 268.8l16.6 58c1.6 5.5 6.6 9.2 12.2 9.2s10.7-3.8 12.2-9.2l16.6-58 58-16.6c5.5-1.6 9.2-6.6 9.2-12.2s-3.8-10.7-9.2-12.2l-58-16.6-16.6-58c-1.6-5.5-6.6-9.2-12.2-9.2s-10.7 3.8-12.2 9.2l-16.6 58-58 16.6c-5.5 1.6-9.2 6.6-9.2 12.2s3.8 10.7 9.2 12.2l58 16.6z"/></svg>',
        'grid-2-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M48 32C21.5 32 0 53.5 0 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L48 32zm0 256c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0zM256 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zm96 208c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"/></svg>',
        'layer-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M456-8c0-13.3-10.7-24-24-24S408-21.3 408-8l0 32-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-32zM279.5 101.2c-14.9-6.9-32.1-6.9-47 0L13.9 202.2C5.4 206.1 0 214.6 0 224s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101zM13.9 362.2C5.4 366.1 0 374.6 0 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-68.7-31.8-129.7 59.9c-27.7 12.8-59.6 12.8-87.3 0L82.7 330.4 13.9 362.2z"/></svg>',
        'layer-group' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M232.5 5.2c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 149.8C5.4 145.8 0 137.3 0 128s5.4-17.9 13.9-21.8L232.5 5.2zM48.1 218.4l164.3 75.9c27.7 12.8 59.6 12.8 87.3 0l164.3-75.9 34.1 15.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 277.8C5.4 273.8 0 265.3 0 256s5.4-17.9 13.9-21.8l34.1-15.8zM13.9 362.2l34.1-15.8 164.3 75.9c27.7 12.8 59.6 12.8 87.3 0l164.3-75.9 34.1 15.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8C5.4 401.8 0 393.3 0 384s5.4-17.9 13.9-21.8z"/></svg>',
        'lamp' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M82.5 51.7C87.4 39.8 99.1 32 112 32l224 0c12.9 0 24.6 7.8 29.5 19.7l80 192c4.1 9.9 3 21.2-2.9 30.1S426.7 288 416 288L32 288c-10.7 0-20.7-5.3-26.6-14.2s-7-20.2-2.9-30.1l80-192zM124.1 336l199.9 0c17.6 21.9 28.1 49.7 28.1 80 0 38.2-16.8 72.5-43.3 96l-169.3 0c-26.6-23.5-43.3-57.8-43.3-96 0-30.3 10.5-58.1 28.1-80z"/></svg>',
        'stairs' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M384 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0 0-96c0-17.7 14.3-32 32-32l96 0 0-96c0-17.7 14.3-32 32-32l96 0 0-96z"/></svg>',
        'file-certificate' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M128 64c0-35.3 28.7-64 64-64L341.5 0c17 0 33.3 6.7 45.3 18.7L493.3 125.3c12 12 18.7 28.3 18.7 45.3L512 448c0 35.3-28.7 64-64 64l-192 0 0-71.2c29.8-31.5 48-74 48-120.8 0-97.2-78.8-176-176-176l0 0 0-80zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L453.5 176 336 58.5zM256 320c0 40.4-18.7 76.5-48 99.9L208 525c0 10.5-8.5 19-19 19-3.3 0-6.5-.9-9.4-2.5L128 512 76.4 541.5c-2.9 1.6-6.1 2.5-9.4 2.5-10.5 0-19-8.5-19-19l0-105.1C18.7 396.5 0 360.4 0 320 0 249.3 57.3 192 128 192s128 57.3 128 128zM128 368a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/></svg>',
        'chart-pie' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M512.4 240l-176 0c-17.7 0-32-14.3-32-32l0-176c0-17.7 14.4-32.2 31.9-29.9 107 14.2 191.8 99 206 206 2.3 17.5-12.2 31.9-29.9 31.9zM222.6 37.2c18.1-3.8 33.8 11 33.8 29.5l0 197.3c0 5.6 2 11 5.5 15.3L394 438.7c11.7 14.1 9.2 35.4-6.9 44.1-34.1 18.6-73.2 29.2-114.7 29.2-132.5 0-240-107.5-240-240 0-115.5 81.5-211.9 190.2-234.8zM477.8 288l64 0c18.5 0 33.3 15.7 29.5 33.8-10.2 48.4-35 91.4-69.6 124.2-12.3 11.7-31.6 9.2-42.4-3.9L374.9 340.4c-17.3-20.9-2.4-52.4 24.6-52.4l78.2 0z"/></svg>',
        'road' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M223.9 32l-76.2 0c-29.4 0-55.1 20.1-62.1 48.6L1.4 420.5C-6.1 450.7 16.8 480 48 480l175.9 0 0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64 176.1 0c31.2 0 54.1-29.3 46.6-59.5L426.5 80.6C419.4 52.1 393.8 32 364.3 32l-76.4 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm64 192l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"/></svg>',
        'star' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M309.5-18.9c-4.1-8-12.4-13.1-21.4-13.1s-17.3 5.1-21.4 13.1L193.1 125.3 33.2 150.7c-8.9 1.4-16.3 7.7-19.1 16.3s-.5 18 5.8 24.4l114.4 114.5-25.2 159.9c-1.4 8.9 2.3 17.9 9.6 23.2s16.9 6.1 25 2L288.1 417.6 432.4 491c8 4.1 17.7 3.3 25-2s11-14.2 9.6-23.2L441.7 305.9 556.1 191.4c6.4-6.4 8.6-15.8 5.8-24.4s-10.1-14.9-19.1-16.3L383 125.3 309.5-18.9z"/></svg>',
        'cube' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M224.3-2.5c19.8-11.4 44.2-11.4 64 0L464.2 99c19.8 11.4 32 32.6 32 55.4l0 203c0 22.9-12.2 44-32 55.4L288.3 514.5c-19.8 11.4-44.2 11.4-64 0L48.5 413c-19.8-11.4-32-32.6-32-55.4l0-203c0-22.9 12.2-44 32-55.4L224.3-2.5zm207.8 360l0-166.1-143.8 83 0 166.1 143.8-83z"/></svg>',
        'house-window' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M277.8 8.6c-12.3-11.4-31.3-11.4-43.5 0l-224 208c-9.6 9-12.8 22.9-8 35.1S18.8 272 32 272l16 0 0 176c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-176 16 0c13.2 0 25-8.1 29.8-20.3s1.6-26.2-8-35.1l-224-208zM216 224l80 0c13.3 0 24 10.7 24 24l0 80c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24z"/></svg>',
        'window-frame' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 256l0 192c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 192zm-64 32l-96 0 0 160 96 0 0-160zm0-64l0-160-96 0 0 160 96 0zm-160 0l0-160-96 0 0 160 96 0zM96 288l0 160 96 0 0-160-96 0z"/></svg>',
        'compass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm50.7-186.9L162.4 380.6c-19.4 7.5-38.5-11.6-31-31l55.5-144.3c3.3-8.5 9.9-15.1 18.4-18.4l144.3-55.5c19.4-7.5 38.5 11.6 31 31L325.1 306.7c-3.2 8.5-9.9 15.1-18.4 18.4zM288 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>',
        'hammer-brush' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M0 137.7C0 91.7 23 48.7 61.3 23.1 83.9 8 110.5 0 137.7 0l62.1 0c15.8 0 31.2 4.7 44.4 13.4L272 32 288 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l-16 0-27.8 18.6C231 155.3 215.6 160 199.8 160l-47.6 0c-15.8 0-31.2-4.7-44.4-13.4L94 137.3c-8.8-5.8-19.9-7-29.6-3.1l-45.1 18C10 156 0 149.2 0 139.2l0-1.5zM224 208l0 256c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-256 96 0zM448 448l-32 64-48 0c-26.5 0-48-21.5-48-48l0-128 288 0 0 128c0 26.5-21.5 48-48 48l-80 0-32-64zM320 288c.7-20.5 11.3-39.5 28.5-51l67.5-45 0-144c0-26.5 21.5-48 48-48s48 21.5 48 48l0 144 67.5 45c17.2 11.5 27.7 30.5 28.5 51L320 288z"/></svg>',
        'file-signature' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M64.1 64c0-35.3 28.7-64 64-64L277.6 0c17 0 33.3 6.7 45.3 18.7L429.3 125.3c12 12 18.7 28.3 18.7 45.3l0 97.5-132 132-42.1 0-16.1-53.6c-4.7-15.7-19.1-26.4-35.5-26.4-11.3 0-21.9 5.1-28.9 13.9L133.3 409c-8.3 10.3-6.6 25.5 3.7 33.7s25.5 6.6 33.7-3.8l47.1-58.8 15.2 50.7c3 10.2 12.4 17.1 23 17.1l31.5 0c-.9 3.1-1.7 6.3-2.3 9.5l-10.9 54.5-146.2 0c-35.3 0-64-28.7-64-64l0-384zm208-5.5l0 93.5c0 13.3 10.7 24 24 24l93.5 0-117.5-117.5zm60.2 408.4c2.5-12.4 8.6-23.8 17.5-32.7l118.9-118.9 80 80-118.9 118.9c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9l11.9-59.6zm267.8-123l-28.8 28.8-80-80 28.8-28.8c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80z"/></svg>',
        'key' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7L7 391c-4.5 4.5-7 10.6-7 17l0 80c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7l33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"/></svg>',
        'coins' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M128 96l0-16c0-44.2 86-80 192-80S512 35.8 512 80l0 16c0 30.6-41.3 57.2-102 70.7-2.4-2.8-4.9-5.5-7.4-8-15.5-15.3-35.5-26.9-56.4-35.5-41.9-17.5-96.5-27.1-154.2-27.1-21.9 0-43.3 1.4-63.8 4.1-.2-1.3-.2-2.7-.2-4.1zM432 353l0-46.2c15.1-3.9 29.3-8.5 42.2-13.9 13.2-5.5 26.1-12.2 37.8-20.3l0 15.4c0 26.8-31.5 50.5-80 65zm0-96l0-33c0-4.5-.4-8.8-1-13 15.5-3.9 30-8.6 43.2-14.2s26.1-12.2 37.8-20.3l0 15.4c0 26.8-31.5 50.5-80 65zM0 240l0-16c0-44.2 86-80 192-80s192 35.8 192 80l0 16c0 44.2-86 80-192 80S0 284.2 0 240zm384 96c0 44.2-86 80-192 80S0 380.2 0 336l0-15.4c11.6 8.1 24.5 14.7 37.8 20.3 41.9 17.5 96.5 27.1 154.2 27.1s112.3-9.7 154.2-27.1c13.2-5.5 26.1-12.2 37.8-20.3l0 15.4zm0 80.6l0 15.4c0 44.2-86 80-192 80S0 476.2 0 432l0-15.4c11.6 8.1 24.5 14.7 37.8 20.3 41.9 17.5 96.5 27.1 154.2 27.1s112.3-9.7 154.2-27.1c13.2-5.5 26.1-12.2 37.8-20.3z"/></svg>',
        'object-exclude' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M0 64C0 28.7 28.7 0 64 0L288 0c35.3 0 64 28.7 64 64l0 96 96 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-96-96 0c-35.3 0-64-28.7-64-64L0 64zM320 192l-128 0 0 128 128 0 0-128z"/></svg>',
        'square-dashed' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M160 64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32zm-40.2-3.5c2.2 17.5-10.3 33.5-27.8 35.7-14.4 1.8-25.9 13.3-27.7 27.7-2.2 17.5-18.2 30-35.7 27.8S-1.4 133.6 .7 116C6.2 72.6 40.6 38.2 84 32.7 101.6 30.6 117.6 43 119.8 60.5zm208.5 0c2.2-17.5 18.2-30 35.7-27.8 43.5 5.4 77.9 39.8 83.3 83.3 2.2 17.5-10.3 33.5-27.8 35.7s-33.5-10.3-35.7-27.8c-1.8-14.4-13.3-25.9-27.7-27.7-17.5-2.2-30-18.2-27.8-35.7zM32 192c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32S0 305.7 0 288l0-64c0-17.7 14.3-32 32-32zm384 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM28.5 360.2c17.5-2.2 33.5 10.3 35.7 27.8 1.8 14.4 13.3 25.9 27.7 27.7 17.5 2.2 30 18.2 27.8 35.7s-18.2 30-35.7 27.8C40.6 473.8 6.2 439.4 .7 396-1.4 378.4 11 362.4 28.5 360.2zm390.9 0c17.5 2.2 30 18.2 27.8 35.7-5.4 43.5-39.8 77.9-83.3 83.3-17.5 2.2-33.5-10.3-35.7-27.8s10.3-33.5 27.8-35.7c14.4-1.8 25.9-13.3 27.7-27.7 2.2-17.5 18.2-30 35.7-27.8zM160 448c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32z"/></svg>',
        'chart-pyramid' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M291.2 21C284.2 8.1 270.7 0 256 0s-28.2 8.1-35.2 21l-75.1 139 220.5 0-75.1-139zM59.3 320l393.3 0-60.5-112-272.4 0-60.5 112zM33.4 368L4.8 421c-6.7 12.4-6.4 27.4 .8 39.5S25.9 480 40 480l432 0c14.1 0 27.1-7.4 34.4-19.5s7.5-27.1 .8-39.5l-28.6-53-445.2 0z"/></svg>',
        'vector-square' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M32 119.4C12.9 108.4 0 87.7 0 64 0 28.7 28.7 0 64 0 87.7 0 108.4 12.9 119.4 32l273.1 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 23.7-12.9 44.4-32 55.4l0 273.1c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-273.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-273.1zm64 0l0 273.1c9.7 5.6 17.8 13.7 23.4 23.4l273.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-273.1c-9.7-5.6-17.8-13.7-23.4-23.4L119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4z"/></svg>',
        'diagram-cells' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 160c0 35.3-28.7 64-64 64L64 224c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 64zM384 416l0-64-320 0 0 64 320 0zm0 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64z"/></svg>',
        'border-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 64C0 46.3 14.3 32 32 32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64zM64 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM0 448c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zm448 0c0 17.7-14.3 32-32 32s-32-14.3-32-32 14.3-32 32-32 32 14.3 32 32zm-320 0c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zm192 0c0 17.7-14.3 32-32 32s-32-14.3-32-32 14.3-32 32-32 32 14.3 32 32z"/></svg>',
        'border-none' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zM288 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm0-384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"/></svg>',
        'car-garage' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M0 480L0 142.1c0-27.5 17.6-52 43.8-60.7L272.8 5.1c9.9-3.3 20.5-3.3 30.4 0L532.2 81.4c26.1 8.7 43.8 33.2 43.8 60.7L576 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7-14.3-32-32-32L96 192c-17.7 0-32 14.3-32 32l0 256c0 17.7-14.3 32-32 32S0 497.7 0 480zM218.7 292l-25.2 44 189.1 0-25.2-44c-1.4-2.5-4.1-4-6.9-4l-124.7 0c-2.9 0-5.5 1.5-6.9 4zM128 392l0-14.9c0-15.4 4-30.5 11.7-43.8l37.4-65.1c10-17.4 28.5-28.1 48.6-28.1l124.7 0c20.1 0 38.6 10.7 48.6 28.1l37.4 65.1c7.7 13.3 11.7 28.4 11.7 43.8L448 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-192 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-88zm80 32a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm184-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"/></svg>',
        'fence' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M67.5 47.6L23 103.2c-4.5 5.7-7 12.7-7 20L16 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-30.6 48 0 0 30.6c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-30.6 48 0 0 30.6c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-324.8c0-7.3-2.5-14.3-7-20L444.5 47.6c-6.4-8-18.6-8-25 0L375 103.2c-4.5 5.7-7 12.7-7 20l0 38.1-48 0 0-38.1c0-7.3-2.5-14.3-7-20L268.5 47.6c-6.4-8-18.6-8-25 0L199 103.2c-4.5 5.7-7 12.7-7 20l0 38.1-48 0 0-38.2c0-7.3-2.5-14.3-7-20L92.5 47.6c-6.4-8-18.6-8-25 0zM368 225.4l0 128-48 0 0-128 48 0zm-176 0l0 128-48 0 0-128 48 0z"/></svg>',
        'tree' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224-32c7 0 13.7 3.1 18.3 8.5l136 160c6.1 7.1 7.4 17.1 3.5 25.6S369.4 176 360 176l-24.9 0 75.2 88.5c6.1 7.1 7.4 17.1 3.5 25.6S401.4 304 392 304l-38.5 0 88.8 104.5c6.1 7.1 7.4 17.1 3.5 25.6S433.4 448 424 448l-168 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64-168 0c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6L94.5 304 56 304c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6L112.9 176 88 176c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l136-160C210.3-28.9 217-32 224-32z"/></svg>',
        'boxes-stacked' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M224 0l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 5.5-.7 10.9-2 16l-252 0c-1.3-5.1-2-10.5-2-16l0-128c0-35.3 28.7-64 64-64l32 0zm96 512c-11.2 0-21.8-2.9-31-8 9.5-16.5 15-35.6 15-56l0-128c0-20.4-5.5-39.5-15-56 9.2-5.1 19.7-8 31-8l32 0 0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64l-128 0zM0 320c0-35.3 28.7-64 64-64l32 0 0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 320z"/></svg>',
        'users-viewfinder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64 0C28.7 0 0 28.7 0 64l0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-8.8 7.2-16 16-16l72 0c13.3 0 24-10.7 24-24S149.3 0 136 0L64 0zM440 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c8.8 0 16 7.2 16 16l0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-35.3-28.7-64-64-64L440 0zM48 376c0-13.3-10.7-24-24-24S0 362.7 0 376l0 72c0 35.3 28.7 64 64 64l72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0c-8.8 0-16-7.2-16-16l0-72zm528 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72c0 8.8-7.2 16-16 16l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c35.3 0 64-28.7 64-64l0-72zM288 216a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 40c-53 0-96 43-96 96l0 24c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-24c0-53-43-96-96-96zm192-64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM168 272.3c-49.3 4.1-88 45.3-88 95.7l0 10.7c0 11.8 9.6 21.3 21.3 21.3l46.8 0c-2.7-7.5-4.1-15.6-4.1-24l0-24c0-29.5 8.8-56.9 24-79.7zM427.9 400l46.8 0c11.8 0 21.3-9.6 21.3-21.3l0-10.7c0-50.3-38.7-91.6-88-95.7 15.2 22.8 24 50.2 24 79.7l0 24c0 8.4-1.4 16.5-4.1 24zM192 192a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/></svg>',
        'info-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-8 64l48 0c13.3 0 24 10.7 24 24l0 88 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0 0-64-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"/></svg>',

        // CD
        'grid-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48,0h50.286c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48h-50.286C21.49,146.286,0,124.796,0,98.286v-50.286C0,21.49,21.49,0,48,0ZM48,182.857h50.286c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48ZM146.286,413.714v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48h50.286c26.51,0,48,21.49,48,48ZM230.857,0h50.286c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48ZM329.143,230.857v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48h50.286c26.51,0,48,21.49,48,48ZM230.857,365.714h50.286c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48ZM512,48v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48h50.286c26.51,0,48,21.49,48,48ZM413.714,182.857h50.286c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48ZM512,413.714v50.286c0,26.51-21.49,48-48,48h-50.286c-26.51,0-48-21.49-48-48v-50.286c0-26.51,21.49-48,48-48h50.286c26.51,0,48,21.49,48,48Z"/></svg>',
        'list-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48,0h416c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48H48C21.49,146.286,0,124.796,0,98.286v-50.286C0,21.49,21.49,0,48,0ZM48,182.857h416c26.51,0,48,21.49,48,48v50.286c0,26.51-21.49,48-48,48H48C21.49,329.143,0,307.653,0,281.143v-50.286C0,204.347,21.49,182.857,48,182.857ZM512,413.714v50.286c0,26.51-21.49,48-48,48H48C21.49,512,0,490.51,0,464v-50.286C0,387.204,21.49,365.714,48,365.714h416c26.51,0,48,21.49,48,48Z"/></svg>',
        'map-marker' =>
            '<svg xmlns="http://www.w3.org/2000/svg" width="36" height="49.5" viewBox="0 0 36 49.5"><path d="M.009,17.677C.009,7.91,8.07,0,18.005,0s17.995,7.91,17.995,17.677c0,11.181-11.266,24.584-15.971,29.692-1.106,1.2-2.952,1.2-4.058,0C11.266,42.261,0,28.858,0,17.677h.009Z" fill="${brandingColor}"/><circle cx="18.005" cy="17.995" r="5.998" fill="white"/></svg>',
    ];

    public const regular_round = [
        'angle-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M15.5 239c-9.4 9.4-9.4 24.6 0 33.9l160 160c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-143-143 143-143c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L15.5 239z"/></svg>',
        'angle-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M241.5 239c9.4 9.4 9.4 24.6 0 33.9L81.5 433c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l143-143-143-143c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l160 160z"/></svg>',
        'arrow-rotate-left' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M24 0C37.3 0 48 10.7 48 24L48 102.1 75.1 75c100-100 262.1-100 362 0s100 262.1 0 362-262.1 100-362 0c-14.9-14.9-27.6-31.2-38.1-48.5-6.9-11.3-3.2-26.1 8.1-33s26.1-3.2 33 8.1c8.5 14 18.8 27.3 31 39.4 81.2 81.2 212.9 81.2 294.2 0s81.2-212.9 0-294.2-212.9-81.2-294.2 0l-27.1 27.1 78.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 184c-13.3 0-24-10.7-24-24L0 24C0 10.7 10.7 0 24 0z"/></svg>',
        'arrows-maximize' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M296 32c-13.3 0-24 10.7-24 24s10.7 24 24 24L366.1 80 224 222.1 81.9 80 152 80c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32C10.7 32 0 42.7 0 56L0 184c0 13.3 10.7 24 24 24s24-10.7 24-24L48 113.9 190.1 256 48 398.1 48 328c0-13.3-10.7-24-24-24S0 314.7 0 328L0 456c0 13.3 10.7 24 24 24l128 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L81.9 432 224 289.9 366.1 432 296 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l128 0c13.3 0 24-10.7 24-24l0-128c0-13.3-10.7-24-24-24s-24 10.7-24 24L400 398.1 257.9 256 400 113.9 400 184c0 13.3 10.7 24 24 24s24-10.7 24-24l0-128c0-13.3-10.7-24-24-24L296 32z"/></svg>',
        'ban' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M385.1 419.1L92.9 126.9c-28.1 35.5-44.9 80.3-44.9 129.1 0 114.9 93.1 208 208 208 48.8 0 93.7-16.8 129.1-44.9zm33.9-33.9c28.1-35.5 44.9-80.3 44.9-129.1 0-114.9-93.1-208-208-208-48.8 0-93.7 16.8-129.1 44.9L419.1 385.1zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"/></svg>',
        'bed-front' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M96 32C60.7 32 32 60.7 32 96l0 148.1C12.5 260.3 0 284.7 0 312L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 416 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-27.3-12.5-51.7-32-67.9L480 96c0-35.3-28.7-64-64-64L96 32zM400 224l-96 0c-17.7 0-32-14.3-32-32l0-16c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 16c0 17.7-14.3 32-32 32zm-192 0l-96 0c-17.7 0-32-14.3-32-32l0-16c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 16c0 17.7-14.3 32-32 32zm256 88l0 56-416 0 0-56c0-22.1 17.9-40 40-40l336 0c22.1 0 40 17.9 40 40z"/></svg>',
        'bus-simple' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M96 48C69.5 48 48 69.5 48 96l352 0c0-26.5-21.5-48-48-48L96 48zM48 144l0 64 352 0 0-64-352 0zM400 256l-352 0 0 128c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-128zM0 256L0 96C0 43 43 0 96 0L352 0c53 0 96 43 96 96l0 288c0 29.8-20.4 54.9-48 62l0 42c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-256 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-42c-27.6-7.1-48-32.2-48-62L0 256zm128 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'car' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M118.4 112.8L92 192 420 192 393.6 112.8C387.1 93.2 368.8 80 348.1 80L163.9 80c-20.7 0-39 13.2-45.5 32.8zM39.8 196.7l33-99.1C85.9 58.4 122.6 32 163.9 32l184.2 0c41.3 0 78 26.4 91.1 65.6l33 99.1c23.3 9.5 39.8 32.5 39.8 59.3l0 200c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-416 0 0 40c0 13.3-10.7 24-24 24S0 469.3 0 456L0 256c0-26.8 16.4-49.7 39.8-59.3zM64 240c-8.8 0-16 7.2-16 16l0 112 416 0 0-112c0-8.8-7.2-16-16-16L64 240zm48 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'caret-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M313.4 208L192 329.4 70.6 208 313.4 208zm68.2-28.2c-5-12-16.6-19.8-29.6-19.8L32 160c-12.9 0-24.6 7.8-29.6 19.8S.2 205.5 9.4 214.6l160 160c12.5 12.5 32.8 12.5 45.3 0l160-160c9.2-9.2 11.9-22.9 6.9-34.9z"/></svg>',
        'check' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M438 68.5c10.8 7.7 13.2 22.7 5.5 33.5l-264 368c-4.1 5.7-10.5 9.4-17.5 9.9S148 478 143 473L7 337c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L157 419 404.5 74c7.7-10.8 22.7-13.2 33.5-5.5z"/></svg>',
        'check-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm84.4-299.3c7-11.2 3.6-26-7.6-33.1s-26-3.6-33.1 7.6l-61.4 98.3-27-36c-8-10.6-23-12.8-33.6-4.8s-12.8 23-4.8 33.6l48 64c4.7 6.3 12.3 9.9 20.2 9.6s15.1-4.5 19.3-11.3l80-128z"/></svg>',
        'chevron-down' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M207.5 409c9.4 9.4 24.6 9.4 33.9 0l200-200c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-183 183-183-183c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l200 200z"/></svg>',
        'chevron-up' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M207.5 103c9.4-9.4 24.6-9.4 33.9 0l200 200c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-183-183-183 183c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l200-200z"/></svg>',
        'copy' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M384 336l-192 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l133.5 0c4.2 0 8.3 1.7 11.3 4.7l58.5 58.5c3 3 4.7 7.1 4.7 11.3L400 320c0 8.8-7.2 16-16 16zM192 384l192 0c35.3 0 64-28.7 64-64l0-197.5c0-17-6.7-33.3-18.7-45.3L370.7 18.7C358.7 6.7 342.5 0 325.5 0L192 0c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64zM64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-16-48 0 0 16c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l16 0 0-48-16 0z"/></svg>',
        'envelope-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M512 416c0 35.3-28.5 64-63.9 64L64 480c-35.4 0-64-28.7-64-64L0 164c.1-15.5 7.8-30 20.5-38.8L206-2.7c30.1-20.7 69.8-20.7 99.9 0L491.5 125.2c12.8 8.8 20.4 23.3 20.5 38.8l0 252zM64 432l384.1 0c8.8 0 15.9-7.1 15.9-16l0-191.7-154.8 117.4c-31.4 23.9-74.9 23.9-106.4 0L48 224.3 48 416c0 8.9 7.2 16 16 16zM463.6 164.4L278.7 36.8c-13.7-9.4-31.7-9.4-45.4 0L48.4 164.4 231.8 303.5c14.3 10.8 34.1 10.8 48.4 0L463.6 164.4z"/></svg>',
        'expand' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M136 32c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 88c0 13.3-10.7 24-24 24S0 181.3 0 168L0 56C0 42.7 10.7 32 24 32l112 0zM0 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24L0 344zM424 32c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-88 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0zM400 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l88 0 0-88z"/></svg>',
        'file-pdf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l80 0 0 48-80 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-48 0 0-128-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM240 380l32 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-12 0 0 28c0 11-9 20-20 20s-20-9-20-20l0-128c0-11 9-20 20-20zm32 80c11 0 20-9 20-20s-9-20-20-20l-12 0 0 40 12 0zm96-80l32 0c28.7 0 52 23.3 52 52l0 64c0 28.7-23.3 52-52 52l-32 0c-11 0-20-9-20-20l0-128c0-11 9-20 20-20zm32 128c6.6 0 12-5.4 12-12l0-64c0-6.6-5.4-12-12-12l-12 0 0 88 12 0zm76-108c0-11 9-20 20-20l48 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 24 28 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 44c0 11-9 20-20 20s-20-9-20-20l0-128z"/></svg>',
        'gear' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M205.5 92.7l13.7-60.7 73.6 0 13.7 60.7c1.7 7.4 6.8 13.6 13.8 16.7 10.8 4.8 21 10.7 30.4 17.6 6.1 4.5 14.1 5.9 21.4 3.6l59.5-18.5 36.8 63.8-45.8 42.3c-5.6 5.2-8.4 12.7-7.6 20.2 1.3 11.5 1.3 23.7 0 35.2-.8 7.6 2 15.1 7.6 20.2l45.8 42.3-36.8 63.8-59.5-18.5c-7.3-2.3-15.2-.9-21.4 3.6-9.4 6.9-19.6 12.9-30.4 17.6-7 3.1-12.1 9.3-13.8 16.7l-13.7 60.7-73.6 0-13.7-60.7c-1.7-7.4-6.8-13.6-13.8-16.7-10.8-4.8-21-10.7-30.4-17.6-6.1-4.5-14.1-5.9-21.4-3.6l-59.5 18.5-36.8-63.8 45.8-42.3c5.6-5.2 8.4-12.7 7.6-20.2-1.3-11.5-1.3-23.7 0-35.2 .8-7.6-2-15.1-7.6-20.2l-45.8-42.3 36.8-63.8 59.5 18.5c7.3 2.3 15.2 .9 21.4-3.6 9.4-6.9 19.6-12.9 30.4-17.6 7-3.1 12.1-9.3 13.8-16.7zM212.8-16c-18.7 0-34.9 13-39 31.2L161.2 70.8c-6.3 3.2-12.3 6.7-18.2 10.5L88.6 64.4c-17.9-5.6-37.2 2-46.5 18.2L-1.1 157.4c-9.3 16.2-6.2 36.7 7.5 49.4l41.9 38.7c-.3 6.9-.3 14 0 21L6.4 305.2c-13.7 12.7-16.9 33.2-7.5 49.4l43.2 74.8c9.3 16.2 28.7 23.7 46.5 18.2l54.5-16.9c5.9 3.8 11.9 7.3 18.2 10.5l12.6 55.6c4.1 18.2 20.3 31.2 39 31.2l86.4 0c18.7 0 34.9-13 39-31.2l12.6-55.6c6.3-3.2 12.3-6.7 18.2-10.5l54.5 16.9c17.9 5.6 37.2-2 46.5-18.2l43.2-74.8c9.3-16.2 6.2-36.7-7.5-49.4l-41.9-38.7c.3-6.9 .3-14 0-21l41.9-38.7c13.7-12.7 16.8-33.2 7.5-49.4L470 82.6c-9.4-16.2-28.7-23.7-46.5-18.2L369 81.3c-5.9-3.8-11.9-7.3-18.2-10.5L338.3 15.2C334.1-3 317.9-16 299.2-16l-86.4 0zM304 256a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-96a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"/></svg>',
        'gear-code' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M205.5 92.7l13.7-60.7 73.6 0 13.7 60.7c1.7 7.4 6.8 13.6 13.8 16.7 10.8 4.8 21 10.7 30.4 17.6 6.1 4.5 14.1 5.9 21.4 3.6l59.5-18.5 36.8 63.8-45.8 42.3c-5.6 5.2-8.4 12.7-7.6 20.2 1.3 11.5 1.3 23.7 0 35.2-.8 7.6 2 15.1 7.6 20.2l45.8 42.3-36.8 63.8-59.5-18.5c-7.3-2.3-15.2-.9-21.4 3.6-9.4 6.9-19.6 12.9-30.4 17.6-7 3.1-12.1 9.3-13.8 16.7l-13.7 60.7-73.6 0-13.7-60.7c-1.7-7.4-6.8-13.6-13.8-16.7-10.8-4.8-21-10.7-30.4-17.6-6.1-4.5-14.1-5.9-21.4-3.6l-59.5 18.5-36.8-63.8 45.8-42.3c5.6-5.2 8.4-12.7 7.6-20.2-1.3-11.5-1.3-23.7 0-35.2 .8-7.6-2-15.1-7.6-20.2l-45.8-42.3 36.8-63.8 59.5 18.5c7.3 2.3 15.2 .9 21.4-3.6 9.4-6.9 19.6-12.9 30.4-17.6 7-3.1 12.1-9.3 13.8-16.7zM212.8-16c-18.7 0-34.9 13-39 31.2L161.2 70.8c-6.3 3.2-12.3 6.7-18.2 10.5L88.6 64.4c-17.9-5.6-37.2 2-46.5 18.2L-1.1 157.4c-9.3 16.2-6.2 36.7 7.5 49.4l41.9 38.7c-.3 6.9-.3 14 0 21L6.4 305.2c-13.7 12.7-16.9 33.2-7.5 49.4l43.2 74.8c9.3 16.2 28.7 23.7 46.5 18.2l54.5-16.9c5.9 3.8 11.9 7.3 18.2 10.5l12.6 55.6c4.1 18.2 20.3 31.2 39 31.2l86.4 0c18.7 0 34.9-13 39-31.2l12.6-55.6c6.3-3.2 12.3-6.7 18.2-10.5l54.5 16.9c17.9 5.6 37.2-2 46.5-18.2l43.2-74.8c9.3-16.2 6.2-36.7-7.5-49.4l-41.9-38.7c.3-6.9 .3-14 0-21l41.9-38.7c13.7-12.7 16.8-33.2 7.5-49.4L470 82.6c-9.4-16.2-28.7-23.7-46.5-18.2L369 81.3c-5.9-3.8-11.9-7.3-18.2-10.5L338.3 15.2C334.1-3 317.9-16 299.2-16l-86.4 0zm78.9 179.3c1.8-10.9-5.5-21.2-16.4-23s-21.2 5.5-23 16.4l-32 192c-1.8 10.9 5.5 21.2 16.4 23s21.2-5.5 23-16.4l32-192zm-93.6 66.9c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0l-40 40c-7.8 7.8-7.8 20.5 0 28.3l40 40c7.8 7.8 20.5 7.8 28.3 0s7.8-20.5 0-28.3l-25.9-25.9 25.9-25.9zm144-28.3c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3l25.9 25.9-25.9 25.9c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l40-40c7.8-7.8 7.8-20.5 0-28.3l-40-40z"/></svg>',
        'graduation-cap' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M318.8 38.1C309 34.1 298.6 32 288 32s-21 2.1-30.8 6.1L14.8 137.9C5.8 141.6 0 150.3 0 160L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-260.2 48 19.8 0 168.5c0 53 86 96 192 96s192-43 192-96l0-168.5 81.2-33.4c9-3.7 14.8-12.4 14.8-22.1s-5.8-18.4-14.8-22.1L318.8 38.1zM144 384l0-148.7 113.2 46.6c9.8 4 20.2 6.1 30.8 6.1s21-2.1 30.8-6.1L432 235.3 432 384c0 .1 0 .1 0 .3s-.1 .4-.3 .9c-.4 .9-1.3 2.7-3.4 5.2-4.4 5.2-12.6 11.9-26 18.6-26.8 13.4-67.1 23-114.3 23s-87.5-9.7-114.3-23c-13.4-6.7-21.6-13.4-26-18.6-2.1-2.5-3-4.3-3.4-5.2-.2-.5-.3-.8-.3-.9s0-.2 0-.3zM87.2 160L275.5 82.5c4-1.6 8.2-2.5 12.5-2.5s8.5 .8 12.5 2.5L488.8 160 300.5 237.5c-4 1.6-8.2 2.5-12.5 2.5s-8.5-.8-12.5-2.5L87.2 160z"/></svg>',
        'grid-2' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M48 80l0 96 96 0 0-96-96 0zM0 80C0 53.5 21.5 32 48 32l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48L0 80zM48 336l0 96 96 0 0-96-96 0zM0 336c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-96zM400 80l-96 0 0 96 96 0 0-96zM304 32l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48zm0 304l0 96 96 0 0-96-96 0zm-48 0c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-96z"/></svg>',
        'heart' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M378.9 80c-27.3 0-53 13.1-69 35.2l-34.4 47.6c-4.5 6.2-11.7 9.9-19.4 9.9s-14.9-3.7-19.4-9.9l-34.4-47.6c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1zM271 87.1c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 68.6-42.9 128.9-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.3 9.4-27.5 14.1-43.1 14.1s-30.8-4.7-43.1-14.1C176.4 438 123.2 391.5 79.1 338 42.9 294.1 0 233.7 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l15 20.7 15-20.7z"/></svg>',
        'heart-crack' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M309.9 115.2l-3.9 5.4 13.2 27.9c1.8 3.8 .4 8.2-3.2 10.3l-88.9 51.9 59.7 97c2.1 3.4 1.4 7.8-1.7 10.4s-7.6 2.4-10.5-.3l-112-104c-1.6-1.5-2.5-3.5-2.6-5.7s.8-4.3 2.3-5.8l59.6-59.6-19.9-27.5c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1-27.3 0-53 13.1-69 35.2zM270.5 87.7l.5-.6c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 68.6-42.9 128.9-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.3 9.4-27.5 14.1-43.1 14.1s-30.8-4.7-43.1-14.1C176.4 438 123.2 391.5 79.1 338 42.9 294.1 0 233.7 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l7.4 10.2 6.8 4.6 15.3-14.1z"/></svg>',
        'house-building' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M576 48L352 48c-8.8 0-16 7.2-16 16l0 71.9-48-41.7 0-30.2c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64l-164.1 0c9.8-14 16.4-30.3 18.9-48L576 464c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16zm-96 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM480 304c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM400 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm-176.3 5.9l184 160c10 8.7 11.1 23.9 2.4 33.9-6.7 7.7-17.1 10.1-26.1 6.9L384 448c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-145.4c-9 3.2-19.5 .8-26.1-6.9-8.7-10-7.6-25.2 2.4-33.9l184-160c9-7.9 22.5-7.9 31.5 0zM336 263.1L208 151.8 80 263.1 80 448c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-184.9zM160 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"/></svg>',
        'house-user' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M240 6.1c9.1-8.2 22.9-8.2 32 0l232 208c9.9 8.8 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-8-7.2 0 205.3c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-205.3-8 7.2c-9.9 8.8-25 8-33.9-1.8s-8-25 1.8-33.9L240 6.1zm16 50.1L96 199.7 96 448c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-248.3-160-143.4zM200 224a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM144 400c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"/></svg>',
        'image' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm128 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm136 72c8.5 0 16.4 4.5 20.7 11.8l80 136c4.4 7.4 4.4 16.6 .1 24.1S352.6 384 344 384l-240 0c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l17.2 24.6 46.5-79c4.3-7.3 12.2-11.8 20.7-11.8z"/></svg>',
        'input-pipe' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm160 56l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24z"/></svg>',
        'leaf' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M471.3 6.7C477.7 .6 487-1.6 495.6 1.2 505.4 4.5 512 13.7 512 24l0 186.9C512 342.1 403.9 448 273.2 448 191.7 448 121.9 392.4 101.8 316.8 68.7 347.4 48 391.3 48 440l0 16c0 13.3-10.7 24-24 24S0 469.2 0 456l0-16c0-75.1 38.3-141.2 96.4-179.9 6.1-91.7 82.4-164.1 175.6-164.1 66.4 0 115.8-22.1 148.7-44 19.2-12.8 35.5-28.1 50.7-45.3zM464 79.9c-38.3 29.5-102.4 64.1-192 64.1-57.6 0-106.4 38.1-122.4 90.4 20.9-6.8 43.2-10.4 66.4-10.4l80 0c13.3 0 24 10.8 24 24s-10.7 24-24 24l-80 0c-25.4 0-49.4 5.7-71 15.8 7.9 63.1 62.6 112.2 128.2 112.2 104.7 0 190.8-84.9 190.8-189.1l0-131z"/></svg>',
        'location-dot' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M48 188.6C48 111.7 111.7 48 192 48s144 63.7 144 140.6c0 45.6-23.8 101.5-58.9 157.1-28.3 44.8-61 84.8-85.1 112.1-24.1-27.3-56.7-67.2-85.1-112.1-35.1-55.5-58.9-111.5-58.9-157.1zM192 0C86 0 0 84.4 0 188.6 0 307.9 120.2 450.9 170.4 505.4 182.2 518.2 201.8 518.2 213.6 505.4 263.8 450.9 384 307.9 384 188.6 384 84.4 298 0 192 0zM160 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"/></svg>',
        'paper-plane' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M290.5 287.7L491.4 86.9 359 456.3 290.5 287.7zM457.4 53L256.6 253.8 88 185.3 457.4 53zM38.1 216.8l205.8 83.6 83.6 205.8c5.3 13.1 18.1 21.7 32.3 21.7 14.7 0 27.8-9.2 32.8-23.1L570.6 8c3.5-9.8 1-20.6-6.3-28s-18.2-9.8-28-6.3L39.4 151.7c-13.9 5-23.1 18.1-23.1 32.8 0 14.2 8.6 27 21.7 32.3z"/></svg>',
        'paper-plane-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M169.9 280L94.9 448.6 461.2 280 169.9 280zm291.3-48L94.9 63.4 169.9 232 461.2 232zM34.8 465.6L128 256 34.8 46.4C33 42.2 32 37.6 32 33 32 14.8 46.7 0 64.8 0 69.5 0 74.2 1 78.5 3L554.2 222c13.3 6.1 21.8 19.4 21.8 34s-8.5 27.9-21.8 34L78.5 509c-4.3 2-9 3-13.7 3-18.1 0-32.8-14.8-32.8-33 0-4.6 1-9.2 2.8-13.4z"/></svg>',
        'arrow-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M505 273c9.4-9.4 9.4-24.6 0-33.9L337 71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l127 127-406.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l406.1 0-127 127c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L505 273z"/></svg>',
        'arrow-long-right' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M569 273c9.4-9.4 9.4-24.6 0-33.9L433 103c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l95 95-470.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l470.1 0-95 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L569 273z"/></svg>',
        'magnifying-glass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M368 208a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM337.1 371.1C301.7 399.2 256.8 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208c0 48.8-16.8 93.7-44.9 129.1L505 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L337.1 371.1z"/></svg>',
        'pen' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7l294-294C366.4 7.6 384.8 0 404 0s37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1l-294 294c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8zM386.8 55.1l-52.9 52.9 70.1 70.1 52.9-52.9c4.6-4.6 7.1-10.7 7.1-17.2s-2.6-12.6-7.1-17.2L421.2 55.1C416.6 50.6 410.4 48 404 48s-12.6 2.6-17.2 7.1zM300 141.9L92.9 349.1c-4.9 4.9-8.4 10.9-10.3 17.6l-24.1 86.9 86.9-24.1c6.6-1.8 12.7-5.4 17.6-10.3L370.1 212 300 141.9z"/></svg>',
        'percent' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M96 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 144a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM352 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 144a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM441 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 439c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L441 73z"/></svg>',
        'phone' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M112.8 10.9c27.3-9.1 57 3.9 68.9 30l39.7 87.3c10.6 23.4 4 51-16 67.1l-24.2 19.3c25.5 50 65.5 91.4 114.4 118.8l21.2-26.6c16.1-20.1 43.7-26.7 67.1-16l87.3 39.7c26.2 11.9 39.1 41.6 30 68.9-20.7 62.3-83.7 116.2-160.9 102.6-173.7-30.6-299.6-156.5-330.2-330.2-13.6-77.2 40.4-140.1 102.6-160.9zm25.2 49.9c-1.7-3.8-6-5.7-10-4.4-45.2 15.1-79.1 58.6-70.5 107 27.1 153.8 137.4 264.2 291.2 291.3 48.4 8.5 91.9-25.3 107-70.5 1.3-4-.6-8.3-4.4-10L364 334.4c-3.4-1.5-7.4-.6-9.7 2.3l-33.5 41.9c-7 8.7-19 11.5-29 6.7-72.5-34.4-130.5-94.3-162.4-168.2-4.3-9.9-1.4-21.5 7-28.2l38.9-31.1c2.9-2.3 3.9-6.3 2.3-9.7L137.9 60.7z"/></svg>',
        'plane-departure' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M517.6 134.1c16.6-6 35 2.5 41 19.1s-2.5 35-19.1 41L201.2 317.4c-3.4 1.2-11.7 4.3-25 9.1-18.2 6.6-38.5-.7-48.2-17.4l-48.8-83.5 1.2-.4 73 34c5.8 2.7 12.4 3 18.4 .8l77.7-28.3c7.2-2.6 12.8-8.6 14.9-16s.5-15.4-4.3-21.4L165.5 75 191.9 65.3 394.4 170.7c6 3.1 13 3.6 19.3 1.3l104-37.8zm86.1 2.7c-15.1-41.5-61-62.9-102.5-47.8L407.1 123.2 204.7 17.9c-6-3.1-13-3.6-19.3-1.3L117.8 41.3c-7.2 2.6-12.8 8.6-14.9 16s-.5 15.4 4.3 21.4l94.6 119.2-37 13.5-73-34c-5.8-2.7-12.4-3-18.4-.8L35.8 190.3c-6.7 2.4-11.9 7.7-14.4 14.4s-1.7 14.1 1.9 20.3L86.6 333.3c21.5 36.7 66.1 52.8 106.1 38.3 13.3-4.8 21.6-7.9 25-9.1L555.9 239.3c41.5-15.1 62.9-61 47.8-102.5zM56.1 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-528 0z"/></svg>',
        'plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M248 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176-176 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0 0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176 176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0 0-176z"/></svg>',
        'minus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 256c0-13.3 10.7-24 24-24l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 280c-13.3 0-24-10.7-24-24z"/></svg>',
        'circle-question' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256-80c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 47.2-36 67.2-56 74.5l0 3.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8.1c0-20.5 14.8-35.2 30.1-40.2 6.4-2.1 13.2-5.5 18.2-10.3 4.3-4.2 7.7-10 7.7-19.6 0-17.7-14.3-32-32-32zM224 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"/></svg>',
        'ruler-triangle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M80 70.6L163.7 154.3 127 191c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l36.7-36.7 46.1 46.1-12.7 12.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l12.7-12.7 46.1 46.1-36.7 36.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l36.7-36.7 83.7 83.7-361.4 0 0-361.4zM86.6 9.4C77.5 .2 63.7-2.5 51.8 2.4S32 19.1 32 32l0 416c0 17.7 14.3 32 32 32l416 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9L86.6 9.4zM168.2 272c-3-3-8.2-.9-8.2 3.4l0 68.6c0 4.4 3.6 8 8 8l68.6 0c4.3 0 6.4-5.2 3.4-8.2L168.2 272z"/></svg>',
        'share' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M312 176c13.3 0 24-10.7 24-24L336 86.6 457.4 208 336 329.4 336 264c0-13.3-10.7-24-24-24l-120 0c-66.2 0-122 44.7-138.8 105.5-3.3-12.4-5.2-26.2-5.2-41.5 0-70.7 57.3-128 128-128l136 0zM288 288l0 80c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9S288 35.1 288 48l0 80-112 0c-97.2 0-176 78.8-176 176 0 78 38.6 126.2 68.7 152.1 4.1 3.5 8.1 6.6 11.7 9.3 3.2 2.4 6.2 4.4 8.9 6.2 4.5 3 8.3 5.1 10.8 6.5 2.5 1.4 5.3 1.9 8.1 1.9 10.9 0 19.7-8.9 19.7-19.7 0-6.8-3.6-13.2-8.3-18.1-.5-.5-.9-.9-1.4-1.4-2.4-2.3-5.1-5.1-7.7-8.6-1.7-2.3-3.4-5-5-7.9-5.3-9.7-9.5-22.9-9.5-40.2 0-53 43-96 96-96l96 0z"/></svg>',
        'share-nodes' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M432 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm48 0c0 53-43 96-96 96-27.4 0-52.1-11.5-69.6-29.9L188.9 231.8c2 7.7 3.1 15.8 3.1 24.2s-1.1 16.5-3.1 24.2l125.5 69.7c17.5-18.4 42.2-29.9 69.6-29.9 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-8.3 1.1-16.5 3.1-24.2L165.6 322.1C148.1 340.5 123.4 352 96 352 43 352 0 309 0 256s43-96 96-96c27.4 0 52.1 11.5 69.6 29.9l125.5-69.7c-2-7.7-3.1-15.8-3.1-24.2 0-53 43-96 96-96s96 43 96 96zM144 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM384 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/></svg>',
        'shop' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M121.2 88.8c2.7-5.4 8.3-8.8 14.3-8.8l304.9 0c6.1 0 11.6 3.4 14.3 8.8l56.8 113.7c.3 .5 .4 1.1 .4 1.7 0 2.1-1.7 3.8-3.8 3.8L67.8 208c-2.1 0-3.8-1.7-3.8-3.8 0-.6 .1-1.2 .4-1.7L121.2 88.8zM16 204.2c0 27.3 21.2 49.7 48 51.6l0 .1 0 176c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-176 112 0 0 200c0 13.3 10.7 24 24 24s24-10.7 24-24l0-200.1c26.8-1.9 48-24.3 48-51.6 0-8-1.9-16-5.5-23.2L497.7 67.4C486.8 45.7 464.7 32 440.4 32L135.6 32c-24.2 0-46.4 13.7-57.2 35.4L21.5 181.1c-3.6 7.2-5.5 15.1-5.5 23.2zM112 336l0-80 192 0 0 80-192 0zm0 48l192 0 0 48-192 0 0-48z"/></svg>',
        'table-layout' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M384 80c8.8 0 16 7.2 16 16l0 64-352 0 0-64c0-8.8 7.2-16 16-16l320 0zM0 160L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 64zM400 416c0 8.8-7.2 16-16 16l-224 0 0-224 240 0 0 208zM112 432l-48 0c-8.8 0-16-7.2-16-16l0-208 64 0 0 224z"/></svg>',
        'trash' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M136.2 4.8c4.7-12.5 16.6-20.8 30-20.8l115.6 0c13.3 0 25.3 8.3 30 20.8L328 48 424 48c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 96C10.7 96 0 85.3 0 72S10.7 48 24 48l96 0 16.2-43.2zm-84.6 448L28.7 144 76.9 144 99.5 449.2c.6 8.4 7.6 14.8 16 14.8l217.1 0c8.4 0 15.3-6.5 16-14.8l22.6-305.2 48.1 0-22.9 308.7c-2.5 33.4-30.3 59.3-63.8 59.3l-217.1 0c-33.5 0-61.3-25.9-63.8-59.3z"/></svg>',
        'trowel-bricks' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M176 66.1L176 189.9 71.2 128 176 66.1zM163.7 17.6L35.1 93.6C8.9 109 8.9 147 35.1 162.4l128.5 76c26.7 15.8 60.3-3.5 60.3-34.4l0-52 264 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-264 0 0-52c0-31-33.7-50.2-60.3-34.4zM288 384l176 0 0 80-208 0 0-80 32 0zm-80 0l0 80-160 0 0-80 160 0zm256-48l-128 0 0-80 128 0 0 80zM288 256l0 80-240 0c-26.5 0-48 21.5-48 48l0 80c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-80c0-1.3-.1-2.7-.2-4 .1-1.3 .2-2.7 .2-4l0-120c0-26.5-21.5-48-48-48l-128 0c-26.5 0-48 21.5-48 48z"/></svg>',
        'video' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M96 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L96 112zM32 128c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L96 448c-35.3 0-64-28.7-64-64l0-256zm505.6-11.2c4.2-3.1 9.2-4.8 14.4-4.8 13.3 0 24 10.7 24 24l0 240c0 13.3-10.7 24-24 24-5.2 0-10.2-1.7-14.4-4.8l-73.6-55.2 0-60 64 48 0-144-64 48 0-60 73.6-55.2z"/></svg>',
        'street-view' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M232 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm96 0a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zM144 248l0 26.7c0 14.9 5.9 29.1 16.4 39.6l17.3 17.3 9.9 54.3c4.8 26.6 28 46 55.1 46l26.6 0c27.1 0 50.3-19.4 55.1-46l9.9-54.3 17.3-17.3c10.5-10.5 16.4-24.7 16.4-39.6l0-26.7c0-48.6-39.4-88-88-88l-48 0c-48.6 0-88 39.4-88 88zm88-40l48 0c22.1 0 40 17.9 40 40l0 26.7c0 2.1-.8 4.2-2.3 5.7L295 303c-3.5 3.4-5.8 7.9-6.6 12.7l-11.2 61.7c-.7 3.8-4 6.6-7.9 6.6l-26.6 0c-3.9 0-7.2-2.8-7.9-6.6l-11.2-61.7c-.9-4.8-3.2-9.2-6.6-12.7l-22.6-22.6c-1.5-1.5-2.3-3.5-2.3-5.7l0-26.7c0-22.1 17.9-40 40-40zM133.9 344.5c-16.6 2.5-32.2 5.6-46.3 9.3-22.4 5.8-42.6 13.3-57.8 23.3-14.7 9.6-29.8 24.9-29.8 47s15.1 37.4 29.8 47C45 480.9 65.2 488.4 87.6 494.2 132.7 505.9 192.9 512 256 512s123.3-6.1 168.4-17.8c22.4-5.8 42.6-13.3 57.8-23.3 14.7-9.6 29.8-24.9 29.8-47s-15.1-37.4-29.8-47c-15.2-9.9-35.5-17.5-57.8-23.3-14.1-3.6-29.6-6.7-46.3-9.3l-5.3 47.8c14.4 2.2 27.7 4.9 39.6 8 56.6 14.6 56.6 32.9 0 47.5-39.9 10.3-95.8 16.2-156.4 16.2s-116.5-5.9-156.4-16.2c-56.6-14.6-56.6-32.9 0-47.5 11.9-3.1 25.2-5.8 39.6-8l-5.3-47.8z"/></svg>',
        'warning' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M53.4 432L256 56.8 458.6 432 53.4 432zM291.2 21C284.2 8.1 270.7 0 256 0s-28.2 8.1-35.2 21L4.8 421c-6.7 12.4-6.4 27.4 .8 39.5S25.9 480 40 480l432 0c14.1 0 27.1-7.4 34.4-19.5s7.5-27.1 .8-39.5L291.2 21zM256 168c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm26.7 216a26.7 26.7 0 1 0 -53.3 0 26.7 26.7 0 1 0 53.3 0z"/></svg>',
        'water' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M410.6 124.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm0 144c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.7-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm-71.2 144c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9z"/></svg>',
        'water-ladder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M381.9 400.6c37.5-23.8 85.6-22.1 121.6 5.1l6.3 4.6c14.6 10.2 28.5 17.3 41.5 20 13.7 2.8 27.4 .9 42.3-10.3l2-1.4c10.4-6.3 24.1-3.8 31.6 6.1 8 10.6 5.9 25.6-4.7 33.6l-5 3.5c-24.9 16.8-50.9 20.5-75.7 15.5-25.3-5.1-48.1-18.9-67.2-33.3-20-15.1-46.4-16-67.2-2.8l-4.1 2.8c-24.2 18.3-52.3 35.9-83.4 35.9-27.2 0-52.1-13.5-74.1-29.2l-9.3-6.8c-20-15.1-46.3-16-67.1-2.8l-4.1 2.8c-23.7 17.9-54.1 35.5-88 35.3-17.9-.1-35.6-5.2-52.6-16.1l-7.2-5-1.9-1.6c-8.9-8.3-10.3-22.1-2.8-32 7.5-9.9 21.2-12.4 31.6-6.1l2 1.4 4.2 2.9c9.7 6.3 18.6 8.5 27 8.5 17.6 .1 37.3-9.4 58.9-25.7l7.4-5.1c37.5-23.7 85.6-22.1 121.6 5.1l8.7 6.3c19.5 13.7 33.8 20 45.8 20 13.7 0 30.5-8.2 54.5-26.3l7.4-5.1zM512 32c53 0 96 43 96 96l0 8c0 13.3-10.7 24-24 24-13.2 0-24-10.8-24-24l0-8c0-26.5-21.5-48-48-48-26.5 0-48 21.5-48 48l0 208.9c-6-.7-12-1-18-.9-10 .1-20.1 1.1-30 3.2l0-67-208 0 0 63.8c-16.2 .1-32.4 2.8-48 8l0-216c0-53 43-96 96-96 53 0 96 43 96 96l0 8c0 13.3-10.7 24-24 24-13.2 0-24-10.8-24-24l0-8c0-26.5-21.5-48-48-48-26.5 0-48 21.5-48 48l0 96.2 208 0 0-96.2c0-53 43-96 96-96z"/></svg>',
        'xmark-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM167 167c-9.4 9.4-9.4 24.6 0 33.9l55 55-55 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l55-55 55 55c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55-55 55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55-55-55c-9.4-9.4-24.6-9.4-33.9 0z"/></svg>',
        'xmark-large' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M7.5 41C-1.8 31.6-1.8 16.4 7.5 7S32.1-2.3 41.5 7l215 215 215-215c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-215 215 215 215c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-215-215-215 215c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l215-215-215-215z"/></svg>',
        'door-open' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M96 48l160 0c8.8 0 16 7.2 16 16l0 400-192 0 0-400c0-8.8 7.2-16 16-16zM80 512l216 0c13.3 0 24-10.7 24-24l0-424c0-5.5-.7-10.9-2-16l34 0c8.8 0 16 7.2 16 16l0 424c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-400c0-35.3-28.7-64-64-64l-88 0 0 .5c-2.6-.3-5.3-.5-8-.5L96 0C60.7 0 32 28.7 32 64l0 400-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0zm96-256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"/></svg>',
        'toilet' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 24C0 10.7 10.7 0 24 0L424 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 159.1 .4 .4c14.1 11.9 23.6 28.3 23.6 48.5 0 72.7-33.4 120.2-78.4 148.3-1.7 1.1-3.5 2.1-5.2 3.2l22.3 40.7c3.5 6.3 5.3 13.5 5.3 20.7 0 23.8-19.3 43.1-43.1 43.1l-233.8 0c-23.8 0-43.1-19.3-43.1-43.1 0-7.2 1.8-14.4 5.3-20.7l22.3-40.7c-1.8-1-3.5-2.1-5.2-3.2-45-28.1-78.4-75.6-78.4-148.3 0-20.3 9.5-36.6 23.6-48.5l.4-.4 0-159.1-8 0C10.7 48 0 37.3 0 24zM74.2 326.8C84 342.5 97.1 354.4 111.8 363.7 145 384.4 188.1 392 224 392s79-7.6 112.2-28.3c14.7-9.2 27.8-21.2 37.6-36.9-2.4 .8-4.9 1.5-7.4 2.3-38 10.9-88.7 14.9-142.4 14.9s-104.4-4-142.4-14.9c-2.5-.7-4.9-1.5-7.4-2.3zm61.5 100l-20.4 37.2 217.3 0-20.4-37.2C281.7 436.5 250.4 440 224 440s-57.7-3.5-88.3-13.2zM392 256c0-3.7-1.2-7.4-6.6-12-6.1-5.1-16.5-10.4-32.2-15-31.5-9.1-76.8-13.1-129.1-13.1s-97.7 4-129.1 13.1c-15.8 4.5-26.2 9.8-32.3 15-5.4 4.6-6.6 8.2-6.6 12s1.2 7.4 6.6 12c6.1 5.1 16.5 10.4 32.3 15 31.5 9.1 76.8 13.1 129.1 13.1s97.7-4 129.1-13.1c15.8-4.5 26.2-9.8 32.2-15 5.4-4.6 6.6-8.2 6.6-12zM368 48l-288 0 0 135.4 1.6-.5C119.6 172 170.3 168 224 168s104.4 4 142.4 14.9l1.6 .5 0-135.4zM128 80l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"/></svg>',
        'bath' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M80 69.3c0-11.7 9.5-21.3 21.3-21.3 5.6 0 11 2.2 15 6.2l4.8 4.8c-5.8 11.1-9.1 23.7-9.1 37 0 23.9 10.5 45.4 27.2 60.1-5.3 9.2-4 21.1 3.9 28.9 9.4 9.4 24.6 9.4 33.9 0L281 81c9.4-9.4 9.4-24.6 0-33.9-7.8-7.8-19.7-9.1-28.9-3.9-14.7-16.7-36.1-27.2-60.1-27.2-13.4 0-25.9 3.3-37 9.1l-4.8-4.8C137.2 7.3 119.6 0 101.3 0 63 0 32 31 32 69.3l0 186.7-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 64c0 28.4 12.4 54 32 71.6L64 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-25.3c5.2 .9 10.5 1.3 16 1.3l256 0c5.5 0 10.8-.5 16-1.3l0 25.3c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48.4c19.6-17.6 32-43.1 32-71.6l0-64 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L80 256 80 69.3zm137.5 7.3l-44.8 44.8c-7.7-5.8-12.6-15.1-12.6-25.5 0-17.7 14.3-32 32-32 10.4 0 19.6 4.9 25.5 12.6zM80 304l352 0 0 64c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-64z"/></svg>',
        'shower' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 123.9c0-24.2 19.6-43.9 43.9-43.9 11.6 0 22.8 4.6 31 12.9l4.9 4.9C99.1 142.2 104.1 202.1 143 241l7.1 7.1c-8.4 9.4-8.1 23.9 .9 32.9 9.4 9.4 24.6 9.4 33.9 0L345 121c9.4-9.4 9.4-24.6 0-33.9-9-9-23.5-9.4-32.9-.9L305 79c-38.9-38.9-98.8-44-143.2-15.2l-4.9-4.9C139.6 41.7 116.3 32 91.9 32 41.1 32 0 73.1 0 123.9L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-332.1zM177 113c26-26 68.1-26 94.1 0l7 7-94.1 94.1-7-7c-26-26-26-68.1 0-94.1zm239 79a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>',
        'oven' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M352 48c26.5 0 48 21.5 48 48l0 80-352 0 0-80c0-26.5 21.5-48 48-48l256 0zm48 176l0 224c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-224 352 0zM96 0C43 0 0 43 0 96L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-352c0-53-43-96-96-96L96 0zm32 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm104-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 296c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0c-13.3 0-24 10.7-24 24z"/></svg>',
        'couch' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M112 192l0 44.1c17.2 11.5 29.2 30.3 31.6 51.9l352.9 0c2.4-21.6 14.4-40.4 31.6-51.9l0-44.1c0-44.2-35.8-80-80-80l-256 0c-44.2 0-80 35.8-80 80zM64 224.4L64 192c0-70.7 57.3-128 128-128l256 0c70.7 0 128 57.3 128 128l0 32.4c36 4 64 34.5 64 71.6l0 64c0 48.6-39.4 88-88 88L88 448c-48.6 0-88-39.4-88-88l0-64c0-37.1 28-67.6 64-71.6zM48 296l0 64c0 22.1 17.9 40 40 40l464 0c22.1 0 40-17.9 40-40l0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16c0 13.3-10.7 24-24 24l-400 0c-13.3 0-24-10.7-24-24l0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24z"/></svg>',
        'hotel' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l8 0 0 416-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-416 8 0c13.3 0 24-10.7 24-24S501.3 0 488 0L24 0zM432 464l-144 0 0-80 48 0c8.8 0 16.1-7.2 14.7-15.9-7.6-45.4-47.1-80.1-94.7-80.1s-87.1 34.6-94.7 80.1c-1.5 8.7 5.8 15.9 14.7 15.9l48 0 0 80-144 0 0-416 352 0 0 416zM144 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM336 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM128 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"/></svg>',
        'moon-stars' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M439.8 89.8l-11-38.6-38.6-11c-3.6-1-6.2-4.4-6.2-8.2s2.5-7.1 6.2-8.2l38.6-11 11-38.6c1-3.6 4.4-6.2 8.2-6.2s7.1 2.5 8.2 6.2l11 38.6 38.6 11c3.6 1 6.2 4.4 6.2 8.2s-2.5 7.1-6.2 8.2l-38.6 11-11 38.6c-1 3.6-4.4 6.2-8.2 6.2s-7.1-2.5-8.2-6.2zM371.8 326.8l-16.6-58-58-16.6c-5.5-1.6-9.2-6.6-9.2-12.2s3.8-10.7 9.2-12.2l58-16.6 16.6-58c1.6-5.5 6.6-9.2 12.2-9.2s10.7 3.8 12.2 9.2l16.6 58 58 16.6c5.5 1.6 9.2 6.6 9.2 12.2s-3.8 10.7-9.2 12.2l-58 16.6-16.6 58c-1.6 5.5-6.6 9.2-12.2 9.2s-10.7-3.8-12.2-9.2zm-8.8 86.7c8.8-.7 17.2 4.2 20.8 12.3s1.8 17.6-4.6 23.8c-4 3.9-8.2 7.6-12.5 11.1-38.7 32-88.5 51.3-142.7 51.3-123.7 0-224-100.3-224-224S100.3 64 224 64c10.9 0 21.6 .8 32.1 2.3 5.9 .8 11.8 1.9 17.5 3.2 8.7 2 15.2 9.2 16.2 18s-3.5 17.3-11.5 21.3c-53 26.4-89.3 81.1-89.3 144.2 0 88.9 72.1 161 161 161 4.4 0 8.7-.2 12.9-.5zM141 253c0-53.1 19.8-101.5 52.3-138.3-82.6 14.5-145.3 86.6-145.3 173.3 0 97.2 78.8 176 176 176 22.2 0 43.5-4.1 63.1-11.6-84.7-26.7-146.1-105.9-146.1-199.4z"/></svg>',
        'grid-2-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M144 80l0 96-96 0 0-96 96 0zM48 32C21.5 32 0 53.5 0 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L48 32zm96 304l0 96-96 0 0-96 96 0zM48 288c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0zM304 80l96 0 0 96-96 0 0-96zm-48 0l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zm96 208c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"/></svg>',
        'layer-plus' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M432-32c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24zM252.6 144.7L81.2 224 252.6 303.2c2.1 1 4.6 1 6.7 0L430.8 224 259.4 144.7c-2.1-1-4.6-1-6.7 0zm-20.1-43.6c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 245.8C5.4 241.8 0 233.3 0 224s5.4-17.9 13.9-21.8l218.6-101zM13.9 362.2l68.7-31.8 57.2 26.4-58.7 27.1 171.4 79.2c2.1 1 4.6 1 6.7 0l171.4-79.2-58.7-27.1 57.2-26.4 68.7 31.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8C5.4 401.8 0 393.3 0 384s5.4-17.9 13.9-21.8z"/></svg>',
        'layer-group' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M259.4 48.7L430.8 128 259.4 207.2c-2.1 1-4.6 1-6.7 0L81.2 128 252.6 48.7c2.1-1 4.6-1 6.7 0zM279.5 5.2c-14.9-6.9-32.1-6.9-47 0L13.9 106.2C5.4 110.1 0 118.6 0 128s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8L279.5 5.2zM48.1 218.4L13.9 234.2C5.4 238.1 0 246.6 0 256s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-34.1-15.8-57.2 26.4 24.1 11.1-171.4 79.2c-2.1 1-4.6 1-6.7 0L81.2 256 105.3 244.9 48.1 218.4zM13.9 362.2C5.4 366.1 0 374.6 0 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-34.1-15.8-57.2 26.4 24.1 11.1-171.4 79.2c-2.1 1-4.6 1-6.7 0l-171.4-79.2 24.1-11.1-57.2-26.4-34.1 15.8z"/></svg>',
        'lamp' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M56 240l336 0-66.7-160-202.7 0-66.7 160zm88 48L32 288c-10.7 0-20.7-5.3-26.6-14.2s-7-20.2-2.9-30.1l80-192C87.4 39.8 99.1 32 112 32l224 0c12.9 0 24.6 7.8 29.5 19.7l80 192c4.1 9.9 3 21.2-2.9 30.1S426.7 288 416 288l-112 0 0 28.1c29.3 23.5 48 59.5 48 99.9 0 38.2-16.8 72.5-43.3 96l-169.3 0c-26.6-23.5-43.3-57.8-43.3-96 0-40.4 18.7-76.5 48-99.9l0-28.1zm112 0l-64 0 0 51.1-18 14.4c-18.4 14.7-30 37.2-30 62.5 0 18 5.9 34.6 16 48l128 0c10.1-13.4 16-30 16-48 0-25.2-11.6-47.7-30-62.5l-18-14.4 0-51.1z"/></svg>',
        'stairs' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M384 56c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 120c0 13.3-10.7 24-24 24l-104 0 0 104c0 13.3-10.7 24-24 24l-104 0 0 104c0 13.3-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l104 0 0-104c0-13.3 10.7-24 24-24l104 0 0-104c0-13.3 10.7-24 24-24l104 0 0-120z"/></svg>',
        'file-certificate' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M192 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16l-192 0 0 48 192 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L370.7 18.7C358.7 6.7 342.5 0 325.5 0L192 0c-35.3 0-64 28.7-64 64l0 80c16.6 0 32.7 2.3 48 6.6L176 64c0-8.8 7.2-16 16-16zM352 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM256 320c0-70.7-57.3-128-128-128S0 249.3 0 320c0 40.4 18.7 76.5 48 99.9L48 525c0 10.5 8.5 19 19 19 3.3 0 6.5-.9 9.4-2.5L128 512 179.6 541.5c2.9 1.6 6.1 2.5 9.4 2.5 10.5 0 19-8.5 19-19l0-105.1c29.3-23.5 48-59.5 48-99.9zM128 272a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"/></svg>',
        'chart-pie' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M352.4 54l0 138 138 0C473 124.6 419.9 71.4 352.4 54zm-144 210l0-173.1c-74.6 26.4-128 97.5-128 181.1 0 106 86 192 192 192 24.6 0 48-4.6 69.5-12.9L225 309.9c-10.7-12.9-16.6-29.2-16.6-45.9zm333.9-55.9c2.3 17.5-12.2 31.9-29.9 31.9l-176 0c-17.7 0-32-14.3-32-32l0-176c0-17.7 14.4-32.2 31.9-29.9 107 14.2 191.8 99 206 206zM256.4 66.7l0 197.3c0 5.6 2 11 5.5 15.3L394 438.7c11.7 14.1 9.2 35.4-6.9 44.1-34.1 18.6-73.2 29.2-114.7 29.2-132.5 0-240-107.5-240-240 0-115.5 81.5-211.9 190.2-234.8 18.1-3.8 33.8 11 33.8 29.5zM541.7 288c18.5 0 33.3 15.7 29.5 33.8-10.2 48.4-35 91.4-69.6 124.2-12.3 11.7-31.6 9.2-42.4-3.9L374.9 340.4c-17.3-20.9-2.4-52.4 24.6-52.4l142.2 0z"/></svg>',
        'road' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48.8 403.7c-.6 2-.8 4-.8 6.1 0 12.3 10 22.3 22.3 22.3l161.7 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 161.7 0c12.3 0 22.3-10 22.3-22.3 0-2-.3-4.1-.8-6.1L375 91.6C373 84.8 366.7 80 359.6 80l-79.6 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-79.6 0c-7.2 0-13.4 4.8-15.4 11.6l-88.2 312zM2.6 390.6l88.2-312C98.6 51 123.8 32 152.4 32l207.2 0c28.6 0 53.8 19 61.6 46.6l88.2 312c1.8 6.2 2.6 12.6 2.6 19.1 0 38.8-31.5 70.3-70.3 70.3L70.3 480c-38.8 0-70.3-31.5-70.3-70.3 0-6.5 .9-12.9 2.6-19.1zM280 216l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24z"/></svg>',
        'star' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M288.1-32c9 0 17.3 5.1 21.4 13.1L383 125.3 542.9 150.7c8.9 1.4 16.3 7.7 19.1 16.3s.5 18-5.8 24.4L441.7 305.9 467 465.8c1.4 8.9-2.3 17.9-9.6 23.2s-17 6.1-25 2L288.1 417.6 143.8 491c-8 4.1-17.7 3.3-25-2s-11-14.2-9.6-23.2L134.4 305.9 20 191.4c-6.4-6.4-8.6-15.8-5.8-24.4s10.1-14.9 19.1-16.3l159.9-25.4 73.6-144.2c4.1-8 12.4-13.1 21.4-13.1zm0 76.8L230.3 158c-3.5 6.8-10 11.6-17.6 12.8l-125.5 20 89.8 89.9c5.4 5.4 7.9 13.1 6.7 20.7l-19.8 125.5 113.3-57.6c6.8-3.5 14.9-3.5 21.8 0l113.3 57.6-19.8-125.5c-1.2-7.6 1.3-15.3 6.7-20.7l89.8-89.9-125.5-20c-7.6-1.2-14.1-6-17.6-12.8L288.1 44.8z"/></svg>',
        'cube' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M248.3 39.1c5-2.9 11-2.9 16 0l159.8 92.3-167.8 96.9-167.8-96.9 159.8-92.3zM64.5 173l167.8 96.9 0 193.8-159.8-92.3c-5-2.9-8-8.1-8-13.9l0-184.6zM280.3 463.7l0-193.8 167.8-96.9 0 184.6c0 5.7-3 11-8 13.9L280.3 463.7zm8-466.1c-19.8-11.4-44.2-11.4-64 0L48.5 99c-19.8 11.4-32 32.6-32 55.4l0 203c0 22.9 12.2 44 32 55.4L224.3 514.5c19.8 11.4 44.2 11.4 64 0L464.2 413c19.8-11.4 32-32.6 32-55.4l0-203c0-22.9-12.2-44-32-55.4L288.3-2.5z"/></svg>',
        'house-window' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M240 6.1c9.1-8.2 22.9-8.2 32 0l232 208c9.9 8.8 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-8-7.2 0 205.3c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-205.3-8 7.2c-9.9 8.8-25 8-33.9-1.8s-8-25 1.8-33.9L240 6.1zm16 50.1L96 199.7 96 448c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-248.3-160-143.4zM224 320l64 0 0-64-64 0 0 64zm-48-72c0-22.1 17.9-40 40-40l80 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-80 0c-22.1 0-40-17.9-40-40l0-80z"/></svg>',
        'window-frame' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 64l0 400 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-400C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64zM80 232l120 0 0-184-104 0c-8.8 0-16 7.2-16 16l0 168zm120 48l-120 0 0 184 120 0 0-184zm48 0l0 184 120 0 0-184-120 0zm0-48l120 0 0-168c0-8.8-7.2-16-16-16l-104 0 0 184z"/></svg>',
        'compass' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm306.7 69.1L162.4 380.6c-19.4 7.5-38.5-11.6-31-31l55.5-144.3c3.3-8.5 9.9-15.1 18.4-18.4l144.3-55.5c19.4-7.5 38.5 11.6 31 31L325.1 306.7c-3.3 8.5-9.9 15.1-18.4 18.4zM288 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>',
        'hammer-brush' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M120-16C53.7-16 0 37.7 0 104l0 16c0 6.4 2.5 12.5 7 17s10.6 7 17 7l65.4 0 19.1 11.5c1.2 .7 2.4 1.4 3.5 2L112 448c0 35.3 28.7 64 64 64s64-28.7 64-64l0-290.5c1.2-.6 2.4-1.3 3.5-2l19.1-11.5 42.7 0c3.3 9.3 12.2 16 22.6 16 13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24-10.5 0-19.3 6.7-22.6 16l-39.4 0-6.2-6.2C243.2-6.7 220.8-16 197.5-16L120-16zm40 464l0-280 32 0 0 280c0 8.8-7.2 16-16 16s-16-7.2-16-16zM304 64l0 32-48 0c-4.3 0-8.6 1.2-12.3 3.4l-24.8 14.9c-6.2 3.7-13.3 5.7-20.6 5.7l-44.5 0c-7.2 0-14.4-2-20.6-5.7L108.3 99.4c-3.7-2.2-8-3.4-12.3-3.4L48.4 96c4-36 34.5-64 71.6-64l77.5 0c10.6 0 20.8 4.2 28.3 11.7L239 57c4.5 4.5 10.6 7 17 7l48 0zm144 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144c0 6.8 2.9 13.3 7.9 17.8l58.8 52.9c3 2.7 5.6 5.8 7.6 9.2l-180.7 0c2-3.4 4.6-6.5 7.6-9.2l58.8-52.9c5.1-4.6 7.9-11 7.9-17.8l0-144zM368 336l192 0 0 120c0 4.4-3.6 8-8 8l-88 0 0-56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 56-40 0c-4.4 0-8-3.6-8-8l0-120zM464 0c-35.3 0-64 28.7-64 64l0 133.3-50.9 45.8c-18.5 16.7-29.1 40.5-29.1 65.4L320 456c0 30.9 25.1 56 56 56l176 0c30.9 0 56-25.1 56-56l0-147.5c0-24.9-10.6-48.7-29.1-65.4L528 197.3 528 64c0-35.3-28.7-64-64-64z"/></svg>',
        'file-signature' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M128.1 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 108 48-48 0-81.5c0-17-6.7-33.3-18.7-45.3L306.8 18.7C294.8 6.7 278.5 0 261.6 0L128.1 0c-35.3 0-64 28.7-64 64l0 384c0 35.3 28.7 64 64 64l146.2 0 9.6-48-155.8 0c-8.8 0-16-7.2-16-16l0-384c0-8.8 7.2-16 16-16zM289.9 368l-16.1-53.6c-4.7-15.7-19.1-26.4-35.5-26.4-11.3 0-21.9 5.1-28.9 13.9L149.3 377c-8.3 10.3-6.6 25.5 3.7 33.7s25.5 6.6 33.7-3.8l47.1-58.8 15.2 50.7c3 10.2 12.4 17.1 23 17.1l30.6 0c3.9-5.6 8.2-10.9 13.1-15.8l32.2-32.2-58.1 0zM288.1 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zm44.2 399l-11.9 59.6c-.2 .9-.3 1.9-.3 2.9 0 8 6.5 14.6 14.6 14.6 1 0 1.9-.1 2.9-.3l59.6-11.9c12.4-2.5 23.8-8.6 32.7-17.5l118.9-118.9-80-80-118.9 118.9c-8.9 8.9-15 20.3-17.5 32.7zm267.8-123c22.1-22.1 22.1-57.9 0-80s-57.9-22.1-80 0l-28.8 28.8 80 80 28.8-28.8z"/></svg>',
        'key' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M208 176c0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128c-10.4 0-20.5-1.2-30.1-3.6-8.1-2-16.7 .5-22.6 6.4L254.1 336 200 336c-13.3 0-24 10.7-24 24l0 40-40 0c-13.3 0-24 10.7-24 24l0 40-64 0 0-78.1 157.2-157.2c5.9-5.9 8.3-14.5 6.4-22.6-2.3-9.6-3.6-19.7-3.6-30.1zM336 0c-97.2 0-176 78.8-176 176 0 9.5 .7 18.8 2.2 27.9L7 359c-4.5 4.5-7 10.6-7 17L0 488c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7l27.2-27.2c9.1 1.4 18.4 2.2 27.9 2.2 97.2 0 176-78.8 176-176S433.2 0 336 0zm32 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
        'coins' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M320 0c48.9 0 93.9 8.4 127.6 21.7 16.7 6.6 31.8 14.9 43.1 24.8 11 9.7 21.3 23.7 21.3 41.5l0 208c0 17.8-10.4 31.8-21.3 41.5-11.3 10-26.3 18.2-43.1 24.8-5 2-10.2 3.8-15.6 5.5l0-51c12.6-5.2 21.5-10.6 26.9-15.4 3.9-3.4 4.9-5.4 5.1-6l0-40.2c-9.8 4.1-20.6 7.7-32 10.8l0-50.1c7.8-2.6 14.7-5.3 20.5-8.2 4.9-2.4 8.6-4.7 11.5-6.7l0-52.7c-5.3 2.6-10.9 5-16.7 7.2-9.1 3.5-19.1 6.6-29.7 9.2-6.7-11.2-14.9-20.3-22.7-27.3-5.3-4.8-10.9-9.1-16.8-13 50.5-6.2 85.8-20.3 85.8-36.6 0-20-64.5-40-144-40-69.1 0-126.8 15.1-140.8 32.2-17.4 .4-34.5 1.7-51.1 3.9 1.4-15.9 11-28.6 21.2-37.5 11.3-10 26.3-18.2 43.1-24.8 33.7-13.3 78.7-21.7 127.6-21.7zM64.4 149.7C98.1 136.4 143.1 128 192 128s93.9 8.4 127.6 21.7c16.7 6.6 31.8 14.9 43.1 24.8 11 9.7 21.3 23.7 21.3 41.5l0 208c0 17.8-10.4 31.8-21.3 41.5-11.3 10-26.3 18.2-43.1 24.8-33.7 13.3-78.7 21.7-127.6 21.7s-93.9-8.4-127.6-21.7c-16.7-6.6-31.8-14.9-43.1-24.8-11-9.7-21.3-23.7-21.3-41.5L0 216c0-17.8 10.4-31.8 21.3-41.5 11.3-10 26.3-18.2 43.1-24.8zm254.9 134C285.6 296.5 240.5 304 192 304s-93.6-7.5-127.3-20.3c-5.8-2.2-11.4-4.6-16.7-7.2l0 52.7c2.8 2.1 6.6 4.3 11.5 6.7 9.1 4.5 20.8 8.7 34.7 12.4 27.7 7.3 62.2 11.8 97.8 11.8s70.1-4.5 97.8-11.8c13.9-3.7 25.6-7.9 34.7-12.4 4.9-2.4 8.6-4.7 11.5-6.7l0-52.7c-5.3 2.6-10.9 5-16.7 7.2zM48 383.3l0 40.2c.2 .6 1.2 2.6 5.1 6 5.7 5 15.3 10.8 28.9 16.2 27.1 10.7 66.1 18.3 110 18.3s82.8-7.6 110-18.3c13.7-5.4 23.2-11.1 28.9-16.2 3.9-3.4 4.9-5.4 5.1-6l0-40.2c-10.4 4.4-21.8 8.1-33.9 11.3-32.1 8.5-70.8 13.3-110.1 13.3s-77.9-4.9-110-13.3c-12.1-3.2-23.6-7-34-11.3zM336 216c0-20-64.5-40-144-40S48 196 48 216c0 22.1 64.5 40 144 40s144-17.9 144-40z"/></svg>',
        'object-exclude' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64 48l224 0c8.8 0 16 7.2 16 16l0 48 48 0 0-48c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 288c0 35.3 28.7 64 64 64l48 0 0-48-48 0c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 160c-35.3 0-64 28.7-64 64l48 0c0-8.8 7.2-16 16-16l32 0 0-48-32 0zM160 272l0 80 48 0 0-80-48 0zm96 80l32 0c35.3 0 64-28.7 64-64l-48 0c0 8.8-7.2 16-16 16l-32 0 0 48zm96-192l-48 0 0 80 48 0 0-80zM160 400l0 48c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-48 0 0 48 48 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16l0-48-48 0z"/></svg>',
        'square-dashed' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M88 32c13.3 0 24 10.7 24 24S101.3 80 88 80c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24S0 133.3 0 120C0 71.4 39.4 32 88 32zM24 192c13.3 0 24 10.7 24 24l0 80c0 13.3-10.7 24-24 24S0 309.3 0 296l0-80c0-13.3 10.7-24 24-24zm400 0c13.3 0 24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24zm0-48c-13.3 0-24-10.7-24-24 0-22.1-17.9-40-40-40-13.3 0-24-10.7-24-24s10.7-24 24-24c48.6 0 88 39.4 88 88 0 13.3-10.7 24-24 24zm24 248c0 48.6-39.4 88-88 88-13.3 0-24-10.7-24-24s10.7-24 24-24c22.1 0 40-17.9 40-40 0-13.3 10.7-24 24-24s24 10.7 24 24zM48 392c0 22.1 17.9 40 40 40 13.3 0 24 10.7 24 24s-10.7 24-24 24c-48.6 0-88-39.4-88-88 0-13.3 10.7-24 24-24s24 10.7 24 24zm136 88c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0zM160 56c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24z"/></svg>',
        'chart-pyramid' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M191.7 176L256 56.8 320.4 176 191.7 176zm-25.9 48l180.5 0 43.2 80-266.9 0 43.2-80zM415.4 352l43.2 80-405.2 0 43.2-80 318.8 0zM291.2 21C284.2 8.1 270.7 0 256 0s-28.2 8.1-35.2 21L4.8 421c-6.7 12.4-6.4 27.4 .8 39.5S25.9 480 40 480l432 0c14.1 0 27.1-7.4 34.4-19.5s7.5-27.1 .8-39.5L291.2 21z"/></svg>',
        'vector-square' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M40 64a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm48 59.3c16-6.5 28.9-19.3 35.3-35.3l265.3 0c6.5 16 19.3 28.9 35.3 35.3l0 265.3c-16 6.5-28.9 19.3-35.3 35.3l-265.3 0c-6.5-16-19.3-28.9-35.3-35.3l0-265.3zM123.3 40C113.9 16.5 90.9 0 64 0 28.7 0 0 28.7 0 64 0 90.9 16.5 113.9 40 123.3l0 265.3c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 26.9 0 49.9-16.5 59.3-40l265.3 0c9.5 23.5 32.5 40 59.3 40 35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-265.3c23.5-9.5 40-32.5 40-59.3 0-35.3-28.7-64-64-64-26.9 0-49.9 16.5-59.3 40L123.3 40zM64 424a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm384 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-384a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"/></svg>',
        'diagram-cells' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 96c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-64zm48 64c0 35.3-28.7 64-64 64L64 224c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 64zM400 352c0-8.8-7.2-16-16-16L64 336c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-64zm48 64c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 64z"/></svg>',
        'border-top' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 56C0 42.7 10.7 32 24 32l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 80C10.7 80 0 69.3 0 56zM64 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM0 448c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zm448 0c0 17.7-14.3 32-32 32s-32-14.3-32-32 14.3-32 32-32 32 14.3 32 32zm-320 0c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zm192 0c0 17.7-14.3 32-32 32s-32-14.3-32-32 14.3-32 32-32 32 14.3 32 32z"/></svg>',
        'border-none' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zM288 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm0-384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"/></svg>',
        'car-garage' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M574.9 144c-4-21.5-18.8-39.8-39.7-47.9L305.4 6.8c-11.2-4.4-23.6-4.4-34.8 0L40.8 96.1C19.9 104.2 5.1 122.5 1.1 144 .4 147.8 0 151.8 0 155.8L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-296 480 0 0 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-332.2c0-4-.4-7.9-1.1-11.8zM53.2 144c1.4-1.3 3.1-2.4 5-3.1L288 51.5 517.8 140.9c1.9 .7 3.6 1.8 5 3.1L53.2 144zM218 291.8c1.5-2.3 4-3.8 6.8-3.8l126.3 0c2.8 0 5.3 1.4 6.8 3.8l27.7 44.2-195.3 0 27.7-44.2zM176 416l0-32 224 0 0 32-224 0zm0 48l224 0 0 22c0 13.3 10.7 24 24 24s24-10.7 24-24l0-115.6c0-16.5-4.6-32.7-13.4-46.7l-35.9-57.4c-10.2-16.3-28.2-26.3-47.5-26.3l-126.3 0c-19.3 0-37.2 9.9-47.5 26.3l-35.9 57.4c-8.8 14-13.4 30.2-13.4 46.7L128 486c0 13.3 10.7 24 24 24s24-10.7 24-24l0-22z"/></svg>',
        'fence' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M48 432l48 0 0-301.6-24-26.7-24 26.7 0 301.6zM8.2 102.9L60.1 45.2c6.4-7.1 17.4-7.1 23.8 0l51.9 57.7c5.3 5.9 8.2 13.5 8.2 21.4l0 37.1 40 0 0-37.1c0-7.9 2.9-15.5 8.2-21.4l51.9-57.7c6.4-7.1 17.4-7.1 23.8 0l51.9 57.7c5.3 5.9 8.2 13.5 8.2 21.4l0 37.1 40 0 0-37.1c0-7.9 2.9-15.5 8.2-21.4l51.9-57.7c6.4-7.1 17.4-7.1 23.8 0l51.9 57.7c5.3 5.9 8.2 13.5 8.2 21.4L512 448c0 17.7-14.3 32-32 32l-80 0c-17.7 0-32-14.3-32-32l0-48-40 0 0 48c0 17.7-14.3 32-32 32l-80 0c-17.7 0-32-14.3-32-32l0-48-40 0 0 48c0 17.7-14.3 32-32 32l-80 0c-17.7 0-32-14.3-32-32L0 124.3c0-7.9 2.9-15.5 8.2-21.4zM368 352l0-142.6-40 0 0 142.6 40 0zM144 209.4l0 142.6 40 0 0-142.6-40 0zm88-79l0 301.6 48 0 0-301.6-24-26.7-24 26.7zM416 432l48 0 0-301.6-24-26.7-24 26.7 0 301.6z"/></svg>',
        'tree' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.5-32c7 0 13.7 3.1 18.3 8.5l136 160c6.1 7.1 7.4 17.1 3.5 25.6-3.9 8.5-12.4 13.9-21.8 13.9l-24.9 0 75.2 88.5c6.1 7.1 7.4 17.1 3.5 25.6S401.8 304 392.5 304l-38.5 0 88.8 104.5c6.1 7.1 7.4 17.1 3.5 25.6S433.8 448 424.5 448l-176 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-176 0c-9.4 0-17.9-5.4-21.8-13.9S.2 415.6 6.2 408.5L95 304 56.5 304c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l75.2-88.5-24.9 0c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l136-160 1.8-1.9c4.4-4.2 10.3-6.6 16.5-6.6zM140.4 128l24.9 0c9.3 0 17.9 5.5 21.8 13.9s2.5 18.5-3.5 25.6l-75.2 88.5 38.5 0c9.3 0 17.9 5.4 21.8 13.9s2.5 18.5-3.5 25.6L76.4 400 372.6 400 283.8 295.5c-6.1-7.1-7.4-17.1-3.5-25.6S292.7 256 302.1 256l38.5 0-75.2-88.5c-6-7.1-7.4-17.1-3.5-25.6S274.3 128 283.7 128l24.9 0-84.1-99-84.1 99z"/></svg>',
        'boxes-stacked' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M336 48c8.8 0 16 7.2 16 16l0 112 48 0 0-112c0-35.3-28.7-64-64-64L176 0c-35.3 0-64 28.7-64 64l0 112 48 0 0-112c0-8.8 7.2-16 16-16l32 0 0 56c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-56 32 0zM315.9 512L448 512c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64l-132.1 0c12.7 18.1 20.1 40.2 20.1 64l0 62.6c2.5 .9 5.2 1.4 8 1.4l48 0c13.3 0 24-10.7 24-24l0-56 32 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-113.1 0c-2.5 17.7-9.2 34-18.9 48zM240 288l0 160c0 0 0 0 0 .1 0 8.8-7.2 15.9-16 15.9L64 464c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l32 0 0 56c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-56 32 0c8.8 0 15.9 7.1 16 15.9l0 .1zM64 224c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64L64 224z"/></svg>',
        'users-viewfinder' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M64 0C28.7 0 0 28.7 0 64l0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-8.8 7.2-16 16-16l72 0c13.3 0 24-10.7 24-24S149.3 0 136 0L64 0zM440 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c8.8 0 16 7.2 16 16l0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-35.3-28.7-64-64-64L440 0zM48 376c0-13.3-10.7-24-24-24S0 362.7 0 376l0 72c0 35.3 28.7 64 64 64l72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0c-8.8 0-16-7.2-16-16l0-72zm528 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72c0 8.8-7.2 16-16 16l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c35.3 0 64-28.7 64-64l0-72zM288 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM160 160c0-16.4 3.1-32 8.7-46.4-32.4 7-56.7 35.9-56.7 70.4 0 39.8 32.2 72 72 72 5.9 0 11.6-.7 17.1-2-25.3-23.4-41.1-56.8-41.1-94zm232 96c39.8 0 72-32.2 72-72 0-34.5-24.3-63.3-56.7-70.4 5.6 14.4 8.7 30 8.7 46.4 0 37.1-15.8 70.6-41.1 94 5.5 1.3 11.2 2 17.1 2zM170.5 288.2C120.1 291 80 332.8 80 384l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-4.6 .6-9 1.8-13.1 4.9-31.8 19.5-60.4 40.7-82.7zm275.7 82.7c1.2 4.2 1.8 8.6 1.8 13.1l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-51.2-40.1-93-90.5-95.8 21.2 22.3 35.8 50.9 40.7 82.7zM272 288c-53 0-96 43-96 96l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-53-43-96-96-96l-32 0z"/></svg>',
        'info-circle' =>
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 336c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-88c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 64-24 0zm40-144a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"/></svg>',
    ];

    use Singleton;

    public static function get_svg_icon(
        string $name,
        string $shape = 'sharp',
        string $style = 'solid',
        ?int $width = null,
        ?int $height = null,
        ?string $color = null,
    ): string {
        $property = strtolower($style . '_' . $shape);

        if (defined('self::' . $property)) {
            $icons = constant('self::' . $property);

            if (isset($icons[$name])) {
                $svg = $icons[$name];
                $svgElement = simplexml_load_string($svg);

                if ($svgElement !== false) {
                    $svgElement->registerXPathNamespace('svg', 'http://www.w3.org/2000/svg');

                    if ($width !== null) {
                        $svgElement['width'] = $width;
                    }
                    if ($height !== null) {
                        $svgElement['height'] = $height;
                    }

                    if ($color !== null) {
                        $fillableElements = ['path', 'circle'];

                        $namespaces = $svgElement->getNamespaces(true);
                        $svgElement->registerXPathNamespace('svg', $namespaces['']);

                        foreach ($fillableElements as $element) {
                            $elementsWithFill = $svgElement->xpath("//svg:{$element}");

                            foreach ($elementsWithFill as $el) {
                                $el['fill'] = $color;
                            }
                        }
                    }

                    return $svgElement->asXML();
                }
            }
        }

        return '';
    }

    public static function get_kses_ruleset(): array {
        $kses_defaults = wp_kses_allowed_html('post');

        $svg_attrs = [
            'svg' => [
                'class' => true,
                'aria-hidden' => true,
                'aria-labelledby' => true,
                'role' => true,
                'xmlns' => true,
                'width' => true,
                'height' => true,
                'viewbox' => true,
            ],
            'g' => [
                'fill' => true,
            ],
            'title' => [
                'title' => true,
            ],
            'path' => [
                'd' => true,
                'fill' => true,
            ],
            'circle' => [
                'cx' => true,
                'cy' => true,
                'r' => true,
                'fill' => true,
            ],
        ];
        
        return array_merge($kses_defaults, $svg_attrs);
    }
}
