<?php

namespace EstatebudConnect\Configs;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class Sharing
{
    use Singleton;

    const PROVIDERS = [
        'email' => [
            'label' => 'Email',
            'url_template' => 'mailto:?subject={{ subject }}&body={{ text }}',
            'color' => '#6B6B6B',
            'icon' => [
                'brand' => false,
                'name' => 'envelope',
            ],
        ],
        'facebook' => [
            'label' => 'Facebook',
            'url_template' => 'https://www.facebook.com/sharer.php?u={{ url }}',
            'color' => '#0866FF',
            'icon' => [
                'brand' => true,
                'name' => 'facebook',
            ],
        ],
        'x' => [
            'label' => 'X',
            'url_template' => 'https://twitter.com/intent/tweet?url={{ url }}&text={{ text }}',
            'color' => '#000000',
            'icon' => [
                'brand' => true,
                'name' => 'x',
            ],
        ],
        'telegram' => [
            'label' => 'Telegram',
            'url_template' => 'https://t.me/share/url?url={{ url }}&text={{ text }}',
            'color' => '#179CDE',
            'icon' => [
                'brand' => true,
                'name' => 'telegram',
            ],
        ],
        'vk' => [
            'label' => 'VKontakte',
            'url_template' => 'https://vk.com/share.php?url={{ url }}',
            'color' => '#0077FF',
            'icon' => [
                'brand' => true,
                'name' => 'vk',
            ],
        ],
        'pinterest' => [
            'label' => 'Pinterest',
            'url_template' => 'https://pinterest.com/pin/create/link/?url={{ url }}',
            'color' => '#E60023',
            'icon' => [
                'brand' => true,
                'name' => 'pinterest',
            ],
        ],
        'whatsapp' => [
            'label' => 'WhatsApp',
            'url_template' => 'https://wa.me/?text={{ text }}',
            'color' => '#25D366',
            'icon' => [
                'brand' => true,
                'name' => 'whatsapp',
            ],
        ],
        'viber' => [
            'label' => 'Viber',
            'url_template' => 'viber://forward?text={{ url }}',
            'color' => '#553EBC',
            'icon' => [
                'brand' => true,
                'name' => 'viber',
            ],
        ],
        'messenger' => [
            'label' => 'Messenger',
            'url_template' => 'https://facebook.com/dialog/send?link={{ url }}&redirect_uri={{ url }}',
            'color' => '#168AFF',
            'icon' => [
                'brand' => true,
                'name' => 'messenger',
            ],
        ],
    ];
}