<?php

namespace EstatebudConnect\Core;

if (!defined('WPINC')) {
    die();
}

use ScssPhp\ScssPhp\Compiler as ScssCompiler;
use ScssPhp\ScssPhp\OutputStyle;

class Compiler
{
    public static function compile()
    {
        $scss_files = [
            'app/Styles/Public/index.scss' => 'dist/bundle-main.css',
            'app/Styles/Public/maps/index.scss' => 'dist/bundle-maps.css',
            'app/Styles/Admin/index.scss' => 'dist/bundle-admin.css',
        ];

        foreach ($scss_files as $input => $output) {
            $scss_file = wp_normalize_path(realpath(plugin_dir_path(__DIR__) . '../') . '/' . $input);
            $css_file = wp_normalize_path(realpath(plugin_dir_path(__DIR__) . '../') . '/' . $output);
            
            if (!file_exists($scss_file)) {
                wp_die(esc_html('Failed to compile ' . $scss_file . ': File does not exist'));
            }

            try {
                $scss = new ScssCompiler();
                $scss->setOutputStyle(OutputStyle::COMPRESSED);
                $scss->setImportPaths(dirname($scss_file));
                $compiled = $scss->compileFile($scss_file);
                file_put_contents($css_file, $compiled->getCss());
            } catch (\Exception $e) {
                wp_die(esc_html('Failed to compile ' . $scss_file . ': ' . $e->getMessage()));
            }
        }
    }
}
