<?php

namespace EstatebudConnect\Core;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Core\Log;
use EstatebudConnect\Traits\Singleton;
use EstatebudConnect\Utilities\Helper;

class Locale
{
    protected $_terms = [];
    protected $_dynamic_terms = null;

    use Singleton;

    public function get_localization_plugin()
    {
        if (function_exists('pll_languages_list') || function_exists('pll_current_language')) {
            return 'Polylang';
        }

        if (function_exists('icl_get_languages') || function_exists('icl_object_id')) {
            return 'WPML';
        }

        if (function_exists('trp_get_languages') || function_exists('trp_get_current_language')) {
            return 'TranslatePress';
        }

        if (function_exists('weglot_get_languages_available') || function_exists('weglot_get_current_language')) {
            return 'Weglot';
        }

        return 'WordPress';
    }

    public function get_enabled_languages()
    {
        $plugin = $this->get_localization_plugin();

        if ($plugin !== 'WordPress') {
            $service_class = "\\EstatebudConnect\\Services\\{$plugin}";
            if (class_exists($service_class)) {
                $service = $service_class::instance();
                $languages = $service->get_enabled_languages();
                if (!empty($languages)) {
                    return $languages;
                }
            }
        }

        return $this->get_wordpress_default_language();
    }

    public function get_wordpress_default_language()
    {
        $locale = Helper::get_locale();

        return [
            [
                'code' => $locale,
                'name' => Helper::get_locale_display_name($locale, $locale . ' (intl extension not installed)'),
                'flag' => '',
                'url' => '',
                'active' => true,
            ],
        ];
    }

    public function load($language)
    {
        $locale_dir = realpath(plugin_dir_path(__DIR__) . 'Locales/');
        $file = $language . '.json';

        if (file_exists($locale_dir . '/' . $file)) {
            $json = file_get_contents($locale_dir . '/' . $file);
            $terms = json_decode($json, true);

            $this->_terms[$language] = $terms;
        }

        return isset($terms);
    }

    public function get_terms($language)
    {
        if (!isset($this->_terms[$language])) {
            self::load($language);
        }

        return $this->_terms[$language] ?? [];
    }

    public function get_term($key, $count = null, $language = null)
    {
        $terms = self::get_terms($language);
        $i = array_search($key, array_column($terms, 'key'));

        $variant = $count == 1 ? 'one' : 'other';

        if ($i !== false && isset($terms[$i]['value'][$variant])) {
            $term = $terms[$i]['value'][$variant];
        } else if($i !== false && isset($terms[$i]['value'])) {
            $term = $terms[$i]['value'];
        }

        if (!isset($term)) {
            $dynamic_terms = self::get_dynamic_terms();
            $i = array_search($key, array_column($dynamic_terms, 'key'));

            if ($i !== false) {
                $term = $dynamic_terms[$i]['value'];
            }
        }

        return $term ?? null;
    }

    public function get_dynamic_terms()
    {
        if (is_null($this->_dynamic_terms)) {
            $this->_dynamic_terms = Helper::get_translatable_form_terms();
        }

        return $this->_dynamic_terms;
    }
}
