<?php

namespace EstatebudConnect\Interfaces;

if (!defined('WPINC')) {
    die();
}

interface Listing
{
    public function get_id();
    public function get_image();
    public function get_images();
    public function get_floorplans();
    public function get_videos();
    public function get_virtual_tours();
    public function get_lat_lng();
    public function get_price();
    public function get_original_price();
    public function get_labels();
    public function get_reference_id();
    public function get_bedrooms();
    public function get_bathrooms();
    public function get_covered_area();
    public function get_plot_area();
    public function get_attributes();
    public function get_facilities();
    public function get_features();
    public function get_distances();
    public function get_areas();
    public function get_planning_zones();
    public function get_units();
    public function get_page_title();
    public function get_meta_description();
    public function get_og_image();
    public function get_og_title();
    public function get_og_url($language);
    public function get_og_description();
    public function get_aioseo_facebook_tags();
    public function get_aioseo_twitter_tags();
    public function get_alternate_urls($languages);
    public function get_url($language);
    public function is_matching_enabled();
    public function is_published();
    public function is_rental();
    public function is_rented();
    public function is_sold();
    public function get_settings();
    public function save_settings($data);
}
