<?php

namespace EstatebudConnect\Models;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Services\Estatebud;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Core\OptionsAPI;
use EstatebudConnect\Traits\Singleton;

class Dashboard
{
    use Singleton;

    public function __construct() {}

    public function plugin_active_status()
    {
        $result = OptionsAPI::instance()->get('whois', null);
        if (isset($result) && isset($result['subscription']) && isset($result['subscription']['active'])) {
            return $result['subscription']['active'];
        }
        return false;
    }

    public function get_dashboard_status()
    {
        $api_key = Settings::instance()->get_api_key();
        if ($api_key === null) {
            return [];
        }

        $result = OptionsAPI::instance()->get('whois', null);
        if (isset($result) && is_array($result)) {
            return $result;
        }

        $result = Estatebud::instance()->whois();
        if ($result === false) {
            return [];
        }
        OptionsAPI::instance()->add('whois', $result);
        return $result;
    }
}
