<?php

namespace EstatebudConnect\Models;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Core\OptionsAPI;
use EstatebudConnect\Traits\Singleton;

class Localizations
{
    private const OPTIONS_KEY = 'localizations';

    use Singleton;

    public function __construct() {}

    public function save_localizations($language, $localizations = [])
    {
        if (empty($language)) {
            return false;
        }

        $parsed_localizations = $this->parse_input_data($localizations);

        $all_localizations = $this->get_all_localizations();
        $all_localizations[$language] = $parsed_localizations;

        return OptionsAPI::instance()->update(self::OPTIONS_KEY, $all_localizations, true);
    }

    public function get_all_localizations()
    {
        $data = OptionsAPI::instance()->get(self::OPTIONS_KEY, []);
        return $data ?? [];
    }

    public function get_localizations($language)
    {
        $all_localizations = $this->get_all_localizations();
        return $all_localizations[$language] ?? [];
    }

    public function get_localization($key, $count, $language)
    {
        $localizations = $this->get_localizations($language);
        $i = array_search($key, array_column($localizations, 'key'));

        $variant = $count == 1 ? 'singular' : 'plural';

        if ($i !== false && isset($localizations[$i]['text'][$variant])) {
            $localization = $localizations[$i]['text'][$variant];
        } else if($i !== false && isset($localizations[$i]['text'])) {
            $localization = $localizations[$i]['text'];
        }

        return $localization ?? null;
    }

    public function delete_localizations($language)
    {
        $all_localizations = $this->get_all_localizations();
        unset($all_localizations[$language]);

        return OptionsAPI::instance()->update(self::OPTIONS_KEY, $all_localizations, true);
    }

    public function get_available_languages()
    {
        $all_localizations = $this->get_all_localizations();
        return array_keys($all_localizations);
    }

    protected function parse_input_data($entries = [])
    {
        $localizations = [];

        foreach ($entries as $entry) {
            $key = $entry['key'] ?? null;
            $text = $entry['text'] ?? null;

            if (empty($key)) {
                continue;
            }

            if (is_array($text)) {
                $singular = $text['singular'] ?? '';
                $plural = $text['plural'] ?? '';

                if (!empty($singular) || !empty($plural)) {
                    $localizations[] = [
                        'key' => sanitize_text_field(wp_unslash($key)),
                        'text' => [
                            'singular' => sanitize_textarea_field(wp_unslash($singular)),
                            'plural' => sanitize_textarea_field(wp_unslash($plural)),
                        ],
                    ];
                }
            } elseif (!empty($text)) {
                $localizations[] = [
                    'key' => sanitize_text_field(wp_unslash($key)),
                    'text' => sanitize_textarea_field(wp_unslash($text)),
                ];
            }
        }

        return $localizations;
    }
}
