<?php

namespace EstatebudConnect\Services;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class Polylang
{
    use Singleton;

    public function __construct() {}

    public function get_enabled_languages()
    {
        if (!function_exists('pll_languages_list')) {
            return [];
        }

        $language_codes = pll_languages_list(['fields' => 'slug']);

        if (empty($language_codes) || !is_array($language_codes)) {
            return [];
        }

        $language_names = pll_languages_list(['fields' => 'name']);
        $language_flags = pll_languages_list(['fields' => 'flag_url']);
        $language_urls = pll_languages_list(['fields' => 'url']);

        $enabled_languages = [];
        foreach ($language_codes as $index => $code) {
            $enabled_languages[] = [
                'code' => $code,
                'name' => $language_names[$index] ?? '',
                'flag' => $language_flags[$index] ?? '',
                'url' => $language_urls[$index] ?? '',
                'active' => pll_current_language() === $code,
            ];
        }

        return $enabled_languages;
    }
}
