<?php

namespace EstatebudConnect\Services;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class TranslatePress
{
    use Singleton;

    public function __construct() {}

    public function get_enabled_languages()
    {
        if (!function_exists('trp_get_languages')) {
            return [];
        }

        $languages = trp_get_languages();

        if (empty($languages) || !is_array($languages)) {
            return [];
        }

        $enabled_languages = [];
        foreach ($languages as $language) {
            $enabled_languages[] = [
                'code' => $language['language_code'] ?? '',
                'name' => $language['language_name'] ?? '',
                'flag' => $language['flag_url'] ?? '',
                'url' => $language['url'] ?? '',
                'active' => $language['current_language'] ?? false,
            ];
        }

        return $enabled_languages;
    }
}
