<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Models\SearchExperience;
use EstatebudConnect\Configs\Icons;

$icon_edit = Icons::get_svg_icon('pen', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');
$icon_delete = Icons::get_svg_icon('trash', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');
$icon_gear = Icons::get_svg_icon('gear-code', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');
$icon_clone = Icons::get_svg_icon('copy', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');

$all_exp_data = SearchExperience::instance()->get_all_search_exps();
?>
<div class="estatebud-sidebar-content-body" style="gap:40px;">
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title-wrapper">
				<div class="estatebud-content-panel-title">
					General
				</div>
				<div class="estatebud-content-panel-subtitle">
					Showcase your listings with powerful search features that integrates with your workspace.
				</div>
			</div>
		</div>
		<div class="estatebud-sidebar-content-body-table-wrapper">
			<div class="action-group">
				<div class="action-group-1">
					<select class="bulk-options search-experience" name="bulk_options">
						<option value="" disabled="disabled" selected="selected">Bulk actions</option>
						<option value="delete">Delete</option>
					</select>
					<button class="apply-button" id="search-bulk-action-apply-button">Apply</button>
				</div>
				<div class="action-group-2">
					<button class="create-new-button" id="search-experience-create-button">Create new</button>
				</div>
			</div>
			<table class="table-search-experience">
				<tbody id="search-exp-table-body">
					<tr>
						<th><input type="checkbox" class="input-checkbox" name="search-experience-bulk-selector"></th>
						<th>Name</th>
						<th>Type</th>
						<th>ID</th>
						<th>Actions</th>
					</tr>
					<?php foreach ($all_exp_data as $key => $value): ?>
						<tr>
							<td><input type="checkbox" class="input-checkbox" name="search-experience-individual-selector" id="<?php echo esc_attr(sprintf('checkbox_%s', $value['id'])); ?>"></td>
							<td><?php echo esc_html($value['name']); ?></td>
							<td><?php echo esc_html($value['type']); ?></td>
							<td><?php echo esc_html($value['id']); ?></td>
							<td>
								<div class="quick-edit-actions">
									<div class="clone-action" name="search-experience-clone-button" id="clone_<?php echo esc_attr($value['id']); ?>" title="Clone search experience"><?php echo wp_kses($icon_clone, Icons::get_kses_ruleset()); ?></div>
									<div class="shortcode-generate" name="search-experience-shortcode-generate-button" id="<?php echo sprintf('shortcode_%s', esc_attr($value['id'])); ?>"><?php echo wp_kses($icon_gear, Icons::get_kses_ruleset()); ?></div>
									<div class="edit-action" name="search-experience-edit-button" id="edit_button_<?php echo esc_attr($value['id']); ?>"><?php echo wp_kses($icon_edit, Icons::get_kses_ruleset()); ?></div>
									<div class="delete" name="search-experience-delete-button" id="delete_button_<?php echo esc_attr($value['id']); ?>"><?php echo wp_kses($icon_delete, Icons::get_kses_ruleset()); ?></div>
								</div>
							</td>
						</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	</div>