<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;

$pages = get_pages();

if (!$pages) {
    $pages = [];
}
?>
<div class="estatebud-modal-content-panel group-1">
    <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
        'panel_title' => 'Notification email'
    ]); ?>
    <div class="estatebud-modal-content-panel">
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'To'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_to'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Subject'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_subject'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Message'
                ]); ?>
            </div>
            <div class="estatebud-textarea-field-group">
                <?php Helper::render_markup_from_views('Admin/partials/textarea-field.php', [
                    'variable_name' => '',
                    'rows' => 5,
                    'cols' => 67,
                    'textarea_content' => ''
                ]); ?>
                <p>Add fields using their shortcode, or leave empty for all fields.</p>
            </div>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'From email'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_from'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'From name'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_from_name'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Reply-to'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_reply_to'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Cc'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_cc'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Bcc'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'email_bcc'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Meta data'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                'extra_class' => 'multiselect',
                'multiple' => true,
                'variable_name' => 'email_meta_data[]',
                'options' => [
                    ['value' => '', 'disabled' => true, 'selected' => false, 'label' => 'Any'],
                    [
                        'value' => 'date',
                        'disabled' => false,
                        'selected' => true,
                        'label' => 'Date'
                    ],
                    [
                        'value' => 'time',
                        'disabled' => false,
                        'selected' => true,
                        'label' => 'Time'
                    ],
                    [
                        'value' => 'page_url',
                        'disabled' => false,
                        'selected' => true,
                        'label' => 'Page Url'
                    ],
                ],
            ]); ?>
        </div>
    </div>
    <div class="sep"></div>
</div>

<div class="estatebud-modal-content-panel group-2">
    <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
        'panel_title' => 'Confirmation email'
    ]); ?>
    <div class="estatebud-modal-content-panel">
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Subject'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'confirmation_email_subject'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Message'
                ]); ?>
            </div>
            <div class="estatebud-textarea-field-group">
                <?php Helper::render_markup_from_views('Admin/partials/textarea-field.php', [
                    'variable_name' => 'confirmation_email_message',
                    'rows' => 5,
                    'cols' => 67,
                    'textarea_content' => ''
                ]); ?>
            </div>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'From email'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'confirmation_email_from'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'From name'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'confirmation_email_from_name'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Reply-to'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'confirmation_email_reply_to'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Cc'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'confirmation_email_cc'
            ]); ?>
        </div>
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Bcc'
                ]); ?>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'value' => '',
                'variable_name' => 'confirmation_email_bcc'
            ]); ?>
        </div>
    </div>
    <div class="sep"></div>
</div>

<div class="estatebud-modal-content-panel group-3">
    <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
        'panel_title' => 'Miscellaneous'
    ]); ?>
    <div class="estatebud-modal-content-panel">
        <div class="estatebud-field-group estatebud-width-485">
            <div class="estatebud-field-label">
                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                    'field_label' => 'Privacy policy'
                ]); ?>
            </div>
            <?php
            $privacy_policy_page_id = isset($privacy_policy_page_id) ? $privacy_policy_page_id : '';

            $privacy_policy_options = [
                [
                    'value' => '',
                    'label' => 'None',
                    'selected' => $privacy_policy_page_id === ''
                ]
            ];

            foreach ($pages as $page) {
                $privacy_policy_options[] = [
                    'value' => $page->ID,
                    'label' => $page->post_title,
                    'selected' => $page->ID == $privacy_policy_page_id
                ];
            }

            Helper::render_markup_from_views('Admin/partials/select-field.php', [
                'variable_name' => 'privacy_policy_page_id',
                'extra_class' => 'privacy-policy',
                'options' => $privacy_policy_options
            ]);
            ?>
        </div>
    </div>
    <div class="sep"></div>
</div>