<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Icons;
use EstatebudConnect\Models\Forms;
use EstatebudConnect\Models\SearchExperience;
use EstatebudConnect\Utilities\Helper;

if (!isset($modal_position)) {
    $modal_position = 'form';
}

if (!isset($id) || !$id) {
    $id = '';
}

$form_id = '';
$search_id = '';
$selected_search_exp_module = '';
$selected_form_type = '';

if ($modal_position === 'form') {
    $form_id = $id;
}

if ($modal_position === 'search') {
    $search_id = $id;
}

$form_list = Forms::instance()->get_all_forms();

$search_exp_list = SearchExperience::instance()->get_all_search_exps();

if (!empty($search_id)) {
    $selected_search_exp_module = array_values(
        array_filter($search_exp_list, function ($search_ele) use ($search_id) {
            return $search_ele['id'] === $search_id;
        }),
    )[0]['type'];
}

if (!empty($form_id)) {
    $selected_form_type = array_values(
        array_filter($form_list, function ($form_ele) use ($form_id) {
            return $form_ele['id'] === $form_id;
        }),
    )[0]['type'];
}

if ($selected_form_type !== 'contact') {
    $form_list = array_filter($form_list, function ($form) {
        return isset($form['type']) && $form['type'] !== 'contact';
    });
}

$icon_copy = Icons::get_svg_icon('copy', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 13, 14, '#6B6B6B');
?>
<div class="estatebud-modal-wrapper">
    <form class="estatebud-modal estatebud-modal-general-form shortcode-generate-modal" name="shortcode-generate-modal">
        <?php Helper::render_markup_from_views('Admin/modal/modal-header.php', [
            'modal_title' => 'Shortcode generator'
        ]); ?>
        <div class="etatebude-modal-content">
            <div class="estatebud-modal-content-panel"<?php echo $selected_form_type === 'contact' ? ' style="display: none;"' : ''; ?>>
                <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                    'panel_title' => 'Settings'
                ]); ?>
                <div class="estatebud-modal-content-panel">
                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Widget mode'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'widget_mode',
                            'options' => [
                                ['value' => 'true', 'disabled' => false, 'label' => 'True'],
                                [
                                    'value' => 'false',
                                    'disabled' => false,
                                    'label' => 'False',
                                    'selected' => true
                                ]
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485" style="<?php echo $modal_position === 'form' ? 'display:none' : 'display:flex'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Form'
                            ]); ?>
                        </div>
                        <?php
                        $options = [
                            [
                                'value' => '-',
                                'label' => '-',
                                'selected' => true
                            ]
                        ];

                        foreach ($form_list as $form) {
                            if ($selected_search_exp_module) {
                                if ($form['type'] !== $selected_search_exp_module) {
                                    continue;
                                }
                            }

                            $options[] = [
                                'value' => $form['id'],
                                'label' => $form['name'],
                                'selected' => $form_id && $form['id'] === $form_id
                            ];
                        }

                        Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'extra_class' => 'Form',
                            'variable_name' => 'form',
                            'options' => $options
                        ]);
                        ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485" style="<?php echo $modal_position === 'search' ? 'display:none' : 'display:flex'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Search experience'
                            ]); ?>
                        </div>
                        <?php
                        $options = [
                            [
                                'value' => '-',
                                'label' => '-',
                                'selected' => true
                            ]
                        ];

                        foreach ($search_exp_list as $search) {
                            if ($selected_form_type) {
                                if ($search['type'] !== $selected_form_type) {
                                    continue;
                                }
                            }

                            $options[] = [
                                'value' => $search['id'],
                                'label' => $search['name'],
                                'selected' => $search_id && $search['id'] === $search_id
                            ];
                        }

                        Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'extra_class' => 'Search',
                            'variable_name' => 'search',
                            'options' => $options
                        ]);
                        ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Map'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'map',
                            'options' => [
                                ['value' => 'true', 'disabled' => false, 'label' => 'True'],
                                [
                                    'value' => 'false',
                                    'disabled' => false,
                                    'label' => 'False',
                                    'selected' => true
                                ]
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Map position'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'map_position',
                            'options' => [
                                ['value' => 'top', 'disabled' => false, 'label' => 'Top'],
                                ['value' => 'right', 'disabled' => false, 'label' => 'Right'],
                                ['value' => 'left', 'disabled' => false, 'label' => 'Left']
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Map default state'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'map_default_state',
                            'options' => [
                                ['value' => 'on', 'disabled' => false, 'label' => 'On'],
                                ['value' => 'off', 'disabled' => false, 'label' => 'Off']
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Map clustering'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'map_clustering',
                            'options' => [
                                ['value' => 'true', 'disabled' => false, 'label' => 'True'],
                                ['value' => 'false', 'disabled' => false, 'label' => 'False']
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Map zoom limit'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'map_zoom_limit',
                            'options' => [
                                [
                                    'value' => '',
                                    'disabled' => false,
                                    'label' => 'None',
                                    'selected' => true
                                ],
                                ['value' => '1', 'disabled' => false, 'label' => '1'],
                                ['value' => '2', 'disabled' => false, 'label' => '2'],
                                ['value' => '3', 'disabled' => false, 'label' => '3'],
                                ['value' => '4', 'disabled' => false, 'label' => '4'],
                                ['value' => '5', 'disabled' => false, 'label' => '5'],
                                ['value' => '6', 'disabled' => false, 'label' => '6'],
                                ['value' => '7', 'disabled' => false, 'label' => '7'],
                                ['value' => '8', 'disabled' => false, 'label' => '8'],
                                ['value' => '9', 'disabled' => false, 'label' => '9'],
                                ['value' => '10', 'disabled' => false, 'label' => '10']
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Sorting'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'sorting',
                            'options' => [
                                [
                                    'value' => 'property_id',
                                    'disabled' => false,
                                    'label' => 'Property ID'
                                ],
                                [
                                    'value' => 'published',
                                    'disabled' => false,
                                    'label' => 'Published'
                                ],
                                [
                                    'value' => 'updated',
                                    'disabled' => false,
                                    'label' => 'Updated'
                                ],
                                [
                                    'value' => 'price_asc',
                                    'disabled' => false,
                                    'label' => 'Price (lowest)'
                                ],
                                [
                                    'value' => 'price_desc',
                                    'disabled' => false,
                                    'label' => 'Price (highest)'
                                ]
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Results per page'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'results_per_page',
                            'options' => [
                                ['value' => '3', 'disabled' => false, 'label' => '3'],
                                ['value' => '6', 'disabled' => false, 'label' => '6'],
                                ['value' => '9', 'disabled' => false, 'label' => '9'],
                                [
                                    'value' => '12',
                                    'disabled' => false,
                                    'selected' => true,
                                    'label' => '12'
                                ],
                                ['value' => '15', 'disabled' => false, 'label' => '15'],
                                ['value' => '18', 'disabled' => false, 'label' => '18'],
                                ['value' => '21', 'disabled' => false, 'label' => '21'],
                                ['value' => '24', 'disabled' => false, 'label' => '24']
                            ]
                        ]); ?>
                    </div>

                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Favorites'
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'favorites',
                            'options' => [
                                [
                                    'value' => '',
                                    'disabled' => false,
                                    'label' => 'None',
                                    'selected' => true
                                ],
                                [
                                    'value' => 'property',
                                    'disabled' => false,
                                    'label' => 'Property'
                                ],
                                [
                                    'value' => 'project',
                                    'disabled' => false,
                                    'label' => 'Project'
                                ]
                            ]
                        ]); ?>
                    </div>
                </div>
                <div class="sep"></div>
            </div>

            <div class="estatebud-modal-content-panel estatebud-gap-18">
                <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                    'panel_title' => 'Shortcode'
                ]); ?>
                <div class="estatebud-field-label">
                    <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                        'field_label' => 'Copy and paste the generated shortcode at the designated place.'
                    ]); ?>
                </div>
                <div class="estatebud-modal-content-panel">
                    <div class="estatebud-field-group estatebud-width-603">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Code'
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-383 estatebud-gap-10">
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => '[estatebud]',
                                'variable_name' => 'short_code',
                                'extra_class' => 'estatebud-shortcode-text'
                            ]); ?>
                            <div class="estatebud-cursor-pointer" id="shortcode_copy_button"><?php echo wp_kses($icon_copy, Icons::get_kses_ruleset()); ?> </div>
                        </div>
                    </div>
                </div>
            </div>

            <div style="display: none" id="estatebud-form-type">
                <?php echo esc_html($selected_form_type); ?>
            </div>
        </div>
        <?php Helper::render_markup_from_views('Admin/modal/modal-footer.php', ['modal_type' => 'shortcode']); ?>
    </form>
</div>