<?php
if (!defined('WPINC')) {
    die();
}

$default_class = 'estatebud-field-select';
$id = 'estatebud-field-select';

if (!isset($custom_options)) {
    $custom_options = [];
}

if (isset($extra_class) && !empty($extra_class)) {
    $default_class .= ' ' . $extra_class;
}

if (isset($extra_id) && !empty($extra_id)) {
    $id .= ' ' . $extra_id;
}
?>

<select class="<?php echo esc_attr($default_class); ?>" id="<?php echo esc_attr($id); ?>" name="<?php echo esc_attr($variable_name ?? ''); ?>"<?php echo isset(
    $multiple,
)
    ? ' multiple'
    : ''; ?>>
    <optgroup label="Custom fields">
        <?php foreach ($custom_options as $option): ?>
            <option value="<?php echo isset($option['value']) ? esc_attr($option['value']) : ''; ?>"<?php
echo isset($option['disabled']) && $option['disabled'] ? ' disabled="disabled"' : '';
echo isset($option['selected']) && $option['selected'] ? ' selected' : '';
?> ><?php echo isset($option['label']) ? esc_html($option['label']) : ''; ?></option>
        <?php endforeach; ?>
    </optgroup>
    <optgroup label="Estatebud fields">
        <?php foreach ($options ?? [] as $option): ?>
            <option value="<?php echo isset($option['value']) ? esc_attr($option['value']) : ''; ?>"<?php
echo isset($option['disabled']) && $option['disabled'] ? ' disabled="disabled"' : '';
echo isset($option['selected']) && $option['selected'] ? ' selected' : '';
?> ><?php echo isset($option['label']) ? esc_html($option['label']) : ''; ?></option>
        <?php endforeach; ?>
    </optgroup>
</select>