<?php
use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Models\Dashboard;
use EstatebudConnect\Configs\Icons;

if (!defined('WPINC')) {
    die();
}

$icon_dashboard = Icons::get_svg_icon('grid-2', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_dashboard_active = Icons::get_svg_icon('grid-2', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);
$icon_search = Icons::get_svg_icon('magnifying-glass', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_search_active = Icons::get_svg_icon('magnifying-glass', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);
$icon_property_listing = Icons::get_svg_icon('house-chimney', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_property_listing_active = Icons::get_svg_icon('house-chimney', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);
$icon_project_listing = Icons::get_svg_icon('house-building', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_project_listing_active = Icons::get_svg_icon('house-building', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);
$icon_forms = Icons::get_svg_icon('input-pipe', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_forms_active = Icons::get_svg_icon('input-pipe', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);
$icon_localization = Icons::get_svg_icon('globe', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_localization_active = Icons::get_svg_icon('globe', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);
$icon_settings = Icons::get_svg_icon('gear', Icons::SHAPE_SHARP, Icons::STYLE_REGULAR, 20, 16);
$icon_settings_active = Icons::get_svg_icon('gear', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 20, 16);

$plugin_active_status = Dashboard::instance()->plugin_active_status();
?>
<div class="estatebud-sidebar-body">
      <ul class="estatebud-menu-list">
            <li class="estatebud-menu-active" data-view="dashboard">
                  <div style="display: none;"><?php echo wp_kses($icon_dashboard, Icons::get_kses_ruleset()); ?></div>
                  <div style="display: flex;"><?php echo wp_kses($icon_dashboard_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Dashboard</p>
            </li>
            <li class="<?php echo $plugin_active_status
                ? ''
                : 'estatebud-menu-disabled'; ?>" data-view="search-experience">
                  <div style="display: flex;"><?php echo wp_kses($icon_search, Icons::get_kses_ruleset()); ?></div>
                  <div style="display:none"><?php echo wp_kses($icon_search_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Search experience</p>
            </li>
            <li class="<?php echo $plugin_active_status
                ? ''
                : 'estatebud-menu-disabled'; ?>" data-view="property-listing">
                  <div style="display: flex;"><?php echo wp_kses($icon_property_listing, Icons::get_kses_ruleset()); ?></div>
                  <div style="display: none;"><?php echo wp_kses($icon_property_listing_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Property listing</p>
            </li>
            <li class="<?php echo $plugin_active_status
                ? ''
                : 'estatebud-menu-disabled'; ?>" data-view="project-listing">
                  <div style="display: flex;"><?php echo wp_kses($icon_project_listing, Icons::get_kses_ruleset()); ?></div>
                  <div style="display: none;"><?php echo wp_kses($icon_project_listing_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Project listing</p>
            </li>
            <li class="<?php echo $plugin_active_status ? '' : 'estatebud-menu-disabled'; ?>" data-view="forms">
                  <div style="display: flex;"><?php echo wp_kses($icon_forms, Icons::get_kses_ruleset()); ?></div>
                  <div style="display: none;"><?php echo wp_kses($icon_forms_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Forms</p>
            </li>
            <li data-view="localization">
                  <div style="display: flex;"><?php echo wp_kses($icon_localization, Icons::get_kses_ruleset()); ?></div>
                  <div style="display: none;"><?php echo wp_kses($icon_localization_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Localization</p>
            </li>
            <li data-view="settings">
                  <div style="display: flex;"><?php echo wp_kses($icon_settings, Icons::get_kses_ruleset());  ?></div>
                  <div style="display: none;"><?php echo wp_kses($icon_settings_active, Icons::get_kses_ruleset()); ?></div>
                  <p>Settings</p>
            </li>
      </ul>
      <?php Helper::render_markup_from_views(
          'Admin/sidebar/footer/sidebar-footer.php',
          [],
          'estatebud_sidebar_footer',
      ); ?>
</div>