<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Configs\Icons;

if (!isset($settings_data)) {
    $settings_data = [];
}
if (!isset($form_data)) {
    $form_data = [];
}
if (!isset($field_options)) {
    $field_options = [];
}

$captcha_provider = $settings_data['captcha_provider'] ?? '';
$captcha_site_key = $settings_data['captcha_site_key'] ?? '';
$captcha_secret_key = $settings_data['captcha_secret_key'] ?? '';

$fields = $form_data['fields'];

$privacy_policy_page_id = isset($form_data['privacy_policy_page_id']) ? $form_data['privacy_policy_page_id'] : '';
$privacy_policy_page_url = '';

if (!empty($privacy_policy_page_id)) {
    $privacy_policy_page_url = get_page_link($privacy_policy_page_id);
}

$icon_check = Icons::get_svg_icon('check', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 11, 10, '#FFF');
$icon_success = Icons::get_svg_icon('check-circle', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 16, 16, '#65A30D');
$icon_failed = Icons::get_svg_icon('xmark-circle', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 16, 16, '#DC2626');

$setting = $settings_data;
extract($setting);

$form_unique_id = 'estatebud-form-' . sanitize_html_class($form_id);
$form_container_id = $form_unique_id . '-container';
$success_message_id = $form_unique_id . '-success-message';
$required_failed_message_id = $form_unique_id . '-required-field-failed-message';
$invalid_value_message_id = $form_unique_id . '-invalied-value-detected-message';
$submit_failed_message_id = $form_unique_id . '-submit-failed';
$captcha_failed_message_id = $form_unique_id . '-captcha-failed';
?>
<?php if ($form_id): ?>
    <div class="estatebud-form-container" id="<?php echo esc_attr($form_container_id); ?>">
        <div class="estatebud-form-messages-container">
            <div class="estatebud-form-message-container estatebud-form-message-success-container estatebud-hidden" id="<?php echo esc_attr($success_message_id); ?>">
                <div class="estatebud-form-message-content">
                    <span class="estatebud-form-message-icon"><?php echo wp_kses($icon_success, Icons::get_kses_ruleset()); ?></span>
                    <div class="estatebud-form-success-message-text"><?php echo esc_html(Helper::term('forms.submitted.title')); ?></div>
                </div>
            </div>
            <div class="estatebud-form-message-container estatebud-from-message-failed-container estatebud-hidden" id="<?php echo esc_attr($required_failed_message_id); ?>">
                <div class="estatebud-form-message-content">
                    <span class="estatebud-form-message-icon estatebud-form-failed-message-icon"><?php echo wp_kses($icon_failed, Icons::get_kses_ruleset()); ?></span>
                    <div class="estatebud-form-failed-message-text">
                        <div class="estatebud-form-failed-message-text-main"><?php echo esc_html(Helper::term('forms.error.title')); ?></div>
                        <div class="estatebud-form-failed-message-text-submain"><?php echo esc_html(Helper::term('forms.error.required_fields')); ?></div>
                    </div>
                </div>
            </div>
            <div class="estatebud-form-message-container estatebud-from-message-failed-container estatebud-hidden" id="<?php echo esc_attr($invalid_value_message_id); ?>">
                <div class="estatebud-form-message-content">
                    <span class="estatebud-form-message-icon estatebud-form-failed-message-icon"><?php echo wp_kses($icon_failed, Icons::get_kses_ruleset()); ?></span>
                    <div class="estatebud-form-failed-message-text">
                        <div class="estatebud-form-failed-message-text-main"><?php echo esc_html(Helper::term('forms.error.title')); ?></div>
                        <div class="estatebud-form-failed-message-text-submain"><?php echo esc_html(Helper::term('forms.error.invalid_value')); ?></div>
                    </div>
                </div>
            </div>
            <div class="estatebud-form-message-container estatebud-from-message-failed-container estatebud-hidden" id="<?php echo esc_attr($submit_failed_message_id); ?>">
                <div class="estatebud-form-message-content">
                    <span class="estatebud-form-message-icon estatebud-form-failed-message-icon"><?php echo wp_kses($icon_failed, Icons::get_kses_ruleset()); ?></span>
                    <div class="estatebud-form-failed-message-text">
                        <div class="estatebud-form-failed-message-text-main"><?php echo esc_html(Helper::term('forms.error.generic')); ?></div>
                    </div>
                </div>
            </div>
            <div class="estatebud-form-message-container estatebud-from-message-failed-container estatebud-hidden" id="<?php echo esc_attr($captcha_failed_message_id); ?>">
                <div class="estatebud-form-message-content">
                    <span class="estatebud-form-message-icon estatebud-form-failed-message-icon"><?php echo wp_kses($icon_failed, Icons::get_kses_ruleset()); ?></span>
                    <div class="estatebud-form-failed-message-text">
                        <div class="estatebud-form-failed-message-text-main"><?php echo esc_html(Helper::term('forms.error.captcha_failed')); ?></div>
                    </div>
                </div>
            </div>
        </div>
        <form class="estatebud-form-content" id="<?php echo esc_attr($form_unique_id); ?>" method="post" action="">
            <div class="estatebud-form-fields-group">
                <?php Helper::render_markup_from_views('Public/partials/components/form-fields.php', [
                    'form_id' => $form_id,
                    'settings_data' => $settings_data,
                    'form_data' => $form_data,
                    'field_options' => $field_options
                ]); ?>
            </div>

            <?php if ($privacy_policy_page_url): ?>
                <?php $accept_terms_id = Helper::unique_id('estatebud-accept-terms-'); ?>
                <div class="estatebud-form-consent-group">
                    <label class="estatebud-custom-checkbox checkbox">
                        <?php Helper::render_markup_from_views('Public/partials/components/fields/input.php', [
                            'type' => 'checkbox',
                            'name' => 'accept-terms',
                            'id' => $accept_terms_id,
                            'required' => true
                        ]); ?>
                        <span class="estatebud-checkbox-mark"><?php echo wp_kses($icon_check, Icons::get_kses_ruleset()); ?></span>
                    </label>
                    <label class="estatebud-form-consent-privacy-policy" for="<?php echo esc_attr($accept_terms_id); ?>">
                        <?php printf(
                            esc_html(Helper::term('forms.privacy_disclaimer')),
                            '<a href="' . esc_url($privacy_policy_page_url) . '" target="_blank" class="estatebud-form-consent-link">' . esc_html(Helper::term('forms.privacy_policy')) . '</a>'
                        ); ?>
                    </label>
                </div>
            <?php endif; ?>

            <div id='<?php echo esc_attr($form_unique_id . '-form-id'); ?>' style="display: none;"><?php echo esc_html($form_id); ?></div>

            <?php
            $is_button_available = $form_data['is_button_available'] ?? false;
            if ($is_button_available):
                $icon_button = '';
                if (isset($form_data['button_icon_type']) && $form_data['button_icon_type']) {
                    $icon_button = Icons::get_svg_icon(
                        $form_data['button_icon_type'],
                        Icons::SHAPE_SHARP,
                        Icons::STYLE_SOLID,
                        18,
                        18,
                        '#ffffff'
                    );
                }
                $icon_position = isset($form_data['button_icon_position'])
                    ? $form_data['button_icon_position']
                    : 'left';
                $button_width_class = '';
                if (isset($form_data['button_width']) && !empty(trim($form_data['button_width']))) {
                    $button_width = intval($form_data['button_width']);
                    if ($button_width > 0 && $button_width <= 100) {
                        $button_width_class = ' estatebud-form-field-w' . $button_width;
                    }
                }
                ?>
                <div class="estatebud-form-submit-button-container<?php echo esc_attr($button_width_class); ?>">
                    <button type="submit" class="estatebud-form-submit-button" id="<?php echo esc_attr($form_unique_id . '-submit-button'); ?>">
                        <?php if ($icon_position === 'left' && $icon_button): ?>
                            <span class="estatebud-form-submit-button-icon"><?php echo wp_kses($icon_button, Icons::get_kses_ruleset()); ?></span>
                        <?php endif; ?>
                        <div class="estatebud-form-submit-button-text">
                            <?php echo esc_html(Helper::term(sprintf("form.%s.button.label", $form_id))); ?>
                        </div>
                        <?php if ($icon_position === 'right' && $icon_button): ?>
                            <span class="estatebud-form-submit-button-icon"><?php echo wp_kses($icon_button, Icons::get_kses_ruleset()); ?></span>
                        <?php endif; ?>
                    </button>
                </div>

                <?php if (!empty($captcha_provider) && !empty($captcha_site_key)): ?>
                    <?php if ($captcha_provider == 'recaptcha'): ?>
                        <div class="estatebud-form-captcha-disclaimer">
                            <p><?php echo sprintf(
                                    esc_html(Helper::term('forms.captcha.disclaimer.recaptcha')),
                                    '<a href="https://policies.google.com/privacy" target="_blank" rel="noopener noreferrer nofollow">' . esc_html(Helper::term('forms.privacy_policy')) . '</a>',
                                    '<a href="https://policies.google.com/terms" target="_blank" rel="noopener noreferrer nofollow">' . esc_html(Helper::term('forms.terms_of_service')) . '</a>'
                            ); ?></p>
                        </div>
                    <?php endif; ?>
                    <?php if ($captcha_provider == 'hcaptcha'): ?>
                        <div class="estatebud-form-captcha-disclaimer">
                            <p><?php echo sprintf(
                                    esc_html(Helper::term('forms.captcha.disclaimer.recaptcha')),
                                    '<a href="https://www.hcaptcha.com/privacy" target="_blank" rel="noopener noreferrer nofollow">' . esc_html(Helper::term('forms.privacy_policy')) . '</a>',
                                    '<a href="https://www.hcaptcha.com/terms" target="_blank" rel="noopener noreferrer nofollow">' . esc_html(Helper::term('forms.terms_of_service')) . '</a>'
                            ); ?></p>
                        </div>
                    <?php endif; ?>
                    <?php if ($captcha_provider == 'turnstile'): ?>
                        <div class="estatebud-form-captcha-disclaimer">
                            <p><?php echo sprintf(
                                    esc_html(Helper::term('forms.captcha.disclaimer.recaptcha')),
                                    '<a href="https://www.cloudflare.com/turnstile-privacy-policy/" target="_blank" rel="noopener noreferrer nofollow">' . esc_html(Helper::term('forms.privacy_policy')) . '</a>',
                                    '<a href="https://www.cloudflare.com/website-terms/" target="_blank" rel="noopener noreferrer nofollow">' . esc_html(Helper::term('forms.terms_of_service')) . '</a>'
                            ); ?></p>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
        </form>
    </div>
<?php endif; ?>
