<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Configs\Icons;

if (!isset($settings_data)) {
    $settings_data = [];
}
$setting = $settings_data;
extract($setting);

if (!isset($icon_type)) {
    $icon_type = Icons::SHAPE_SHARP;
}

if (!isset($icon_style)) {
    $icon_style = Icons::STYLE_SOLID;
}

$icon_map_location_dot = Icons::get_svg_icon('location-dot', $icon_type, $icon_style, 11, 14, $branding_color);
$icon_bedrooms = Icons::get_svg_icon('bed-front', $icon_type, $icon_style, 14, 14, '#131729');
$icon_bathrooms = Icons::get_svg_icon('bath', $icon_type, $icon_style, 14, 14, '#131729');
$icon_covered_area = Icons::get_svg_icon('expand', $icon_type, $icon_style, 14, 14, '#131729');
$icon_plot_area = Icons::get_svg_icon('arrows-maximize', $icon_type, $icon_style, 14, 14, '#131729');
$icon_heart = Icons::get_svg_icon('heart', $icon_type, 'regular', 24, 24, '#FFFFFF');
$icon_angle_left = Icons::get_svg_icon('angle-left', $icon_type, $icon_style, 12, 20, '#FFFFFF');
$icon_angle_right = Icons::get_svg_icon('angle-right', $icon_type, $icon_style, 12, 20, '#FFFFFF');

$perks_data = [];

$bedrooms = $listing->get_bedrooms();
if ($bedrooms !== null) {
    $perks_data[] = [
        'text' => $bedrooms,
        'icon' => $icon_bedrooms
    ];
}

$bathrooms = $listing->get_bathrooms();
if ($bathrooms !== null) {
    $perks_data[] = [
        'text' => $bathrooms,
        'icon' => $icon_bathrooms
    ];
}

$covered_area = $listing->get_covered_area();
if ($covered_area !== null) {
    $perks_data[] = [
        'text' => $covered_area,
        'icon' => $icon_covered_area
    ];
}

if ($listing instanceof Property) {
    $plot_area = $listing->get_plot_area();
    if ($plot_area !== null) {
        $perks_data[] = [
            'text' => $plot_area,
            'icon' => $icon_plot_area
        ];
    }
}

$area = $listing->get_area();

$is_favorite = isset($is_favorite) ? $is_favorite : false;
?>
<div class="estatebud-listing-card-content" data-listing-id="<?php echo esc_attr($listing->get_id()); ?>" data-is-favorite="<?php echo $is_favorite ? 'true' : 'false'; ?>">
    <div class="estatebud-listing-card-status-wrapper">
        <div class="estatebud-listing-card-status-label-group">
            <?php foreach ($listing->get_labels() as $label) {
                Helper::render_markup_from_views('Public/partials/components/listing-label.php', [
                    'name' => $label['name'],
                    'color' => $label['color']
                ]);
            } ?>
        </div>

        <div name="carousel-left" class="estatebud-listing-card-carousel-button"><?php echo wp_kses($icon_angle_left, Icons::get_kses_ruleset()); ?></div>
        <div name="carousel-right" class="estatebud-listing-card-carousel-button"><?php echo wp_kses($icon_angle_right, Icons::get_kses_ruleset()); ?></div>

        <div class="estatebud-listing-card-status-label-group favorite-button">
            <?php echo wp_kses($icon_heart, Icons::get_kses_ruleset()); ?>
        </div>
        <?php
        $images = $listing->get_images();

        if (empty($images)) {
            $images[] = $listing->get_image();
        }

        $imageCount = count($images);
        $lastIndex = $imageCount - 1;
        ?>
        <div class="estatebud-listing-card-slider-track">
            <?php foreach ($images as $index => $image): ?>
                <?php 
                    $shouldLoadInitially = ($index === 0 || $index === 1 || ($index === $lastIndex && $lastIndex > 1));
                ?>
                <div class="estatebud-listing-card-slide-item<?php echo $index === 0 ? ' estatebud-slide-active' : ''; ?>" data-index="<?php echo esc_attr($index); ?>"<?php echo $index === 0 ? '' : ' aria-hidden="true" tabindex="-1"'; ?>>
                    <img id="<?php echo esc_attr($index); ?>" alt="property image" <?php echo $shouldLoadInitially ? 'src=' : 'data-src='; ?>"<?php echo esc_url(Helper::image_optimizer($image, ['w' => '378', 'h' => '239', 'f' => 'crop'])); ?>" class="estatebud-listing-card-status-image" />
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="estatebud-listing-card-information-wrapper">
        <div class="estatebud-listing-card-category-information">
            <div class="estatebud-listing-card-category">
                <div class="estatebud-listing-card-category-name"><?php echo esc_html($listing->get_type()); ?></div>
                <div class="estatebud-listing-card-category-id"><?php echo esc_html($listing->get_reference_id()); ?></div>
            </div>
            <div class="estatebud-listing-card-name-wrapper">
                <div class="estatebud-listing-card-name">
                    <?php echo esc_html($listing->get_title()); ?>
                </div>
            </div>
            <div class="estatebud-listing-card-price-wrapper">
                <div class="estatebud-listing-main-price">
                    <?php echo esc_html(Helper::format_price($listing->get_price()) ?? Helper::term('listing.price_on_request')); ?>
                </div>
                <div class="estatebud-listing-main-base-price estatebud-hidden">
                    <?php if ($listing->get_price()) {
                        echo esc_html($listing->get_price()['price']);
                    } ?>
                </div>
                <div class="estatebud-listing-discount-price<?php echo $listing->get_original_price() ? '' : ' estatebud-hidden'; ?>">
                    <?php echo esc_html(Helper::format_price($listing->get_original_price())); ?>
                </div>
                <div class="estatebud-listing-discount-base-price estatebud-hidden">
                    <?php if ($listing->get_original_price()) {
                        echo esc_html($listing->get_original_price()['price']);
                    } ?>
                </div>
                <div class="estatebud-listing-card-price-text">
                    <?php
                    if (!empty($listing->get_price()['frequency'])) {
                        echo esc_html(Helper::term('frequency.every.' . $listing->get_price()['frequency']));
                    }
                    if ($listing->get_price()['vat']) {
                        echo esc_html(Helper::term('listing.plus_vat'));
                    }
                    ?>
                </div>
            </div>
            <?php if ($area !== null): ?>
            <div class="estatebud-listing-card-location-wrapper">
                <?php echo wp_kses($icon_map_location_dot, Icons::get_kses_ruleset()); ?>
                <div class="estatebud-listing-card-location-name"><?php echo esc_html($area); ?></div>
            </div>
            <?php endif; ?>
        </div>
        <?php if (count($perks_data)): ?>
        <div class="estatebud-listing-card-separator"></div>
        <div class="estatebud-listing-card-perks-group">
            <?php foreach ($perks_data as $perk) {
                Helper::render_markup_from_views('Public/partials/components/listing-card-perk.php', $perk);
            } ?>
        </div>
        <?php endif; ?>
    </div>
    <a href="<?php echo esc_attr($listing->get_url()); ?>" class="estatebud-listing-card-content-link" target="<?php echo $setting['link_opening_behavior'] == 'new_tab' ? '_blank' : '_self'; ?>"></a>
</div>