<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\App;
use EstatebudConnect\Utilities\Helper;

if (Helper::get_seo_plugin()) {
    return;
}
?>
<!-- Optimization by <?php echo esc_html(App::NAME); ?> v<?php echo esc_html(App::VERSION); ?> - https://estatebud.com/solutions/real-estate-website -->
<meta name="description" content="<?php echo esc_attr($listing->get_meta_description()); ?>" />
<link rel="canonical" href="<?php echo esc_attr($listing->get_url()); ?>" />
<meta property="og:locale" content="<?php echo esc_attr(get_locale()); ?>" />
<meta property="og:type" content="website" />
<meta property="og:image" content="<?php echo esc_url(Helper::image_optimizer($listing->get_og_image(), [
    'w' => 1200,
    'h' => 630,
    'f' => 'cover'
])); ?>" />
<meta property="og:title" content="<?php echo esc_attr($listing->get_og_title()); ?>" />
<meta property="og:description" content="<?php echo esc_attr($listing->get_og_description()); ?>" />
<meta property="og:url" content="<?php echo esc_attr($listing->get_og_url()); ?>" />
<meta property="og:site_name" content="<?php echo esc_attr(get_bloginfo('name')); ?>" />
<!-- / End optimization -->
