<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Configs\Icons;

if (!isset($settings_data)) {
    $settings_data = [];
}
$setting = $settings_data;
extract($setting);

if (!isset($icon_type)) {
    $icon_type = Icons::SHAPE_SHARP;
}

if (!isset($icon_style)) {
    $icon_style = Icons::STYLE_SOLID;
}

if (!isset($field_style)) {
    $field_style = '';
}

if (!isset($sort_query)) {
    $sort_query = [
        'sort' => 'published',
        'sort_type' => 'desc',
    ];
}

if (!isset($is_favorites)) {
    $is_favorites = false;
}

if (!isset($widget_mode)) {
    $widget_mode = 'false';
}

if (!isset($shortcode_id)) {
    $shortcode_id = '';
}

$icon_grid = Icons::get_svg_icon('grid-view', $icon_type, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');
$icon_list = Icons::get_svg_icon('list-view', $icon_type, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');
?>
<div class="estatebud-listings-content-header" data-shortcode-id="<?php echo esc_attr($shortcode_id); ?>">
    <h1 class="estatebud-main-content-title"><?php echo esc_html($title); ?></h1>
    <div class="estatebud-main-content-option-group">
      <div class="width-200">
        <?php Helper::render_markup_from_views('Public/partials/components/fields/select.php', [
            'variable_name' => 'listings-sort',
            'id' => 'listings-sort-' . $shortcode_id,
            'extra_class' => 'estatebud-single-choice',
            'options' => [
                [
                    'value' => 'published',
                    'label' => Helper::term('listings.sort.published'),
                    'selected' => $sort_query['sort'] === 'published'
                ],
                [
                    'value' => 'updated',
                    'label' => Helper::term('listings.sort.updated'),
                    'selected' => $sort_query['sort'] === 'updated'
                ],
                [
                    'value' => 'price_asc',
                    'label' => Helper::term('listings.sort.price_asc'),
                    'selected' => $sort_query['sort'] === 'price' && $sort_query['sort_type'] === 'asc'
                ],
                [
                    'value' => 'price_desc',
                    'label' => Helper::term('listings.sort.price_desc'),
                    'selected' => $sort_query['sort'] === 'price' && $sort_query['sort_type'] === 'desc'
                ],
                [
                    'value' => 'property_id',
                    'label' => Helper::term('listings.sort.reference_id'),
                    'selected' => $sort_query['sort'] === 'property_id'
                ]
            ],
            'multiple' => false,
            'add_empty_option' => false
        ]); ?>
      </div>
      <div class="estatebud-main-content-view-option-group">
        <div class="estatebud-main-content-view-option active">
          <?php echo wp_kses($icon_grid, Icons::get_kses_ruleset()); ?>
          <span class="estatebud-main-content-view-option-title"><?php echo esc_html(Helper::term('listings.button.grid')); ?></span>
        </div>
        <div class="estatebud-main-content-view-option">
          <?php echo wp_kses($icon_list, Icons::get_kses_ruleset()); ?>
          <span class="estatebud-main-content-view-option-title"><?php echo esc_html(Helper::term('listings.button.list')); ?></span>
        </div>
      </div>
    </div>
  </div>