<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Models\Settings;

if (!isset($page_number)) {
    $page_number = 1;
}

if (!isset($settings_data)) {
    $settings_data = [];
}

$branding_color = $settings_data['branding_color'];

$map_position = $map_position ?? 'top';
$map_default_state = $map_default_state ?? 'off';

if ($map_default_state === 'on' && ($map_position === 'left' || $map_position === 'right')) {
    $loading_wrapper_style =
        'width: 60% !important; max-width: 60% !important; flex-shrink: 0 !important; flex-grow: 0 !important;';
}
?>
<div class="estatebud-listings-loading-wrapper"<?php echo isset($loading_wrapper_style) ? ' style="' . esc_attr($loading_wrapper_style) . '"' : ''; ?>>
    <div class="estatebud-listings-loading" style="<?php echo esc_attr(sprintf('border-top-color: %s', $branding_color)); ?>">
    </div>
</div>
<div class="estatebud-pagination" style="display: none;">
    <a href="<?php echo esc_attr("ebp=" . $page_number); ?>" class="estatebud-pagination-outer-number-group active" id="<?php echo esc_attr("pagination_" . $page_number); ?>">
        <span class="estatebud-pagination-number"><?php echo esc_html($page_number); ?></span>
    </a>
</div>