<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Icons;
use EstatebudConnect\Models\Project;
use EstatebudConnect\Models\Property;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Utilities\Helper;

if (!isset($settings_data)) {
    $settings_data = [];
}
$is_powered_by_enabled = $settings_data['powered_by'] === '1';

if (!isset($search_result)) {
    $search_result = [];
}

if (!isset($search_result['results'])) {
    $listings = [];
} else {
    $listings = $search_result['results'];
}

if (!isset($page_number)) {
    $page_number = 1;
}

if (!isset($map_position)) {
    $map_position = 'top';
}

if (!isset($sorting)) {
    $sorting = 'published';
}

if (!isset($sort_query)) {
    $sort_query = [
        'sort' => 'published',
        'sort_type' => 'desc'
    ];
}

if (!isset($resutls_per_page)) {
    $resutls_per_page = 12;
}

if (!isset($widget_mode)) {
    $widget_mode = 'false';
}

if (!isset($is_favorites)) {
    $is_favorites = false;
}

if (!isset($currency_rate)) {
    $currency_rate = [];
}

if (!isset($shortcode_id)) {
    $shortcode_id = '';
}

if ($listing_type === 'property') {
    $result_count = $search_result['query']['properties_total_count'] ?? 0;
} else {
    $result_count = $search_result['query']['projects_total_count'] ?? 0;
}

$page_count = ceil($result_count / (int) $results_per_page);
$header_title =
    $result_count . ' ' . mb_strtolower(($is_favorites ? Helper::term('favorite', $result_count) : ($listing_type === 'property' ? Helper::term('property', $result_count) : Helper::term('project', $result_count))), 'UTF-8');

$iconLongArrow = Icons::get_svg_icon('arrow-long-right', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 16, 16, '#fff');
$buttonDetail = [
    'title' => 'Share with agent',
    'icon' => $iconLongArrow,
    'name' => 'share-with-agent'
];

$urlInputData = [
    'favorites_sharing_url' =>
        strtok(sanitize_text_field(wp_unslash($_SERVER['HTTP_REFERER'] ?? '')), '?') . '?' . http_build_query(['t' => $favorites_sharing_token])
];
?>
<div class="estatebud-map-wrapper" data-shortcode-id="<?php echo esc_attr($shortcode_id); ?>">
    <div id="<?php echo esc_attr(sprintf('estatebud-listings-map-%s', $shortcode_id)); ?>"><div class="estatebud-map-loader"></div></div>
</div>
<div class="estatebud-listings-container" id="<?php echo esc_attr(sprintf('estatebud-mobile-listings-container-%s', $shortcode_id)); ?>" data-shortcode-id="<?php echo esc_attr(
    $shortcode_id,
); ?>">
    <div class="estatebud-mobile-listings-handle" id="<?php echo esc_attr(sprintf('estatebud-mobile-listings-handle-%s', $shortcode_id)); ?>">
        <span class="estatebud-mobile-listings-handle-bar"></span>
    </div>
    <div class="estatebud-mobile-listings-inside-handle" id="<?php echo esc_attr(sprintf('estatebud-mobile-listings-inside-handle-%s', $shortcode_id)); ?>">
        <span class="estatebud-mobile-listings-handle-bar"></span>
    </div>
    <div class="estatebud-mobile-listings-scroll">
        <?php if ($widget_mode === 'false'): ?>
        <?php Helper::render_markup_from_views('Public/partials/components/listings-content-header.php', [
            'title' => $header_title,
            'sort_query' => $sort_query,
            'widget_mode' => $widget_mode,
            'shortcode_id' => $shortcode_id,
            'settings_data' => $settings_data,
        ]); ?>
        <?php endif; ?>
        <?php if ($is_favorites && !empty($favorites_sharing_token) && $result_count > 0): ?>
        <div class="estatebud-properties-content-share-with">
            <?php Helper::render_markup_from_views('Public/partials/components/url-input.php', $urlInputData); ?>
            <?php Helper::render_markup_from_views('Public/partials/components/icon-button.php', $buttonDetail); ?>
        </div>
        <?php endif; ?>
        <div class="estatebud-listings-content-body">
            <?php if (count($listings)) {
                foreach ($listings as $item) {
                    if ($listing_type === 'property') {
                        $listing = new Property($item);
                    } else {
                        $listing = new Project($item);
                    }

                    Helper::render_markup_from_views('Public/partials/components/listing-card.php', [
                        'listing' => $listing,
                        'currency_rate' => $currency_rate,
                        'settings_data' => $settings_data,
                    ]);
                }
            } else {
                Helper::render_markup_from_views('Public/partials/listings/results-error-listings.php');
            } ?>
        </div>
        <?php Helper::render_markup_from_views('Public/partials/components/pagination.php', [
            'page_count' => $page_count,
            'page_number' => $page_number,
            'widget_mode' => $widget_mode,
            'shortcode_id' => $shortcode_id,
        ]); ?>
        <?php if ($is_powered_by_enabled && $widget_mode === 'false'): ?>
        <div class="estatebud-powered-by-estatebud">
            <p class="estatebud-powered-by-text">Powered by</p>
            <svg xmlns="http://www.w3.org/2000/svg" width="126" height="30" viewBox="0 0 126 30" fill="none">
            <path d="M14.1836 0C14.1836 0 10.7861 1.615 7.53855 3.48999C4.29105 5.36499 1.19355 7.5 1.19355 7.5C1.19355 7.5 0.893555 11.25 0.893555 15C0.893555 18.75 1.19355 22.5 1.19355 22.5C1.19355 22.5 4.29105 24.635 7.53855 26.51C10.7861 28.385 14.1836 30 14.1836 30C14.1836 30 17.5811 28.385 20.8286 26.51C24.0761 24.635 27.1736 22.5 27.1736 22.5C27.1736 22.5 27.4736 18.75 27.4736 15C27.4736 11.25 27.1736 7.5 27.1736 7.5C27.1736 7.5 24.0761 5.36499 20.8286 3.48999C17.5811 1.615 14.1836 0 14.1836 0Z" fill="url(#paint0_linear_519_17951)"/>
            <path d="M19.5832 17.1C17.8807 16.9225 16.0282 16.7975 14.1832 16.7975C12.3382 16.7975 10.4857 16.9225 8.7832 17.1C8.7832 18.485 9.3082 19.7425 10.1657 20.7H18.2007C19.0582 19.7425 19.5832 18.485 19.5832 17.1Z" fill="#E6E6E6"/>
            <path d="M14.1835 22.4999C15.7785 22.4999 17.211 21.7999 18.201 20.6999C17.211 19.5999 15.781 18.8999 14.1835 18.8999C12.586 18.8999 11.156 19.5999 10.166 20.6999C11.156 21.7999 12.586 22.4999 14.1835 22.4999Z" fill="white"/>
            <path d="M23.8434 12.8799C23.8259 12.2349 23.8034 11.6149 23.7784 11.0399C21.2684 10.6349 17.7434 10.1999 14.1834 10.1999C10.6234 10.1999 7.09843 10.6349 4.58845 11.0399C4.56343 11.6124 4.54093 12.2349 4.52344 12.8799C6.99094 12.4699 10.6034 11.9999 14.1834 11.9999C17.7634 11.9999 21.3759 12.4699 23.8434 12.8799Z" fill="white"/>
            <path d="M47.9252 18.1733V20.0999H39.4736V10.017H47.8688V11.9506H41.9978V13.9897H47.5313V15.8038H41.9978V18.1733H47.9252ZM53.3813 20.353C52.6409 20.353 51.9236 20.2569 51.23 20.0647C50.5409 19.8725 49.9151 19.5913 49.3526 19.2209V17.3436C49.8683 17.7374 50.4635 18.042 51.1385 18.2577C51.8183 18.4733 52.5002 18.5811 53.1845 18.5811C53.7002 18.5811 54.0893 18.5038 54.3518 18.3491C54.6143 18.1944 54.7454 17.9811 54.7454 17.7092C54.7454 17.5124 54.6776 17.3413 54.5417 17.1959C54.4103 17.0459 54.1526 16.9217 53.7683 16.8233L51.9329 16.3874C51.0329 16.167 50.3837 15.86 49.9853 15.4663C49.5917 15.0725 49.3946 14.5803 49.3946 13.9897C49.3946 13.4834 49.5518 13.0381 49.8659 12.6538C50.1845 12.2694 50.6393 11.9717 51.23 11.7608C51.8252 11.5452 52.5212 11.4374 53.3183 11.4374C54.0401 11.4374 54.6962 11.5217 55.2869 11.6905C55.8776 11.8545 56.3861 12.0749 56.8127 12.3514V14.1655C56.3813 13.8702 55.8869 13.6358 55.3292 13.4624C54.7712 13.2842 54.1784 13.1952 53.5502 13.1952C52.9925 13.1952 52.5752 13.2655 52.2986 13.4061C52.022 13.542 51.8837 13.7342 51.8837 13.9827C51.8837 14.1889 51.9776 14.353 52.1651 14.4749C52.3571 14.5967 52.6736 14.7069 53.1143 14.8053L54.7595 15.1639C55.5845 15.3327 56.2103 15.6116 56.6369 16.0006C57.0635 16.3897 57.2768 16.9358 57.2768 17.6389C57.2768 18.178 57.122 18.6538 56.8127 19.0663C56.5079 19.4741 56.0627 19.7905 55.4768 20.0155C54.8909 20.2405 54.1925 20.353 53.3813 20.353ZM65.1446 13.61H62.6486V20.0999H60.1877V13.61H57.8675V11.7819H60.1877V10.235L62.6486 9.74283V11.7819H65.1446V13.61ZM69.6026 11.4374C70.526 11.4374 71.3183 11.5967 71.9792 11.9155C72.6401 12.2342 73.1438 12.703 73.4909 13.3217C73.8425 13.9405 74.0183 14.6928 74.0183 15.5788V20.0999H71.6276V18.9749C71.3417 19.4389 70.9526 19.7905 70.4603 20.0295C69.9728 20.2639 69.4034 20.3811 68.7518 20.3811C68.1425 20.3811 67.6079 20.2616 67.1486 20.0225C66.6893 19.7834 66.3329 19.4577 66.08 19.0452C65.8313 18.628 65.7071 18.1616 65.7071 17.6459C65.7071 17.1256 65.8361 16.6616 66.0938 16.2538C66.3563 15.8413 66.7268 15.5202 67.205 15.2905C67.6877 15.0561 68.2454 14.9389 68.8784 14.9389C70.1018 14.9389 71.0159 15.3374 71.6204 16.1342V15.7967C71.6111 15.2811 71.4893 14.8475 71.255 14.4959C71.0204 14.1444 70.6994 13.8819 70.2917 13.7084C69.8885 13.5303 69.422 13.4413 68.8925 13.4413C67.8188 13.4413 66.9002 13.8092 66.1361 14.5452V12.5202C67.1204 11.7983 68.276 11.4374 69.6026 11.4374ZM69.722 18.8202C70.0877 18.8202 70.4135 18.7639 70.6994 18.6514C70.9901 18.5389 71.2175 18.3819 71.3813 18.1803C71.5454 17.9788 71.6276 17.7538 71.6276 17.5053C71.6276 17.2663 71.5502 17.053 71.3954 16.8655C71.2409 16.6733 71.0204 16.5233 70.7345 16.4155C70.4534 16.3077 70.1276 16.2538 69.7571 16.2538C69.3962 16.2538 69.0845 16.3077 68.822 16.4155C68.5595 16.5233 68.3579 16.6733 68.2175 16.8655C68.0813 17.0577 68.0135 17.278 68.0135 17.5264C68.0135 17.7795 68.0813 18.0045 68.2175 18.2014C68.3534 18.3983 68.5502 18.5506 68.8079 18.6584C69.0659 18.7663 69.3704 18.8202 69.722 18.8202ZM82.1744 13.61H79.6784V20.0999H77.2175V13.61H74.897V11.7819H77.2175V10.235L79.6784 9.74283V11.7819H82.1744V13.61ZM91.6667 16.3241H85.0292C85.1651 16.9756 85.5119 17.4819 86.0696 17.8428C86.6276 18.1991 87.3611 18.3772 88.2704 18.3772C88.8704 18.3772 89.4308 18.2881 89.951 18.11C90.476 17.9319 90.9542 17.6881 91.3853 17.3788V19.2772C90.9401 19.6053 90.3917 19.8678 89.7401 20.0647C89.0933 20.2569 88.4183 20.353 87.7151 20.353C86.6885 20.353 85.7885 20.1631 85.0151 19.7834C84.2417 19.4038 83.6438 18.8717 83.222 18.1874C82.805 17.503 82.5962 16.7178 82.5962 15.8319C82.5962 15.0069 82.7861 14.2616 83.1659 13.5959C83.5502 12.9303 84.101 12.4053 84.8183 12.0209C85.5401 11.6319 86.3861 11.4374 87.3563 11.4374C88.28 11.4374 89.0627 11.5991 89.705 11.9225C90.3518 12.2413 90.8393 12.7006 91.1675 13.3006C91.5002 13.8959 91.6667 14.6084 91.6667 15.4381V16.3241ZM87.4127 13.3358C86.7704 13.3358 86.2478 13.4905 85.8446 13.7999C85.4417 14.1045 85.1837 14.5147 85.0712 15.0303H89.5994C89.5478 14.4866 89.3321 14.0694 88.9526 13.7788C88.5776 13.4834 88.0643 13.3358 87.4127 13.3358ZM99.2675 11.4374C100.036 11.4374 100.716 11.6295 101.306 12.0139C101.897 12.3983 102.354 12.928 102.678 13.603C103.001 14.2733 103.163 15.0233 103.163 15.853C103.163 16.7295 102.985 17.51 102.628 18.1944C102.277 18.8788 101.794 19.4108 101.18 19.7905C100.57 20.1655 99.8933 20.353 99.1478 20.353C98.3558 20.353 97.6667 20.1842 97.0808 19.8467C96.4994 19.5045 96.0494 19.0194 95.7308 18.3913V20.0999H93.2909V9.72876H95.7308V13.6944C96.0026 12.9866 96.4409 12.4334 97.0454 12.035C97.6502 11.6366 98.3909 11.4374 99.2675 11.4374ZM98.1353 18.3702C98.6321 18.3702 99.0683 18.2647 99.4433 18.0538C99.8183 17.8381 100.106 17.5428 100.308 17.1678C100.51 16.7881 100.61 16.3616 100.61 15.8881C100.61 15.4194 100.512 14.9975 100.315 14.6225C100.118 14.2475 99.8345 13.9545 99.4643 13.7436C99.0986 13.528 98.6696 13.4202 98.1776 13.4202C97.6853 13.4202 97.2518 13.5303 96.8768 13.7506C96.5018 13.9663 96.2135 14.2639 96.0119 14.6436C95.8103 15.0233 95.7095 15.4522 95.7095 15.9303C95.7095 16.3991 95.8079 16.8186 96.005 17.1889C96.2018 17.5545 96.4829 17.8428 96.8486 18.0538C97.2143 18.2647 97.6433 18.3702 98.1353 18.3702ZM113.625 11.7819V20.0999H111.178V18.4053C110.897 19.0663 110.485 19.5655 109.941 19.903C109.402 20.2358 108.764 20.4022 108.028 20.4022C106.941 20.4022 106.104 20.0881 105.518 19.46C104.937 18.8272 104.646 17.9225 104.646 16.7459V11.7819H107.093V16.2397C107.093 16.9897 107.255 17.5475 107.578 17.9131C107.906 18.2788 108.399 18.4616 109.055 18.4616C109.725 18.4616 110.245 18.2553 110.616 17.8428C110.991 17.4256 111.178 16.8561 111.178 16.1342V11.7819H113.625ZM125.107 9.72876V20.0999H122.66V18.2014C122.356 18.8717 121.908 19.3991 121.318 19.7834C120.727 20.1631 120.007 20.353 119.159 20.353C118.39 20.353 117.708 20.1631 117.113 19.7834C116.518 19.3991 116.056 18.8717 115.728 18.2014C115.399 17.5311 115.235 16.7764 115.235 15.9374C115.231 15.0655 115.406 14.2897 115.763 13.61C116.119 12.9256 116.611 12.3936 117.239 12.0139C117.872 11.6295 118.582 11.4374 119.37 11.4374C120.157 11.4374 120.825 11.6155 121.374 11.9717C121.922 12.328 122.351 12.8459 122.66 13.5256V9.72876H125.107ZM120.178 18.3702C120.675 18.3702 121.114 18.2624 121.493 18.0467C121.878 17.8264 122.173 17.5241 122.379 17.1397C122.585 16.7553 122.689 16.3241 122.689 15.8459C122.689 15.3772 122.588 14.96 122.386 14.5944C122.185 14.2241 121.896 13.9358 121.521 13.7295C121.146 13.5233 120.708 13.4202 120.206 13.4202C119.714 13.4202 119.283 13.5256 118.913 13.7366C118.547 13.9428 118.264 14.2334 118.062 14.6084C117.865 14.9834 117.767 15.41 117.767 15.8881C117.767 16.3663 117.865 16.7952 118.062 17.1749C118.264 17.5499 118.545 17.8428 118.906 18.0538C119.271 18.2647 119.695 18.3702 120.178 18.3702Z" fill="#858585"/>
            <defs>
                <linearGradient id="paint0_linear_519_17951" x1="27.0005" y1="-6.38628e-07" x2="1.00049" y2="30" gradientUnits="userSpaceOnUse">
                <stop offset="0.16" stop-color="#B8B8B8"/>
                <stop offset="0.84" stop-color="#858585"/>
                </linearGradient>
            </defs>
            </svg>
        </div>
        <?php endif; ?>
    </div>
</div>

