<?php

namespace EstatebudConnect\Configs;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class App
{
    use Singleton;

    const NAME = 'Estatebud Connect';
    const SLUG = 'estatebud-connect';
    const VERSION = '1.0-rc2';

    const NORMALIZED_MAP_ZOOM = [
        '1' => ['mapbox' => 10, 'openstreetmap' => 10, 'google' => 10, 'openfreemap' => 10],
        '2' => ['mapbox' => 11, 'openstreetmap' => 11, 'google' => 11, 'openfreemap' => 11],
        '3' => ['mapbox' => 12, 'openstreetmap' => 12, 'google' => 12, 'openfreemap' => 12],
        '4' => ['mapbox' => 13, 'openstreetmap' => 13, 'google' => 13, 'openfreemap' => 13],
        '5' => ['mapbox' => 14, 'openstreetmap' => 14, 'google' => 14, 'openfreemap' => 14],
        '6' => ['mapbox' => 15, 'openstreetmap' => 15, 'google' => 15, 'openfreemap' => 15],
        '7' => ['mapbox' => 16, 'openstreetmap' => 16, 'google' => 16, 'openfreemap' => 16],
        '8' => ['mapbox' => 17, 'openstreetmap' => 17, 'google' => 17, 'openfreemap' => 17],
        '9' => ['mapbox' => 18, 'openstreetmap' => 18, 'google' => 18, 'openfreemap' => 18],
        '10' => ['mapbox' => 19, 'openstreetmap' => 19, 'google' => 19, 'openfreemap' => 19],
    ];

    const EDGE_STYLE_CONVERSION = [
        'edge_style' => [
            'sharp' => 0,
            'round' => 4,
            'circle' => 8,
        ],
        'field_style' => [
            'sharp' => 0,
            'round' => 4,
            'circle' => 8,
        ],
        'button_style' => [
            'sharp' => 0,
            'round' => 4,
            'circle' => 24,
        ],
    ];

    const BUTTON_STYLE_CONVERSION = [
        'sharp' => [
            'padding' => [
                'x' => 16,
                'y' => 10,
            ],
        ],
        'round' => [
            'padding' => [
                'x' => 16,
                'y' => 10,
            ],
        ],
        'circle' => [
            'padding' => [
                'x' => 20,
                'y' => 10,
            ],
        ],
    ];

    public const SEO_TITLE_FILTERS = [
        'pre_get_document_title',
        'wpseo_title',
        'rank_math/frontend/title',
        'aioseo_title',
    ];

    public const SEO_DESCRIPTION_FILTERS = ['wpseo_metadesc', 'rank_math/frontend/description', 'aioseo_description'];

    public const SEO_OG_TITLE_FILTERS = ['wpseo_opengraph_title', 'rank_math/opengraph/type'];

    public const SEO_OG_IMAGE_FILTERS = [
        'wpseo_opengraph_image',
        'rank_math/opengraph/facebook/image',
        'rank_math/opengraph/twitter/image',
    ];

    public const OG_DESCRIPTION_FILTERS = ['wpseo_opengraph_desc'];

    public const SEO_OG_URL_FILTERS = ['wpseo_opengraph_url', 'rank_math/opengraph/url'];

    public const SEO_CANONICAL_FILTERS = ['wpseo_canonical', 'rank_math/frontend/canonical', 'aioseo_canonical_url'];
}
