<?php

namespace EstatebudConnect\Models;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Defaults;
use EstatebudConnect\Services\Estatebud;
use EstatebudConnect\Core\OptionsAPI;
use EstatebudConnect\Traits\Singleton;

class Settings
{
    use Singleton;

    public function __construct() {}

    public function get_api_key($censored = false)
    {
        $settings = $this->get_data();

        $api_key = $settings['estatebud_api_key'];

        if ($censored && !empty($api_key)) {
            $api_key = str_repeat('*', strlen($api_key) - 5) . substr($api_key, -5);
        }

        return $api_key;
    }

    public function get_data()
    {
        $result = OptionsAPI::instance()->get('settings');
        if ($result) {
            return array_merge(Defaults::SETTINGS, $result);
        } else {
            return Defaults::SETTINGS;
        }
    }

    public function save_data($form_data)
    {
        $parsed_form_data = $this->parse_input_data($form_data);
        $api_key = $this->get_api_key();

        if (isset($parsed_form_data['estatebud_api_key'])) {
            if ($this->get_api_key(true) === $parsed_form_data['estatebud_api_key']) {
                $parsed_form_data['estatebud_api_key'] = $api_key;
            } else {
                $api_key = $parsed_form_data['estatebud_api_key'] ?? '';
            }
        }

        $whois = Estatebud::instance()->set_token($api_key)->whois();

        if ($whois) {
            $result = OptionsAPI::instance()->update('whois', $whois);
        }

        $result_flag = OptionsAPI::instance()->update('settings', $parsed_form_data);
        
        if ($result_flag === false) {
            $option_exists = OptionsAPI::instance()->get('settings', false) !== false;
            if ($option_exists) {
                $result_flag = true;
            }
        }

        return $result_flag;
    }
    
    protected function parse_input_data($form_data)
    {
        $defaults = Defaults::SETTINGS;
        $textareas = ['custom_css'];
        $booleans = ['favorites','powered_by','ip_lookup'];
        $parsed_form_data = [];

        foreach ($form_data as $key => $value) {
            $key = sanitize_text_field(wp_unslash($key));
            $value = wp_unslash($value);

            if (isset($defaults[$key])) {
                if (in_array($key, $booleans)) {
                    $parsed_form_data[$key] = filter_var($value, FILTER_VALIDATE_BOOLEAN);
                } else if (in_array($key, $textareas)) {
                    $parsed_form_data[$key] = sanitize_textarea_field($value);
                } else if (is_array($value)) {
                    $parsed_form_data[$key] = array_map('sanitize_text_field', $value);
                } else {
                    $parsed_form_data[$key] = sanitize_text_field($value);
                }
            }
        }

        return $parsed_form_data;
    }
}
