<?php

namespace EstatebudConnect\Models;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Sharing as Config;

class Sharing
{
    public $url;
    public $text;
    public $subject;

    public function __construct($url, $text = null, $subject = null) {
        $this->url = $url;
        $this->text = $text ?? $url;
        $this->subject = $subject ?? $url;
    }

    public function get_url($provider)
    {
        if (!$this->validate_provider($provider)) {
            return false;
        }

        $provider_data = $this->get_provider($provider);

        $placeholders = [
            '{{ url }}',
            '{{ text }}',
            '{{ subject }}',
        ];

        $replacements = [
            urlencode($this->url),
            urlencode($this->text),
            urlencode($this->subject),
        ];

        $sharing_url = str_replace($placeholders, $replacements, $provider_data['url_template']);

        return $sharing_url;
    }

    public function get_color($provider)
    {
        $provider_data = $this->get_provider($provider);

        return $provider_data['color'] ?? false;
    }

    public function get_icon($provider)
    {
        $provider_data = $this->get_provider($provider);

        return $provider_data['icon'] ?? false;
    }

    protected function get_provider($provider)
    {
        return Config::PROVIDERS[$provider] ?? false;
    }

    protected function validate_provider($provider)
    {
        return isset(Config::PROVIDERS[$provider]);
    }
}