<?php

namespace EstatebudConnect\Services;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class WPML
{
    use Singleton;

    public function __construct() {}

    public function get_enabled_languages()
    {
        if (!function_exists('icl_get_languages')) {
            return [];
        }

        $languages = apply_filters('wpml_active_languages', null, 'orderby=id&order=desc');

        if (empty($languages) || !is_array($languages)) {
            return [];
        }

        $enabled_languages = [];
        foreach ($languages as $code => $language) {
            $enabled_languages[] = [
                'code' => $code,
                'name' => $language['native_name'] ?? ($language['translated_name'] ?? ''),
                'flag' => $language['country_flag_url'] ?? '',
                'url' => $language['url'] ?? '',
                'active' => $language['active'] ?? false,
            ];
        }

        return $enabled_languages;
    }
}
