<?php

namespace EstatebudConnect\Services;

if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Traits\Singleton;

class Weglot
{
    use Singleton;

    public function __construct() {}

    public function get_enabled_languages()
    {
        if (!function_exists('weglot_get_languages_available')) {
            return [];
        }

        $languages = weglot_get_languages_available();

        if (empty($languages) || !is_array($languages)) {
            return [];
        }

        $enabled_languages = [];
        foreach ($languages as $language) {
            $enabled_languages[] = [
                'code' => $language['code'] ?? '',
                'name' => $language['name'] ?? '',
                'flag' => $language['flag'] ?? '',
                'url' => $language['url'] ?? '',
                'active' => $language['current'] ?? false,
            ];
        }

        return $enabled_languages;
    }
}
