<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Models\Dashboard;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Services\Estatebud;
use EstatebudConnect\Utilities\Helper;

$dashboard_status = Dashboard::instance()->get_dashboard_status();

$whois = Estatebud::instance()->whois();
// TODO: temporary fix for start
$default_currency = is_array($whois) && isset($whois['currency']) ? $whois['currency'] : 'USD';

$currencies = Helper::get_currencies_codes();
if ($default_currency && isset($currencies[$default_currency])) {
    unset($currencies[$default_currency]);
}
// temporary fix
$pdf_template_list = Estatebud::instance()->get_property_pdf_templates();
?>

<?php if ($body_layout == 'dashboard'): ?>
	<?php Helper::render_markup_from_views('Admin/contents/body/dashboard.php', $dashboard_status, 'estatebud_sidebar'); ?>
<?php elseif ($body_layout == 'search-experience'): ?>
	<?php Helper::render_markup_from_views('Admin/contents/body/search-experience.php', [], 'estatebud_sidebar'); ?>
<?php elseif ($body_layout == 'property-listing'): ?>
	<?php Helper::render_markup_from_views(
     'Admin/contents/body/property-listing.php',
     ['pdf_template_list' => $pdf_template_list],
     'estatebud_sidebar',
 ); ?>
<?php elseif ($body_layout == 'project-listing'): ?>
	<?php Helper::render_markup_from_views(
     'Admin/contents/body/project-listing.php',
     ['pdf_template_list' => $pdf_template_list],
     'estatebud_sidebar',
 ); ?>
<?php elseif ($body_layout == 'forms'): ?>
	<?php Helper::render_markup_from_views('Admin/contents/body/form.php', [], 'estatebud_sidebar'); ?>
<?php elseif ($body_layout == 'localization'): ?>
	<?php Helper::render_markup_from_views('Admin/contents/body/localization.php', [], 'estatebud_sidebar'); ?>
<?php else: ?>
	<?php Helper::render_markup_from_views(
     'Admin/contents/body/settings.php',
     ['currencies' => $currencies],
     'estatebud_sidebar',
 ); ?>
<?php endif; ?>

