<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper; ?>

<div class="estatebud-sidebar-content-body">
	<div class="estatebud-content-panel-wide">
		<div class="estatebud-content-panel-title-wrapper">
			<div class="estatebud-content-panel-title">
				Welcome to Estatebud Connect for WordPress!
			</div>
			<div class="estatebud-content-panel-subtitle">
				Connect with your workspace to build powerful search experiences and advanced forms that synchronizes your data in real time.
			</div>
		</div>
		<div class="sep"></div>
	</div>
	<div class="estatebud-content-panel-wide">
		<div class="estatebud-content-panel-title">
			Subscription
		</div>
		<div class="estatebud-content-panel-content">
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Status</div>
				</div>
				<?php if (isset($subscription) && $subscription['active'] === true) {
        echo '<div class="estatebud-status-field-content">
							<span class="status-indicator"></span>
							<span class="status-indicator-value">Active</span>
							<span class="status-date">until ' .
            esc_html($subscription['expire_date']) .
            '</span>
						</div>';
    } elseif (isset($subscription) && $subscription['active'] === false) {
        echo '<div class="estatebud-status-field-content">
							<span class="status-indicator expired"></span>
							<span class="status-indicator-value">Expired</span>
							<span class="status-date">ended ' .
            esc_html($subscription['expire_date']) .
            '</span>
						</div>';
    } else {
        echo '<div class="estatebud-status-field-content">
							<span class="status-indicator not-configured"></span>
							<span class="status-indicator-value">Not configured</span>
							<div class="estatebud-button-secondary" id="add_api_key_button" style="margin-left: 12px">Add your API key</div>
						</div>';
    } ?>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Issued to</div>
				</div>
				<div class="estatebud-typography"><?php echo isset($company_name) && $subscription['active']
        ? esc_html($company_name)
        : '-'; ?></div>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Plan</div>
				</div>
				<div class="estatebud-typography"><?php echo isset($subscription['plan']) && $subscription['active']
        ? esc_html(ucfirst($subscription['plan']))
        : '-'; ?></div>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Seats</div>
				</div>
				<div class="estatebud-typography"><?php echo isset($subscription['seats']) && $subscription['active']
        ? esc_html($subscription['seats'])
        : '-'; ?></div>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Identifier</div>
				</div>
				<div class="estatebud-typography"><?php echo isset($hash) && $subscription['active'] ? esc_html($hash) : '-'; ?></div>
			</div>
		</div>
		<div class="sep"></div>
	</div>

	<div class="estatebud-content-panel-wide">
		<div class="estatebud-content-panel-title">
			Configuration
		</div>
		<div class="estatebud-content-panel-content">
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Default currency</div>
				</div>
				<div class="estatebud-typography text-uppercase"><?php echo isset($currency) && $subscription['active']
        ? esc_html($currency)
        : '-'; ?></div>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Measurement units</div>
				</div>
				<div class="estatebud-typography text-capitalize"><?php echo isset($measurements) && $subscription['active']
        ? esc_html($measurements)
        : '-'; ?></div>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label estatebud-no-padding estatebud-height-auto">
					<div class="estatebud-field-label-content">Country</div>
				</div>
				<div class="estatebud-typography"><?php echo isset($country) && $subscription['active']
        ? esc_html(Helper::get_country_name_from_code($country))
        : '-'; ?></div>
			</div>
		</div>
	</div>
</div>