<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Icons;
use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Models\Localizations;
use EstatebudConnect\Core\Locale;

$enabled_languages = Locale::instance()->get_enabled_languages();
$current_language = 'en';

foreach ($enabled_languages as $language) {
    if ($language['active']) {
        $current_language = $language['code'];
        break;
    }
}

$dynamic_terms = Helper::get_translatable_form_terms();
$locale_terms = Locale::instance()->get_terms($current_language);

foreach ($locale_terms as $key => $term) {
	if (isset($term['value']) && is_array($term['value'])) {
		if (isset($term['value']['one'])) {
			$locale_terms[$key]['value']['singular'] = $term['value']['one'];
		}

		if (isset($term['value']['other'])) {
			$locale_terms[$key]['value']['plural'] = $term['value']['other'];
		}

		unset($locale_terms[$key]['value']['one'], $locale_terms[$key]['value']['other']);
	}
}

$translatable_terms = array_merge($dynamic_terms, $locale_terms);

$localizations_model = Localizations::instance();
$existing_localizations = $localizations_model->get_localizations($current_language);

if (empty($enabled_languages)) {
    $enabled_languages = [
        [
            'code' => 'en',
            'name' => 'English',
            'flag' => '',
            'url' => '',
            'active' => true,
        ],
    ];
}
?>
<div class="estatebud-sidebar-content-body-scrollable">
	<div class="estatebud-sidebar-content-body-table-wrapper estatebud-localization-table-wrapper">
		<div class="action-group">
			<div class="action-group-1">
				<div class="estatebud-localization-dropdowns">
					<div class="estatebud-dropdown-wrapper">
						<select class="estatebud-choices-select" id="language-selector" name="language" data-placeholder="Language">
							<?php foreach ($enabled_languages as $language): ?>
								<option value="<?php echo esc_attr($language['code']); ?>"<?php echo $language['active'] ? ' selected' : ''; ?>>
									<?php echo esc_html(Helper::get_locale_display_name($language['code'], $language['name'])); ?>
								</option>
							<?php endforeach; ?>
						</select>
					</div>
					<div class="estatebud-dropdown-wrapper">
						<select class="estatebud-choices-select" id="filter-selector" name="filter" data-placeholder="Filter">
							<option value="all" selected>All</option>
							<option value="field-label">Field label</option>
							<option value="field-placeholder">Field placeholder</option>
							<option value="field-option">Field option</option>
							<option value="button-text">Button text</option>
						</select>
					</div>
				</div>
			</div>
			<div class="action-group-2">
				<input type="text" class="estatebud-search-input" placeholder="Search" id="localization-search">
			</div>
		</div>

		<div class="estatebud-localization-table">
			<table class="estatebud-localization-table">
				<thead>
					<tr>
						<th>Value</th>
						<th>Translation</th>
					</tr>
				</thead>
				<tbody id="localization-table-body">
					<?php if (!empty($translatable_terms)): ?>
						<?php foreach ($translatable_terms as $term): ?>
							<?php $existing_value = $existing_localizations[$term['key']] ?? ''; ?>
							<?php if (is_array($term['value'])): ?>
								<tr data-key="<?php echo esc_attr($term['key']); ?>" class="estatebud-singular-plural-row">
									<td class="estatebud-localization-value-cell">
										<div class="estatebud-singular-plural-container">
											<div class="estatebud-singular-row">
												<div class="estatebud-localization-value-content">
													<span><?php echo esc_html($term['value']['singular']); ?></span>
													<div class="estatebud-localization-tags">
														<span class="estatebud-singular-chip">Singular</span>
														<span class="estatebud-localization-tag"><?php echo esc_html(Helper::get_term_type_label($term['key'])); ?></span>
													</div>
												</div>
											</div>
											<div class="estatebud-plural-row">
												<div class="estatebud-localization-value-content">
													<span><?php echo esc_html($term['value']['plural']); ?></span>
													<div class="estatebud-localization-tags">
														<span class="estatebud-plural-chip">Plural</span>
														<span class="estatebud-localization-tag"><?php echo esc_html(Helper::get_term_type_label($term['key'])); ?></span>
													</div>
												</div>
											</div>
										</div>
									</td>
									<td class="estatebud-localization-translation-cell">
										<div class="estatebud-singular-plural-inputs">
											<div class="estatebud-input-group">
												<input type="text" class="estatebud-localization-input estatebud-singular-input"
													value="<?php echo esc_attr(is_array($existing_value) ? $existing_value['singular'] : ''); ?>"
													placeholder="<?php echo esc_attr(Helper::term($term['key'], 1, $current_language)); ?>">
											</div>
											<div class="estatebud-input-group">
												<input type="text" class="estatebud-localization-input estatebud-plural-input"
													value="<?php echo esc_attr(is_array($existing_value) ? $existing_value['plural'] : ''); ?>"
													placeholder="<?php echo esc_attr(Helper::term($term['key'], 0, $current_language)); ?>">
											</div>
										</div>
									</td>
								</tr>
							<?php else: ?>
								<tr data-key="<?php echo esc_attr($term['key']); ?>">
									<td class="estatebud-localization-value-cell">
										<div class="estatebud-localization-value-content">
											<span><?php echo esc_html($term['value']); ?></span>
											<div class="estatebud-localization-tags">
												<span class="estatebud-localization-tag"><?php echo esc_html(Helper::get_term_type_label($term['key'])); ?></span>
											</div>
										</div>
									</td>
									<td class="estatebud-localization-translation-cell">
										<input type="text" class="estatebud-localization-input"
											value="<?php echo esc_attr($existing_value); ?>"
											placeholder="<?php echo esc_attr(Helper::term($term['key'], 1, $current_language)); ?>">
									</td>
								</tr>
							<?php endif; ?>
						<?php endforeach; ?>
					<?php else: ?>
						<tr>
							<td colspan="2" class="estatebud-localization-empty-state">
								<div class="estatebud-localization-empty-content">
									<span>No translatable terms found. Create some forms first.</span>
								</div>
							</td>
						</tr>
					<?php endif; ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
