<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Models\Project;
use EstatebudConnect\Models\Forms;

if (!isset($pdf_template_list)) {
    $pdf_template_list = [];
}

$project_obj = new Project();
$option_values = $project_obj->get_settings();
$form_data = Forms::instance()->get_all_forms();
$contact_forms = array_values(
    array_filter($form_data, function ($form) {
        return $form['type'] == 'contact';
    }),
);
?>
<div class="estatebud-sidebar-content-body-scrollable">
	<div class="estatebud-content-panel">
		<div class="estatebud-content-panel-title">
			General
		</div>
		<div class="estatebud-content-panel-content">
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Slider style</div>
				</div>
				<select class="estatebud-choices-select" id="project_slider_style" name="slider_style">
					<option value="contained"<?php echo $option_values['slider_style'] == 'contained' ? ' selected' : ''; ?>>Contained</option>
					<option value="fullscreen"<?php echo $option_values['slider_style'] == 'fullscreen' ? ' selected' : ''; ?>>Fullscreen</option>
				</select>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Contact details</div>
				</div>
				<select class="estatebud-choices-select" id="project_contact_details" name="contact_details">
					<option value="hide"<?php echo $option_values['contact_details'] == 'hide' ? ' selected' : ''; ?>>Hide</option>
					<option value="agent"<?php echo $option_values['contact_details'] == 'agent' ? ' selected' : ''; ?>>Agent</option>
					<option value="office"<?php echo $option_values['contact_details'] == 'office' ? ' selected' : ''; ?>>Office</option>
				</select>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Contact form</div>
				</div>
				<select class="estatebud-choices-select" id="project_contact_form" name="contact_form">
					<option value="">None</option>
					<?php foreach ($contact_forms as $form): ?>
						<option
							value="<?php echo esc_attr($form['id']); ?>"
							<?php echo $option_values['contact_form'] == $form['id'] ? ' selected' : ''; ?>>
							<?php echo esc_html($form['name']); ?>
						</option>
					<?php endforeach; ?>
				</select>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Mortgage calculator</div>
				</div>
				<div class="estatebud-radio-group">
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_mortgage_calculator_1" class="estatebud-radio-option" name="mortgage_calculator" value="1"<?php echo $option_values[
          'mortgage_calculator'
      ] == true
          ? ' checked'
          : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_mortgage_calculator_1">Enable</label>
					</div>
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_mortgage_calculator_0" class="estatebud-radio-option" name="mortgage_calculator" value="0"<?php echo $option_values[
          'mortgage_calculator'
      ] == false
          ? ' checked'
          : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_mortgage_calculator_0">Disable</label>
					</div>
				</div>
			</div>
			<div class="sep"></div>
		</div>
	</div>

	<div class="estatebud-content-panel">
		<div class="estatebud-content-panel-title">
			Map
		</div>
		<div class="estatebud-content-panel-content">
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Map style</div>
				</div>
				<select class="estatebud-choices-select" id="project_map_style" name="map_style">
					<option value="invisible"<?php echo $option_values['map_style'] == 'invisible' ? ' selected' : ''; ?>>Invisible</option>
					<option value="contained"<?php echo $option_values['map_style'] == 'contained' ? ' selected' : ''; ?>>Contained</option>
					<option value="fullscreen"<?php echo $option_values['map_style'] == 'fullscreen' ? ' selected' : ''; ?>>Fullscreen</option>
				</select>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Map default zoom</div>
				</div>
				<select class="estatebud-choices-select" id="project_map_default_zoom" name="map_default_zoom">
					<option value=""<?php echo empty($option_values['map_default_zoom']) ? ' selected' : ''; ?>>None</option>
					<option value="1"<?php echo $option_values['map_default_zoom'] == '1' ? ' selected' : ''; ?>>1</option>
					<option value="2"<?php echo $option_values['map_default_zoom'] == '2' ? ' selected' : ''; ?>>2</option>
					<option value="3"<?php echo $option_values['map_default_zoom'] == '3' ? ' selected' : ''; ?>>3</option>
					<option value="4"<?php echo $option_values['map_default_zoom'] == '4' ? ' selected' : ''; ?>>4</option>
					<option value="5"<?php echo $option_values['map_default_zoom'] == '5' ? ' selected' : ''; ?>>5</option>
					<option value="6"<?php echo $option_values['map_default_zoom'] == '6' ? ' selected' : ''; ?>>6</option>
					<option value="7"<?php echo $option_values['map_default_zoom'] == '7' ? ' selected' : ''; ?>>7</option>
					<option value="8"<?php echo $option_values['map_default_zoom'] == '8' ? ' selected' : ''; ?>>8</option>
					<option value="9"<?php echo $option_values['map_default_zoom'] == '9' ? ' selected' : ''; ?>>9</option>
					<option value="10"<?php echo $option_values['map_default_zoom'] == '10' ? ' selected' : ''; ?>>10</option>
				</select>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Map zoom limit</div>
				</div>
				<select class="estatebud-choices-select" id="project_map_zoom_limit" name="map_zoom_limit">
					<option value=""<?php echo empty($option_values['map_zoom_limit']) ? ' selected' : ''; ?>>None</option>
					<option value="1"<?php echo $option_values['map_zoom_limit'] == '1' ? ' selected' : ''; ?>>1</option>
					<option value="2"<?php echo $option_values['map_zoom_limit'] == '2' ? ' selected' : ''; ?>>2</option>
					<option value="3"<?php echo $option_values['map_zoom_limit'] == '3' ? ' selected' : ''; ?>>3</option>
					<option value="4"<?php echo $option_values['map_zoom_limit'] == '4' ? ' selected' : ''; ?>>4</option>
					<option value="5"<?php echo $option_values['map_zoom_limit'] == '5' ? ' selected' : ''; ?>>5</option>
					<option value="6"<?php echo $option_values['map_zoom_limit'] == '6' ? ' selected' : ''; ?>>6</option>
					<option value="7"<?php echo $option_values['map_zoom_limit'] == '7' ? ' selected' : ''; ?>>7</option>
					<option value="8"<?php echo $option_values['map_zoom_limit'] == '8' ? ' selected' : ''; ?>>8</option>
					<option value="9"<?php echo $option_values['map_zoom_limit'] == '9' ? ' selected' : ''; ?>>9</option>
					<option value="10"<?php echo $option_values['map_zoom_limit'] == '10' ? ' selected' : ''; ?>>10</option>
				</select>
			</div>
			<div class="sep"></div>
		</div>
	</div>

	<div class="estatebud-content-panel">
		<div class="estatebud-content-panel-title">
			Brochure
		</div>
		<div class="estatebud-content-panel-content">
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Template</div>
				</div>
				<select class="estatebud-choices-select" id="project_brochure_template_id" name="brochure_template_id">
					<option value="">None</option>
					<?php foreach ($pdf_template_list as $pdf_template): ?>
						<option value=<?php echo esc_attr($pdf_template['id']); ?><?php echo $option_values['brochure_template_id'] ==
 $pdf_template['id']
     ? ' selected'
     : ''; ?>><?php echo esc_html($pdf_template['name']); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Show agent</div>
				</div>
				<div class="estatebud-radio-group">
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_brochure_show_agent_1" class="estatebud-radio-option" name="brochure_show_agent" value="1"<?php echo $option_values[
          'brochure_show_agent'
      ] == true
          ? ' checked'
          : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_brochure_show_agent_1">Enable</label>
					</div>
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_brochure_show_agent_0" class="estatebud-radio-option" name="brochure_show_agent" value="0"<?php echo $option_values[
          'brochure_show_agent'
      ] == false
          ? ' checked'
          : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_brochure_show_agent_0">Disable</label>
					</div>
				</div>
			</div>
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">White label</div>
				</div>
				<div class="estatebud-radio-group">
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_brochure_white_label_1" class="estatebud-radio-option" name="brochure_white_label" value="1"<?php echo $option_values[
          'brochure_white_label'
      ] == true
          ? ' checked'
          : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_brochure_white_label_1">Enable</label>
					</div>
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_brochure_white_label_0" class="estatebud-radio-option" name="brochure_white_label" value="0"<?php echo $option_values[
          'brochure_white_label'
      ] == false
          ? ' checked'
          : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_brochure_white_label_0">Disable</label>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="estatebud-content-panel">
		<div class="estatebud-content-panel-title">
			Miscellaneous
		</div>
		<div class="estatebud-content-panel-content">
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Legal disclaimer</div>
				</div>
				<textarea name="legal_disclaimer" class="estatebud-textarea-field"><?php echo esc_textarea($option_values['legal_disclaimer']); ?></textarea>
			</div>
		</div>
	</div>
</div>