<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Models\Settings as ConfigSettings;
use EstatebudConnect\Models\Forms;
use EstatebudConnect\Configs\Icons;

$settings_values = ConfigSettings::instance()->get_data();
$api_key = ConfigSettings::instance()->get_api_key(true);

$form_data = Forms::instance()->get_all_forms();

$contact_forms = array_values(
    array_filter($form_data, function ($form) {
        return $form['type'] == 'contact';
    }),
);

$icon_exclamation = Icons::get_svg_icon(
    'circle-exclamation',
    Icons::SHAPE_SHARP,
    Icons::STYLE_SOLID,
    14,
    14,
    '#E03131',
);
?>
	<div class="estatebud-sidebar-content-body-scrollable">
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				General
			</div>
			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Estatebud API key</div>
					</div>
					<input type="text" id="estatebud_api_key" name="estatebud_api_key" value="<?php echo esc_attr($api_key); ?>">
				</div>
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Currencies</div>
					</div>
					<select class="estatebud-choices-multi-select" id="currencies" name="currencies[]" multiple>
                        <?php foreach ($currencies as $key => $value): ?>
                            <option value="<?php echo esc_attr($key); ?>"<?php echo !empty($settings_values['currencies']) && in_array($key, $settings_values['currencies']) ? ' selected' : ''; ?>><?php echo esc_html($value); ?></option>
                        <?php endforeach; ?>
					</select>
				</div>
				<div class="sep"></div>
			</div>
		</div>
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				Favorites
			</div>
			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Favorites</div>
					</div>
					<div class="estatebud-radio-group">
						<div class="estatebud-radio-option-container">
							<input type="radio" id="estatebud_favorites_1" class="estatebud-radio-option" name="favorites" value="1"<?php echo $settings_values['favorites'] == true ? ' checked' : ''; ?>>
							<label class="estate-radio-option-label" for="estatebud_favorites_1">Enable</label>
						</div>
						<div class="estatebud-radio-option-container">
							<input type="radio" id="estatebud_favorites_0" class="estatebud-radio-option" name="favorites" value="0"<?php echo $settings_values['favorites'] == false ? ' checked' : ''; ?>>
							<label class="estate-radio-option-label" for="estatebud_favorites_0">Disable</label>
						</div>
					</div>
				</div>

				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Contact form</div>
					</div>
					<select class="estatebud-choices-select" id="favorites_contact_form" name="favorites_contact_form">
						<option value="">None</option>
						<?php foreach ($contact_forms as $form): ?>
							<option value="<?php echo esc_attr($form['id']); ?>"<?php echo $settings_values['favorites_contact_form'] == $form['id'] ? ' selected' : ''; ?>>
								<?php echo esc_html($form['name']); ?>
							</option>
						<?php endforeach; ?>
					</select>
				</div>
			</div>
			<div class="sep"></div>
		</div>
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				Maps
			</div>
			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Provider</div>
					</div>
					<select class="estatebud-choices-select" id="map_provider" name="map_provider">
						<option value=""<?php echo empty($settings_values['map_provider']) ? ' selected' : ''; ?>>None</option>
						<option value="openstreetmap"<?php echo $settings_values['map_provider'] == 'openstreetmap' ? ' selected' : ''; ?>>OpenStreetMap</option>
						<option value="openfreemap"<?php echo $settings_values['map_provider'] == 'openfreemap' ? ' selected' : ''; ?>>OpenFreeMap</option>
						<option value="google"<?php echo $settings_values['map_provider'] == 'google' ? ' selected' : ''; ?>>Google Maps</option>
						<option value="mapbox"<?php echo $settings_values['map_provider'] == 'mapbox' ? ' selected' : ''; ?>>Mapbox</option>
					</select>
				</div>

				<div class="estatebud-field-group" id="map_access_token_wrapper">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Access token</div>
					</div>
					<input type="text" id="map_access_token" name="map_access_token" value="<?php echo esc_attr($settings_values['map_access_token']); ?>">
				</div>

				<div class="estatebud-field-group" id="mapbox_style" style="display: none;">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Mapbox style</div>
					</div>
					<input type="text" id="mapbox_style" name="mapbox_style" value="<?php echo esc_attr($settings_values['mapbox_style']); ?>">
				</div>
			</div>
			<div class="sep"></div>
		</div>
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				Captcha
			</div>
			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Provider</div>
					</div>
					<select class="estatebud-choices-select" id="captcha_provider" name="captcha_provider">
						<option value=""<?php echo empty($settings_values['captcha_provider']) ? ' selected' : ''; ?>>None</option>
						<option value="recaptcha"<?php echo $settings_values['captcha_provider'] == 'recaptcha' ? ' selected' : ''; ?>>Google reCAPTCHA</option>
						<option value="turnstile"<?php echo $settings_values['captcha_provider'] == 'turnstile' ? ' selected' : ''; ?>>Cloudflare Turnstile</option>
						<option value="hcaptcha"<?php echo $settings_values['captcha_provider'] == 'hcaptcha' ? ' selected' : ''; ?>>hCaptcha</option>
					</select>
				</div>
				<div class="estatebud-field-group" id="captcha_site_key_wrapper">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Site key</div>
					</div>
					<input type="text" id="captcha_site_key" name="captcha_site_key" value="<?php echo esc_attr($settings_values['captcha_site_key']); ?>">
				</div>
				<div class="estatebud-field-group" id="captcha_secret_key_wrapper">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Secret key</div>
					</div>
					<input type="text" id="captcha_secret_key" name="captcha_secret_key" value="<?php echo esc_attr($settings_values['captcha_secret_key']) ?>">
				</div>
			</div>
			<div class="sep"></div>
		</div>
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				Look & feel
			</div>
			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Branding color</div>
					</div>
					<input type="color" value="<?php echo esc_attr($settings_values['branding_color']); ?>" class="color-palette" name="branding_color">
				</div>

				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Edge style</div>
					</div>
					<select class="estatebud-choices-select" id="edge_style" name="edge_style">
						<option value="sharp"<?php echo $settings_values['edge_style'] == 'sharp' ? ' selected' : ''; ?>>Sharp</option>
						<option value="round"<?php echo $settings_values['edge_style'] == 'round' ? ' selected' : ''; ?>>Round</option>
						<option value="circle"<?php echo $settings_values['edge_style'] == 'circle' ? ' selected' : ''; ?>>Circle</option>
					</select>
				</div>

				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Field style</div>
					</div>
					<select class="estatebud-choices-select" id="field_style" name="field_style">
						<option value="sharp"<?php echo $settings_values['field_style'] == 'sharp' ? ' selected' : ''; ?>>Sharp</option>
						<option value="round"<?php echo $settings_values['field_style'] == 'round' ? ' selected' : ''; ?>>Round</option>
						<option value="circle"<?php echo $settings_values['field_style'] == 'circle' ? ' selected' : ''; ?>>Circle</option>
					</select>
				</div>

				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Button style</div>
					</div>
					<select class="estatebud-choices-select" id="button_style" name="button_style">
						<option value="sharp"<?php echo $settings_values['button_style'] == 'sharp' ? ' selected' : ''; ?>>Sharp</option>
						<option value="round"<?php echo $settings_values['button_style'] == 'round' ? ' selected' : ''; ?>>Round</option>
						<option value="circle"<?php echo $settings_values['button_style'] == 'circle' ? ' selected' : ''; ?>>Circle</option>
					</select>
				</div>
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Icon style</div>
					</div>
					<select class="estatebud-choices-select" id="icon_style" name="icon_style">
						<option value="solid"<?php echo $settings_values['icon_style'] == 'solid' ? ' selected' : ''; ?>>Solid</option>
						<option value="regular"<?php echo $settings_values['icon_style'] == 'regular' ? ' selected' : ''; ?>>Regular</option>
					</select>
				</div>
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Icon type</div>
					</div>
					<select class="estatebud-choices-select" id="icon_type" name="icon_type">
						<option value="sharp"<?php echo $settings_values['icon_type'] == 'sharp' ? ' selected' : ''; ?>>Sharp</option>
						<option value="round"<?php echo $settings_values['icon_type'] == 'round' ? ' selected' : ''; ?>>Round</option>
					</select>
				</div>
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Link opening behavior</div>
					</div>
					<select class="estatebud-choices-select" id="link_opening_behavior" name="link_opening_behavior">
						<option value="current_tab"<?php echo $settings_values['link_opening_behavior'] == 'current_tab' ? ' selected' : ''; ?>>Current tab</option>
						<option value="new_tab"<?php echo $settings_values['link_opening_behavior'] == 'new_tab' ? ' selected' : ''; ?>>New tab</option>
					</select>
				</div>
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Powered by</div>
					</div>
					<div class="estatebud-radio-group">
						<div class="estatebud-radio-option-container">
							<input type="radio" id="estatebud_powered_by_1" class="estatebud-radio-option" name="powered_by" value="1"<?php echo $settings_values['powered_by'] == true ? ' checked' : ''; ?>>
							<label class="estate-radio-option-label" for="estatebud_powered_by_1">Enable</label>
						</div>
						<div class="estatebud-radio-option-container">
							<input type="radio" id="estatebud_powered_by_0" class="estatebud-radio-option" name="powered_by" value="0"<?php echo $settings_values['powered_by'] == false ? ' checked' : ''; ?>>
							<label class="estate-radio-option-label" for="estatebud_powered_by_0">Disable</label>
						</div>
					</div>
				</div>
			</div>
			<div class="sep"></div>
		</div>
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				Sharing
			</div>
			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Providers</div>
					</div>
					<select class="estatebud-choices-multi-select" id="sharing_providers" name="sharing_providers[]" multiple>
					<?php foreach(\EstatebudConnect\Configs\Sharing::PROVIDERS as $key => $provider): ?>
						<option value="<?php echo esc_attr($key); ?>"<?php echo in_array($key, $settings_values['sharing_providers'] ?? []) ? ' selected' : ''; ?>><?php echo esc_html($provider['label']); ?></option>
					<?php endforeach; ?>
					</select>
				</div>
			</div>
			<div class="sep"></div>
		</div>
		<div class="estatebud-content-panel">
			<div class="estatebud-content-panel-title">
				Advanced
			</div>

			<div class="estatebud-content-panel-exclamation">
				<?php echo wp_kses($icon_exclamation, Icons::get_kses_ruleset()); ?>
				Warning! The following settings are for advanced users only, use with caution.
			</div>

			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">IP address lookup</div>
				</div>
				<div class="estatebud-radio-group">
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_ip_lookup_1" class="estatebud-radio-option" name="ip_lookup" value="1"<?php echo $settings_values['ip_lookup'] == true ? ' checked' : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_ip_lookup_1">Enable</label>
					</div>
					<div class="estatebud-radio-option-container">
						<input type="radio" id="estatebud_ip_lookup_0" class="estatebud-radio-option" name="ip_lookup" value="0"<?php echo $settings_values['ip_lookup'] == false ? ' checked' : ''; ?>>
						<label class="estate-radio-option-label" for="estatebud_ip_lookup_0">Disable</label>
					</div>
				</div>
			</div>
			
			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Release tier</div>
				</div>
				<select class="estatebud-choices-select" id="release_tier" name="release_tier">
					<option value="release"<?php echo $settings_values['release_tier'] == 'release' ? ' selected' : ''; ?>>Release</option>
					<option value="pre_release"<?php echo $settings_values['release_tier'] == 'pre_release' ? ' selected' : ''; ?>>Pre-release</option>
					<option value="beta"<?php echo $settings_values['release_tier'] == 'beta' ? ' selected' : ''; ?>>Beta</option>
					<option value="alpha"<?php echo $settings_values['release_tier'] == 'alpha' ? ' selected' : ''; ?>>Alpha</option>
				</select>
			</div>

			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Log level</div>
				</div>
				<select class="estatebud-choices-select" id="log_level" name="log_level">
					<option value="off"<?php echo $settings_values['log_level'] == 'off' ? ' selected' : ''; ?>>Off</option>
					<option value="debug"<?php echo $settings_values['log_level'] == 'debug' ? ' selected' : ''; ?>>Debug</option>
				</select>
			</div>

			<div class="estatebud-field-group">
				<div class="estatebud-field-label">
					<div class="estatebud-field-label-content">Cache</div>
				</div>
				<button type="button" class="estatebud-save-button estatebud-button-outline" id="purge-cache-button">
					<div class="estatebud-button-title">Purge cache</div>
				</button>
			</div>

			<div class="estatebud-content-panel-content">
				<div class="estatebud-field-group ace-editor-field">
					<div class="estatebud-field-label">
						<div class="estatebud-field-label-content">Custom CSS</div>
					</div>
					<div class="estatebud-ace-editor">
						<pre id="custom_css_editor"><?php echo esc_textarea($settings_values['custom_css'] ?? ''); ?></pre>
					</div>
				</div>
			</div>
		</div>
    </div>