<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Icons;
use EstatebudConnect\Utilities\Helper;

$icon_plus = Icons::get_svg_icon('plus', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');

if (!isset($options)) {
    $options = [];
}

$pages = get_pages();

if (!$pages) {
    $pages = [];
}
$is_button_enabled = filter_var($is_button_available ?? false, FILTER_VALIDATE_BOOLEAN);
?>

<div class="estatebud-modal-wrapper">
    <form class="estatebud-modal estatebud-modal-general-form" name="modal-general-form">
        <?php Helper::render_markup_from_views('Admin/modal/modal-header.php', [
            'modal_title' => $id ? 'Update form' : 'Create form',
        ]); ?>
        <div class="etatebude-modal-content">
            <div class="estatebud-modal-content-panel">
                <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                    'panel_title' => 'Settings',
                ]); ?>
                <div class="estatebud-modal-content-panel">
                    <div class="estatebud-field-group">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Name',
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                            'value' => $name ?? '',
                            'variable_name' => 'name',
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Type',
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'extra_class' => 'module-field-forms-tab form-type-selector',
                            'variable_name' => 'type',
                            'options' => [
                                [
                                    'value' => '',
                                    'disabled' => true,
                                    'selected' => true,
                                    'label' => 'Any',
                                ],
                                [
                                    'value' => 'property-search',
                                    'disabled' => false,
                                    'selected' => $type == 'property-search',
                                    'label' => 'Property search',
                                ],
                                [
                                    'value' => 'project-search',
                                    'disabled' => false,
                                    'selected' => $type == 'project-search',
                                    'label' => 'Project search',
                                ],
                                [
                                    'value' => 'contact',
                                    'disabled' => false,
                                    'selected' => $type == 'contact',
                                    'label' => 'Contact',
                                ],
                            ],
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485" style="<?php echo ($type && $type == 'contact') ? 'display: flex' : 'display: none'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Transfer to pipeline',
                            ]); ?>
                        </div>
                        <?php
                        if (isset($pipeline_options) && is_array($pipeline_options)) {
                            foreach ($pipeline_options as &$option) {
                                if (isset($option['is_optgroup']) && $option['is_optgroup']) {
                                    if (isset($option['options']) && is_array($option['options'])) {
                                        foreach ($option['options'] as &$sub_option) {
                                            $sub_option['selected'] =
                                                isset($pipeline_stage_id) &&
                                                $sub_option['value'] == $pipeline_stage_id;
                                        }
                                        unset($sub_option);
                                    }
                                } else {
                                    $option['selected'] =
                                        isset($pipeline_stage_id) && $option['value'] == $pipeline_stage_id;
                                }
                            }
                            unset($option);
                        }

                        Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'variable_name' => 'pipeline_stage_id',
                            'extra_class' => 'transfer-pipeline',
                            'options' => $pipeline_options ?? [
                                [
                                    'value' => '',
                                    'disabled' => false,
                                    'selected' => false,
                                    'label' => 'None',
                                ],
                            ],
                        ]);
                        ?>
                    </div>
                </div>
                <div class="sep"></div>
            </div>

            <div class="estatebud-modal-content-panel modal-form-group-property">
                <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                    'panel_title' => 'Form',
                ]); ?>
                <div class="field-group-wrapper">

                <?php
                if (is_string($fields)) {
                    $fields = json_decode($fields, true);
                }
                if (is_array($fields)):
                    foreach ($fields as $index => $field): ?>
                        <div class="modal-form-group" draggable="true" name="draggable" id="<?php echo esc_attr('draggable-' . $index); ?>">
                            <?php Helper::render_markup_from_views('Admin/partials/field-settings.php', [
                                'fields' => $fields,
                                'field' => $field,
                                'options' => $options,
                                'type' => $type,
                                'client_field_labels' => $client_field_labels ?? [],
                            ]); ?>
                        </div>
	                <?php endforeach;
                else:
                    echo 'Invalid fields data.';
                endif;
                ?>
                </div>
                <button class="estatebud-modal-button-variation-2">
                    <?php echo wp_kses($icon_plus, Icons::get_kses_ruleset()); ?>
                    <p class="estatebud-button-title">Add item</p>
                </button>
            </div>

            <div class="estatebud-modal-content-panel">
                <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                    'panel_title' => 'Button',
                ]); ?>
                <div class="estatebud-modal-content-panel">
                    <div class="estatebud-field-group estatebud-button-wrapper">
                        <?php Helper::render_markup_from_views('Admin/partials/toggle-button.php', [
                            'variable_name' => 'is_button_available',
                            'default_checked' => true,
                            'value' => $is_button_enabled,
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485 form-button-option" style="<?php echo $is_button_enabled
                        ? 'display: flex'
                        : 'display: none'; ?>"?>
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Label',
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                            'value' => $button_label,
                            'variable_name' => 'button_label',
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485 form-button-option" style="<?php echo $is_button_enabled
                        ? 'display: flex'
                        : 'display: none'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Icon',
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'extra_class' => 'icon',
                            'variable_name' => 'button_icon_type',
                            'options' => [
                                [
                                    'value' => '',
                                    'disabled' => false,
                                    'selected' => $button_icon_type == 'none',
                                    'label' => 'None',
                                ],
                                [
                                    'value' => 'arrow-right',
                                    'disabled' => false,
                                    'selected' => $button_icon_type == 'arrow-right',
                                    'label' => 'arrow-right',
                                ],
                                [
                                    'value' => 'arrow-long-right',
                                    'disabled' => false,
                                    'selected' => $button_icon_type == 'arrow-long-right',
                                    'label' => 'arrow-long-right',
                                ],
                                [
                                    'value' => 'paper-plane',
                                    'disabled' => false,
                                    'selected' => $button_icon_type == 'paper-plane',
                                    'label' => 'paper-plane',
                                ],
                                [
                                    'value' => 'paper-plane-top',
                                    'disabled' => false,
                                    'selected' => $button_icon_type == 'paper-plane-top',
                                    'label' => 'paper-plane-top',
                                ],
                            ],
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485 form-button-option" style="<?php echo $is_button_enabled
                        ? 'display: flex'
                        : 'display: none'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Icon position',
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'extra_class' => 'icon-position',
                            'variable_name' => 'button_icon_position',
                            'options' => [
                                [
                                    'value' => 'right',
                                    'disabled' => false,
                                    'selected' => $button_icon_position == 'right',
                                    'label' => 'Right',
                                ],
                                [
                                    'value' => 'left',
                                    'disabled' => false,
                                    'selected' => $button_icon_position == 'left',
                                    'label' => 'Left',
                                ],
                            ],
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485 form-button-option" style="<?php echo $is_button_enabled &&
                    isset($type) &&
                    $type == 'contact'
                        ? 'display: flex'
                        : 'display: none'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Column width',
                            ]); ?>
                        </div>
                        <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                            'extra_class' => 'column-width',
                            'variable_name' => 'button_width',
                            'options' => [
                                [
                                    'value' => '',
                                    'disabled' => false,
                                    'selected' => empty($button_width),
                                    'label' => 'Auto',
                                ],
                                [
                                    'value' => '20',
                                    'disabled' => false,
                                    'selected' => $button_width == '20',
                                    'label' => '20%',
                                ],
                                [
                                    'value' => '25',
                                    'disabled' => false,
                                    'selected' => $button_width == '25',
                                    'label' => '25%',
                                ],
                                [
                                    'value' => '30',
                                    'disabled' => false,
                                    'selected' => $button_width == '30',
                                    'label' => '30%',
                                ],
                                [
                                    'value' => '33',
                                    'disabled' => false,
                                    'selected' => $button_width == '33',
                                    'label' => '33%',
                                ],
                                [
                                    'value' => '40',
                                    'disabled' => false,
                                    'selected' => $button_width == '40',
                                    'label' => '40%',
                                ],
                                [
                                    'value' => '50',
                                    'disabled' => false,
                                    'selected' => $button_width == '50',
                                    'label' => '50%',
                                ],
                                [
                                    'value' => '60',
                                    'disabled' => false,
                                    'selected' => $button_width == '60',
                                    'label' => '60%',
                                ],
                                [
                                    'value' => '66',
                                    'disabled' => false,
                                    'selected' => $button_width == '66',
                                    'label' => '66%',
                                ],
                                [
                                    'value' => '70',
                                    'disabled' => false,
                                    'selected' => $button_width == '70',
                                    'label' => '70%',
                                ],
                                [
                                    'value' => '75',
                                    'disabled' => false,
                                    'selected' => $button_width == '75',
                                    'label' => '75%',
                                ],
                                [
                                    'value' => '80',
                                    'disabled' => false,
                                    'selected' => $button_width == '80',
                                    'label' => '80%',
                                ],
                                [
                                    'value' => '100',
                                    'disabled' => false,
                                    'selected' => $button_width == '100',
                                    'label' => '100%',
                                ],
                            ],
                        ]); ?>
                    </div>
                    <div class="estatebud-field-group estatebud-width-485 form-button-option" style="<?php echo $is_button_enabled
                        ? 'display: flex'
                        : 'display: none'; ?>">
                        <div class="estatebud-field-label">
                            <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                'field_label' => 'Destination page',
                            ]); ?>
                        </div>
                            <?php
                            $destination_page_options = [
                                [
                                    'value' => '',
                                    'disabled' => false,
                                    'selected' => false,
                                    'label' => 'None',
                                ],
                            ];

                            foreach ($pages as $page) {
                                $destination_page_options[] = [
                                    'value' => $page->ID,
                                    'disabled' => false,
                                    'selected' => $page->ID == $button_destination_page,
                                    'label' => $page->post_title,
                                ];
                            }
                            ?>
                            <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                                'extra_class' => 'destination-page',
                                'variable_name' => 'button_destination_page',
                                'options' => $destination_page_options,
                            ]); ?>
                    </div>
                </div>
                <div class="sep"></div>
            </div>

            <?php if ($type && $type == 'contact'): ?>
                <div class="estatebud-modal-content-panel group-1">
                    <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                        'panel_title' => 'Notification email',
                    ]); ?>
                    <div class="estatebud-modal-content-panel">
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'To',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_to,
                                'variable_name' => 'email_to',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Subject',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_subject,
                                'variable_name' => 'email_subject',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Message',
                                ]); ?>
                            </div>
                            <div class="estatebud-textarea-field-group">
                                <?php Helper::render_markup_from_views('Admin/partials/textarea-field.php', [
                                    'variable_name' => 'email_message',
                                    'rows' => 5,
                                    'cols' => 67,
                                    'textarea_content' => $email_message,
                                ]); ?>
                                <p>Add individual fields using their shortcode, or use enter <span class="estatebud-monospace-tag">{{ form.fields }}</span> to list all fields.</p>
                            </div>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'From email',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_from,
                                'variable_name' => 'email_from',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'From name',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_from_name,
                                'variable_name' => 'email_from_name',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Reply-to',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_reply_to,
                                'variable_name' => 'email_reply_to',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Cc',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_cc,
                                'variable_name' => 'email_cc',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Bcc',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $email_bcc,
                                'variable_name' => 'email_bcc',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Meta data',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/select-field.php', [
                                'extra_class' => 'multiselect',
                                'multiple' => true,
                                'variable_name' => 'email_meta_data[]',
                                'options' => [
                                    [
                                        'value' => '',
                                        'disabled' => true,
                                        'selected' => false,
                                        'label' => 'Any',
                                    ],
                                    [
                                        'value' => 'date',
                                        'disabled' => false,
                                        'selected' => in_array('date', $email_meta_data),
                                        'label' => 'Date',
                                    ],
                                    [
                                        'value' => 'time',
                                        'disabled' => false,
                                        'selected' => in_array('time', $email_meta_data),
                                        'label' => 'Time',
                                    ],
                                    [
                                        'value' => 'ip',
                                        'disabled' => false,
                                        'selected' => in_array('ip', $email_meta_data),
                                        'label' => 'IP',
                                    ],
                                    [
                                        'value' => 'browser',
                                        'disabled' => false,
                                        'selected' => in_array('browser', $email_meta_data),
                                        'label' => 'Browser',
                                    ],
                                    [
                                        'value' => 'page_url',
                                        'disabled' => false,
                                        'selected' => in_array('page_url', $email_meta_data),
                                        'label' => 'Page url',
                                    ],
                                ],
                            ]); ?>
                        </div>
                    </div>
                    <div class="sep"></div>
                </div>

                <div class="estatebud-modal-content-panel group-2">
                    <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                        'panel_title' => 'Confirmation email',
                    ]); ?>
                    <div class="estatebud-modal-content-panel">
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Subject',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $confirmation_email_subject,
                                'variable_name' => 'confirmation_email_subject',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Message',
                                ]); ?>
                            </div>
                            <div class="estatebud-textarea-field-group">
                                <?php Helper::render_markup_from_views('Admin/partials/textarea-field.php', [
                                    'variable_name' => 'confirmation_email_message',
                                    'rows' => 5,
                                    'cols' => 67,
                                    'textarea_content' => $confirmation_email_message,
                                ]); ?>
                            </div>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'From email',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $confirmation_email_from,
                                'variable_name' => 'confirmation_email_from',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'From name',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $confirmation_email_from_name,
                                'variable_name' => 'confirmation_email_from_name',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Reply-to',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $confirmation_email_reply_to,
                                'variable_name' => 'confirmation_email_reply_to',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Cc',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $confirmation_email_cc,
                                'variable_name' => 'confirmation_email_cc',
                            ]); ?>
                        </div>
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Bcc',
                                ]); ?>
                            </div>
                            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                                'value' => $confirmation_email_bcc,
                                'variable_name' => 'confirmation_email_bcc',
                            ]); ?>
                        </div>
                    </div>
                    <div class="sep"></div>
                </div>

                <div class="estatebud-modal-content-panel group-3">
                    <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                        'panel_title' => 'Miscellaneous',
                    ]); ?>
                    <div class="estatebud-modal-content-panel">
                        <div class="estatebud-field-group estatebud-width-485">
                            <div class="estatebud-field-label">
                                <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
                                    'field_label' => 'Privacy policy',
                                ]); ?>
                            </div>
                            <?php
                            $privacy_policy_options = [
                                [
                                    'value' => '',
                                    'label' => 'None',
                                    'selected' =>
                                        (isset($privacy_policy_page_id) && $privacy_policy_page_id === '') ||
                                        !isset($privacy_policy_page_id),
                                ],
                            ];

                            foreach ($pages as $page) {
                                $privacy_policy_options[] = [
                                    'value' => $page->ID,
                                    'label' => $page->post_title,
                                    'selected' =>
                                        isset($privacy_policy_page_id) && $page->ID == $privacy_policy_page_id,
                                ];
                            }

                            Helper::render_markup_from_views('Admin/partials/select-field.php', [
                                'variable_name' => 'privacy_policy_page_id',
                                'extra_class' => 'privacy-policy',
                                'options' => $privacy_policy_options,
                            ]);
                            ?>
                        </div>
                    </div>
                    <div class="sep"></div>
                </div>
            <?php endif; ?>


            <div class="estatebud-modal-content-panel conversion-tracking">
                <?php Helper::render_markup_from_views('Admin/modal/partials/modal-content-panel-title.php', [
                    'panel_title' => 'Conversion',
                ]); ?>
                <div class="estatebud-conversion-tracking">
                    <?php Helper::render_markup_from_views('Admin/partials/accordion.php', [
                        'accordion_title' => 'Google Ads',
                        'variable_name' => 'google_ads_id',
                        'value' => $google_ads_id,
                    ]); ?>
                    <?php Helper::render_markup_from_views('Admin/partials/accordion.php', [
                        'accordion_title' => 'Google Analytics',
                        'variable_name' => 'google_anaytics_id',
                        'value' => $google_anaytics_id,
                    ]); ?>
                    <?php Helper::render_markup_from_views('Admin/partials/accordion.php', [
                        'accordion_title' => 'Meta',
                        'variable_name' => 'meta_id',
                        'value' => $meta_id,
                    ]); ?>
                </div>
            </div>
            <div style = "display:none">
                <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                    'value' => $id,
                    'variable_name' => 'id',
                ]); ?>
            </div>
            <div class="sep"></div>
        </div>
        <?php Helper::render_markup_from_views('Admin/modal/modal-footer.php'); ?>
    </form>
</div>