<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Configs\Icons;

$icon_chevron_down = Icons::get_svg_icon('chevron-down', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 14, 14, '#6B6B6B');
?>
<div class="estatebud-accordion">
    <div class="accordion-title-group">
        <?php Helper::render_markup_from_views('Admin/partials/field-label.php', [
            'field_label' => $accordion_title ?? '',
        ]); ?>
        <?php echo wp_kses($icon_chevron_down, Icons::get_kses_ruleset()); ?>
    </div>
    <div class="accordion-dropdown-group" style="display: none;">
        <div class="accordion-dropdown-group-secondary">
            <div class="accordion-id-group">
                <p>ID</p>
            </div>
            <?php Helper::render_markup_from_views('Admin/partials/text-field.php', [
                'extra_class' => 'accordion-text-field',
                'variable_name' => $variable_name,
                'value' => $value ?? '',
            ]); ?>
        </div>
    </div>
</div>
