<?php
if (!defined('WPINC')) {
    die();
}

$default_class = 'estatebud-field-select';
$id = 'estatebud-field-select';

if (isset($extra_class) && !empty($extra_class)) {
    $default_class .= ' ' . $extra_class;
}

if (isset($extra_id) && !empty($extra_id)) {
    $id .= ' ' . $extra_id;
}
?>

<select class="<?php echo esc_attr($default_class); ?>" id="<?php echo esc_attr($id); ?>" name="<?php echo esc_attr($variable_name ?? ''); ?>"<?php echo isset(
    $multiple,
)
    ? ' multiple'
    : ''; ?>>
    <?php foreach ($options ?? [] as $option): ?>
        <?php if (isset($option['is_optgroup']) && $option['is_optgroup']): ?>
            <optgroup label="<?php echo isset($option['label'])
                ? esc_attr($option['label'])
                : ''; ?>">
                <?php if (isset($option['options']) && is_array($option['options'])): ?>
                    <?php foreach ($option['options'] as $sub_option): ?>
                        <option
                            value="<?php echo isset($sub_option['value'])
                                ? esc_attr($sub_option['value'])
                                : ''; ?>"
                            <?php echo isset($sub_option['disabled']) && $sub_option['disabled']
                                ? ' disabled="disabled"'
                                : ''; ?>
                            <?php echo isset($sub_option['selected']) && $sub_option['selected']
                                ? ' selected="selected"'
                                : ''; ?>
                        >
                            <?php echo isset($sub_option['label'])
                                ? esc_html($sub_option['label'], ENT_QUOTES, 'UTF-8')
                                : ''; ?>
                        </option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </optgroup>
        <?php else: ?>
            <option
                value="<?php echo isset($option['value'])
                    ? esc_attr($option['value'])
                    : ''; ?>"
                <?php echo isset($option['disabled']) && $option['disabled'] ? ' disabled="disabled"' : ''; ?>
                <?php echo isset($option['selected']) && $option['selected'] ? ' selected="selected"' : ''; ?>
            >
                <?php echo isset($option['label']) ? esc_html($option['label']) : ''; ?>
            </option>
        <?php endif; ?>
    <?php endforeach; ?>
</select>