<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Configs\Icons;

if (!isset($settings_data)) {
    $settings_data = [];
}
$setting = $settings_data;
extract($setting);

if (!isset($currency_rate)) {
    $currency_rate = [];
}

$icon_percent = Icons::get_svg_icon('percent', $icon_type, 'regular', 16, 16, '#B8B8B8');

if ($listing->get_price()) {
    $user_session = Helper::get_user_session();
    $currency = strtoupper($user_session['currency'] ?? $listing->get_price()['currency']);

    $currency_data = Helper::get_currency_data($listing->get_price()['currency'], $currency);
    $currency_symbol = $currency_data['symbol'];

    $base_currency_data = array_merge($currency_data, [
        'currency' => $listing->get_price()['currency'],
        'symbol' => $listing->get_price()['symbol'],
        'rate' => 1
    ]);

    $purchase_price = $listing->get_price()['price'];
    $purchase_price_converted = round(($purchase_price * $currency_data['rate']) / 100) * 100;

    $down_payment = $purchase_price * 0.2;
    $down_payment_converted = $purchase_price_converted * 0.2;

    $mortgage_amount = $purchase_price - $down_payment;
    $mortgage_amount_converted = $purchase_price_converted - $down_payment_converted;

    $interest_rate = 3 / 1200;
    $period = 30 * 12;

    $monthly_repayment =
        ($mortgage_amount * ($interest_rate * (1 + $interest_rate) ** $period)) / ((1 + $interest_rate) ** $period - 1);
    $monthly_repayment_converted =
        ($mortgage_amount_converted * ($interest_rate * (1 + $interest_rate) ** $period)) /
        ((1 + $interest_rate) ** $period - 1);
}
?>
<div class="estatebud-listing-mortgage-calculator">
    <h3 class="estatebud-listing-mortgage-heading"><?php echo esc_html(Helper::term('mortgage_calculator.title')); ?></h3>
    <div class="estatebud-listing-mortgage-group">
        <div class="estatebud-listing-mortgage-sub-group">
            <div class="estatebud-listing-mortgage-field-container">
                <label class="estatebud-listing-mortgage-field-label"><?php echo esc_html(Helper::term('mortgage_calculator.purchase_price')); ?></label>
                <div class="estatebud-listing-mortgage-field-content">
                    <label class="estatebud-listing-mortgage-field-icon" for="estatebud_purchase_price"><?php echo esc_html($currency_symbol); ?></label>
                    <?php Helper::render_markup_from_views('Public/partials/components/fields/input.php', [
                        'type' => 'text',
                        'value' => number_format(
                            $purchase_price_converted,
                            0,
                            $currency_data['decimal_separator'] ?? '',
                            $currency_data['thousand_separator'] ?? ''
                        ),
                        'name' => 'estatebud_purchase_price',
                        'id' => 'estatebud_purchase_price',
                    ]); ?>
                    <?php Helper::render_markup_from_views('Public/partials/components/fields/input.php', [
                        'type' => 'text',
                        'value' => number_format(
                            $purchase_price,
                            0,
                            $currency_data['decimal_separator'] ?? '',
                            $currency_data['thousand_separator'] ?? ''
                        ),
                        'name' => 'estatebud_base_purchase_price',
                        'extra_class' => 'estatebud-hidden',
                    ]); ?>
                </div>
            </div>

            <div class="estatebud-listing-mortgage-field-container">
                <label class="estatebud-listing-mortgage-field-label"><?php echo esc_html(Helper::term('mortgage_calculator.down_payment')); ?></label>
                <div class="estatebud-listing-mortgage-field-content">
                    <label class="estatebud-listing-mortgage-field-icon" for="estatebud_down_payment"><?php echo esc_html($currency_symbol); ?></label>
                    <?php Helper::render_markup_from_views('Public/partials/components/fields/input.php', [
                        'type' => 'text',
                        'value' => number_format(
                            $down_payment_converted,
                            0,
                            $currency_data['decimal_separator'] ?? '',
                            $currency_data['thousand_separator'] ?? ''
                        ),
                        'name' => 'estatebud_down_payment',
                        'id' => 'estatebud_down_payment',
                    ]); ?>
                    <?php Helper::render_markup_from_views('Public/partials/components/fields/input.php', [
                        'type' => 'text',
                        'value' => number_format(
                            $down_payment,
                            0,
                            $currency_data['decimal_separator'] ?? '',
                            $currency_data['thousand_separator'] ?? ''
                        ),
                        'name' => 'estatebud_base_down_payment',
                        'extra_class' => 'estatebud-hidden',
                    ]); ?>
                </div>
            </div>
        </div>

        <div class="estatebud-listing-mortgage-sub-group">
            <div class="estatebud-listing-mortgage-field-container">
                <label class="estatebud-listing-mortgage-field-label"><?php echo esc_html(Helper::term('mortgage_calculator.repayment_period')); ?></label>
                <?php Helper::render_markup_from_views('Public/partials/components/fields/select.php', [
                    'variable_name' => 'estatebud_repayment_period',
                    'extra_class' => 'estatebud-listing-select-field',
                    'options' => [
                        ['value' => '5', 'label' => '5 years', 'selected' => false],
                        ['value' => '10', 'label' => '10 years', 'selected' => false],
                        ['value' => '15', 'label' => '15 years', 'selected' => false],
                        ['value' => '20', 'label' => '20 years', 'selected' => false],
                        ['value' => '25', 'label' => '25 years', 'selected' => false],
                        ['value' => '30', 'label' => '30 years', 'selected' => true],
                        ['value' => '35', 'label' => '35 years', 'selected' => false],
                        ['value' => '40', 'label' => '40 years', 'selected' => false]
                    ],
                    'multiple' => false
                ]); ?>
            </div>

            <div class="estatebud-listing-mortgage-field-container">
                <label class="estatebud-listing-mortgage-field-label"><?php echo esc_html(Helper::term('mortgage_calculator.interest_rate')); ?></label>
                <div class="estatebud-listing-mortgage-field-content">
                    <label class="estatebud-listing-mortgage-field-icon" for="estatebud_interest_rate"><?php echo wp_kses($icon_percent, Icons::get_kses_ruleset()); ?></label>
                    <?php Helper::render_markup_from_views('Public/partials/components/fields/input.php', [
                        'type' => 'text',
                        'value' => '3',
                        'name' => 'estatebud_interest_rate',
                        'id' => 'estatebud_interest_rate',
                    ]); ?>
                </div>
            </div>
        </div>

        <div class="estatebud-listing-mortgage-result<?php echo $monthly_repayment_converted ? '' : ' estatebud-hidden'; ?>">
            <label class="estatebud-listing-mortgage-result-heading"><?php echo esc_html(Helper::term('mortgage_calculator.monthly_repayment')); ?></label>
            <div class="estatebud-listing-mortgage-result-number">
                <?php echo esc_html(Helper::format_price(
                    ['price' => $monthly_repayment_converted, 'currency' => $listing->get_price()['currency']],
                    $currency_data
                )); ?>
            </div>
            <div class="estatebud-listing-mortgage-base-result-number estatebud-hidden">
                <?php echo esc_html(Helper::format_price(
                    ['price' => $monthly_repayment, 'currency' => $listing->get_price()['currency']],
                    $base_currency_data
                )); ?>
            </div>
        </div>
    </div>
</div>