<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Icons;

if (!isset($settings_data)) {
    $settings_data = [];
}
$setting = $settings_data;
extract($setting);

if (!isset($icon_type)) {
    $icon_type = Icons::SHAPE_SHARP;
}

if (!isset($icon_style)) {
    $icon_style = Icons::STYLE_SOLID;
}
?>
<div class="estatebud-listing-contact-wrapper">
    <?php if (!empty($avatar ?? '')): ?>
        <div class="estatebud-listing-contact-avatar">
            <img src="<?php echo esc_attr($avatar); ?>">
        </div>
    <?php endif; ?>
    <div class="estatebud-listing-contact-group">
        <div class="estatebud-listing-contact-title-group">
            <span class="estatebud-listing-contact-title-subject"><?php echo esc_html($name); ?></span>
        <?php if (!empty($title ?? '')): ?>
            <span class="estatebud-listing-contact-title-description"><?php echo esc_html($title); ?></span>
        <?php endif; ?>
        </div>
        <div class="estatebud-listing-contact-email-phone-group">
        <?php if (!empty($email ?? '')): ?>
            <a class="estatebud-listing-contact-email-group" href="mailto:<?php echo esc_attr($email); ?>">
                <?php echo wp_kses(Icons::get_svg_icon('envelope-open', $icon_type, $icon_style, 14, 14, $branding_color), Icons::get_kses_ruleset()); ?>
                <span class="estatebud-listing-contact-email"><?php echo esc_html($email); ?></span>
            </a>
        <?php endif; ?>
        <?php if (!empty($phone ?? '')): ?>
            <a class="estatebud-listing-contact-phone-group" href="tel:<?php echo esc_attr(str_replace(
                ['(', ')', ' '],
                '',
                $phone
            )); ?>">
                <?php echo wp_kses(Icons::get_svg_icon('phone', $icon_type, $icon_style, 14, 14, $branding_color), Icons::get_kses_ruleset()); ?>
                <span class="estatebud-listing-contact-phone"><?php echo esc_html($phone); ?></span>
            </a>
        <?php endif; ?>
        </div>
    </div>
</div>
