<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Configs\Icons;

$units = $listing->get_units();

if (!$units) {
    return;
}

$icon_dot_green = Icons::get_svg_icon('ellipse', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 12, 12, '#65A30D');
$icon_dot_yellow = Icons::get_svg_icon('ellipse', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 12, 12, '#D97706');
$icon_dot_red = Icons::get_svg_icon('ellipse', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 12, 12, '#DC2626');
?>
<div class="estatebud-listing-project-units-wrapper">
    <div class="estatebud-listing-project-units-header">
        <h3 class="estatebud-listing-project-units-header-title">
            <?php echo esc_html(Helper::term('listing.units.title')); ?>
        </h3>
        <div class="estatebud-listing-project-units-header-status-board">
            <div class="estatebud-status-label">
                <div class="estatebud-status-label-icon">
                    <?php echo wp_kses($icon_dot_green, Icons::get_kses_ruleset()); ?>
                </div>
                <div class="estatebud-status-label-title">
                    <?php echo esc_html(Helper::term('listing.units.legend.available')); ?>
                </div>
            </div>

            <div class="estatebud-status-label">
                <div class="estatebud-status-label-icon">
                    <?php echo wp_kses($icon_dot_yellow, Icons::get_kses_ruleset()); ?>
                </div>
                <div class="estatebud-status-label-title">
                    <?php echo esc_html(Helper::term('listing.units.legend.reserved')); ?>
                </div>
            </div>

            <div class="estatebud-status-label">
                <div class="estatebud-status-label-icon">
                    <?php echo wp_kses($icon_dot_red, Icons::get_kses_ruleset()); ?>
                </div>
                <div class="estatebud-status-label-title">
                    <?php echo esc_html(Helper::term('listing.units.legend.sold')); ?>
                </div>
            </div>
        </div>
    </div>
    <?php foreach ($units as $item): ?>
    <div class="estatebud-units-table">
    <?php if (!empty($item['block_name'] ?? '')): ?>
        <div class="estatebud-units-table-title">
            <?php echo esc_html($item['block_name']); ?>
        </div>
    <?php endif; ?>
        <div class="estatebud-table-content">
            <div class="estatebud-units-table-header">
                <?php foreach ($item['header'] as $headerKey => $headerValue): ?>
                    <?php
                    $class = str_replace('.', '', $headerKey);
                    $class = str_replace(' ', '-', $class);
                    $class = strtolower($class);
                    ?>
                    <div class="estatebud-units-table-header-column estatebud-units-table-content-<?php echo esc_attr($class); ?>">
                        <?php echo esc_html($headerValue); ?>
                    </div>
                <?php endforeach; ?>
                <div class="estatebud-units-table-header-column estatebud-units-table-content-base-price" style="display: none;">
                    base_price
                </div>
            </div>
            <?php foreach ($item['units'] ?? [] as $row): ?>
                <div class="estatebud-units-table-body-row">
                    <?php foreach ($item['header'] as $headerKey => $headerValue): ?>
                        <?php
                        $class = str_replace('.', '', $headerKey);
                        $class = str_replace(' ', '-', $class);
                        $class = strtolower($class);
                        ?>
                        <div class="estatebud-units-table-body-column estatebud-units-table-content-<?php echo esc_attr($class); ?>">
                            <?php if ($headerKey == 'status') {
                                switch ($row[$headerKey]) {
                                    case 'available':
                                        $icon = wp_kses($icon_dot_green, Icons::get_kses_ruleset());
                                        break;
                                    case 'reserved':
                                        $icon = wp_kses($icon_dot_yellow, Icons::get_kses_ruleset());
                                        break;
                                    case 'sold':
                                        $icon = wp_kses($icon_dot_red, Icons::get_kses_ruleset());
                                        break;
                                } ?>
                            <div class="estatebud-units-table-body-column-icon"><?php echo wp_kses($icon, Icons::get_kses_ruleset()); ?></div>
                            <?php
                            } elseif ($headerKey == 'price') {
                                if (isset($row[$headerKey]) && $row[$headerKey]['price'] > 0) {
                                    echo esc_html(Helper::format_price($row[$headerKey]));
                                } else {
                                    echo '-';
                                }
                            } else {
                                echo esc_html($row[$headerKey]);
                            } ?>
                        </div>
                    <?php endforeach; ?>
                    <div class="estatebud-units-table-body-column estatebud-units-table-content-base-price" style="display: none;">
                        <?php echo esc_html($row[$headerKey]['price'] ?? '0'); ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endforeach; ?>
</div>