<?php
if (!defined('WPINC')) {
    die();
}

if (!isset($page_count)) {
    $page_count = 1;
}

if (!isset($page_number)) {
    $page_number = 1;
}

if (!isset($widget_mode)) {
    $widget_mode = 'false';
}

if (!isset($shortcode_id)) {
    $shortcode_id = '';
}
?>
<div class="estatebud-pagination" style="<?php echo $widget_mode === 'true' ? 'display: none' : 'display: flex'; ?>" data-shortcode-id="<?php echo esc_attr($shortcode_id); ?>">
<?php
$prev_page_number = $page_number - 1;
$next_page_number = $page_number + 1;
?>
<?php if ($page_count < 7): ?>
    <?php for ($i = 1; $i <= $page_count; $i++): ?>
        <a href="<?php echo esc_attr("ebp=" . $i); ?>" class="estatebud-pagination-outer-number-group<?php echo $i == $page_number ? ' active' : ''; ?>" id="<?php echo esc_attr("pagination_" . $i); ?>">
            <span class="estatebud-pagination-number"><?php echo esc_html($i); ?></span>
        </a>
    <?php endfor; ?>
<?php else: ?>
    <?php if ($prev_page_number >= 2): ?>
        <a href="ebp=1" class="estatebud-pagination-outer-number-group<?php echo $page_number === 1 ? ' active' : ''; ?>" id="pagination_1">
            <span class="estatebud-pagination-number">1</span>
        </a>
    <?php endif; ?>

    <?php if ($prev_page_number >= 3): ?>
        <a class="estatebud-pagination-outer-number-group" style="pointer-events: none;">
            <span class="estatebud-pagination-number">...</span>
        </a>
    <?php endif; ?>

    <?php
    $calculated_page_number =
        $page_number + ($prev_page_number < 1 ? 1 : 0) - ($page_count - $next_page_number < 0 ? 1 : 0);
    $calculated_prev_page_number = $calculated_page_number - 1;
    $calculated_next_page_number = $calculated_page_number + 1;
    ?>
    
    <a href="<?php echo esc_attr("ebp=" . $calculated_prev_page_number); ?>" class="estatebud-pagination-outer-number-group<?php echo $calculated_prev_page_number == $page_number ? ' active' : ''; ?>" id="<?php echo esc_attr("pagination_" . $calculated_prev_page_number); ?>">
        <span class="estatebud-pagination-number"><?php echo esc_html($calculated_prev_page_number); ?></span>
    </a>
    <a href="<?php echo esc_attr("ebp=" . $calculated_page_number); ?>" class="estatebud-pagination-outer-number-group<?php echo $calculated_page_number == $page_number ? ' active' : ''; ?>" id="<?php echo esc_attr("pagination_" . $calculated_page_number); ?>">
        <span class="estatebud-pagination-number"><?php echo esc_html($calculated_page_number); ?></span>
    </a>
    <a href="<?php echo esc_attr("ebp=" . $calculated_next_page_number); ?>" class="estatebud-pagination-outer-number-group<?php echo $calculated_next_page_number == $page_number ? ' active' : ''; ?>" id="<?php echo esc_attr("pagination_" . $calculated_next_page_number); ?>">
        <span class="estatebud-pagination-number"><?php echo esc_html($calculated_next_page_number); ?></span>
    </a>

    <?php if ($page_count - $next_page_number >= 2): ?>
        <a class="estatebud-pagination-outer-number-group" style="pointer-events: none;">
            <span class="estatebud-pagination-number">...</span>
        </a>
    <?php endif; ?>

    <?php if ($page_count - $next_page_number >= 1): ?>
        <a href="<?php echo esc_attr("ebp=" . $page_count); ?>" class="estatebud-pagination-outer-number-group<?php echo $page_number === $page_count ? ' active' : ''; ?>" id="<?php echo esc_attr("pagination_" . $page_count); ?>">
            <span class="estatebud-pagination-number"><?php echo esc_html($page_count); ?></span>
        </a>
    <?php endif; ?>
<?php endif; ?>
</div>
