<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Configs\Icons;
use EstatebudConnect\Core\Cache;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Models\Forms;
use EstatebudConnect\Services\Estatebud;
use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Controllers\Form;

$listing_setting = $listing_settings ?? [];
$setting = $settings_data ?? [];
extract($setting);

if (!isset($icon_type)) {
    $icon_type = Icons::SHAPE_SHARP;
}

if (!isset($icon_style)) {
    $icon_style = Icons::STYLE_SOLID;
}

if (!isset($currency_rate)) {
    $currency_rate = [];
}

$map_style = $listing_setting['map_style'];
$form_id = $listing_setting['contact_form'];
$attributes = array_merge($listing->get_attributes(), $listing->get_areas());
$facilities = $listing->get_facilities();
$features = $listing->get_features();
$distances = $listing->get_distances();
$planning_zones = $listing->get_planning_zones();
?>
<div class="estatebud-listing-body">
    <div class="estatebud-listing-left-side">
        <div class="estatebud-listing-spec-description">
        <?php if (count($attributes)) : ?>
            <div class="estatebud-listing-specs-group">
                <div class="estatebud-listing-specs-list estatebud-listing-specs-list-three-columns">
                    <?php foreach ($attributes as $attribute) : ?>
                    <div class="estatebud-listing-spec-container">
                        <div class="estatebud-listing-spec-title"><?php echo esc_html($attribute['label']); ?></div>
                        <div class="estatebud-listing-spec-item">
                            <div class="estatebud-listing-spec-item-icon"><?php echo wp_kses(Icons::get_svg_icon($attribute['icon'], $icon_type, $icon_style, 20, 18, $branding_color), Icons::get_kses_ruleset()); ?></div>
                            <div class="estatebud-listing-spec-item-text"><?php echo esc_html($attribute['value']); ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <?php if (!empty(Helper::get_term_from_array($listing->description))) : ?>
            <div class="estatebud-listing-description-group">
                <p class="estatebud-listing-description-content estatebud-listing-description-collapsed">
                    <?php echo nl2br(esc_html(Helper::get_term_from_array($listing->description))); ?>
                </p>
                <button class="estatebud-listing-description-readmore-button">
                    <div class="estatebud-listing-description-readmore-button-text"><?php echo esc_html(Helper::term('listing.button.read_more')); ?></div>
                    <div class="estatebud-listing-description-readmore-button-icon">
                        <?php echo wp_kses(Icons::get_svg_icon('arrow-long-right', $icon_type, $icon_style, 16, 16, '#858585'), Icons::get_kses_ruleset()); ?>
                    </div>
                </button>
            </div>
        <?php endif; ?>
    </div>
    
    <?php if (count($facilities)) : ?>
        <div class="estatebud-listing-specs-group">
            <h3 class="estatebud-listing-specs-group-title"><?php echo esc_html(Helper::term('listing.facilities.title')); ?></h3>
            <div class="estatebud-listing-specs-list">
                <?php foreach ($facilities as $facility) : ?>
                    <div class="estatebud-listing-spec-container">
                        <div class="estatebud-listing-spec-notes">
                            <?php echo wp_kses(Icons::get_svg_icon('ellipse', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 6, 6, $branding_color), Icons::get_kses_ruleset()); ?>
                            <div class="estatebud-listing-spec-notes-text"><?php echo esc_html($facility['value']); ?></div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if (count($features)) : ?>
        <div class="estatebud-listing-specs-group">
            <h3 class="estatebud-listing-specs-group-title"><?php echo esc_html(Helper::term('listing.features.title')); ?></h3>
            <div class="estatebud-listing-specs-list">
                <?php foreach ($features as $feature) : ?>
                    <div class="estatebud-listing-spec-container">
                        <div class="estatebud-listing-spec-notes">
                            <?php echo wp_kses(Icons::get_svg_icon('ellipse', Icons::SHAPE_SHARP, Icons::STYLE_SOLID, 6, 6, $branding_color), Icons::get_kses_ruleset()); ?>
                            <div class="estatebud-listing-spec-notes-text"><?php echo esc_html($feature['value']); ?></div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if (count($distances)) : ?>
        <div class="estatebud-listing-specs-group">
            <h3 class="estatebud-listing-specs-group-title"><?php echo esc_html(Helper::term('listing.distances.title')); ?></h3>
            <div class="estatebud-listing-specs-list estatebud-listing-specs-list-three-columns">
                <?php foreach ($distances as $distance) : ?>
                <div class="estatebud-listing-spec-container">
                    <div class="estatebud-listing-spec-title"><?php echo esc_html($distance['label']); ?></div>
                    <div class="estatebud-listing-spec-item">
                        <div class="estatebud-listing-spec-item-icon"><?php echo wp_kses(Icons::get_svg_icon($distance['icon'], $icon_type, $icon_style, 20, 18, $branding_color), Icons::get_kses_ruleset()); ?></div>
                        <div class="estatebud-listing-spec-item-text"><?php echo esc_html($distance['value']); ?></div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!$listing->is_rental() && !empty($listing->get_price()['price'])) :
        Helper::render_markup_from_views('Public/partials/components/calculator.php', [
            'listing' => $listing,
            'currency_rate' => $currency_rate,
            'settings_data' => $settings_data
        ]);
    endif; ?>

    <?php if (count($planning_zones)) : ?>
        <div class="estatebud-table-wrapper">
            <h3 class="estatebud-table-title"><?php echo esc_html(Helper::term('listing.planning_characteristics.title')); ?></h3>
            <table class="estatebud-table">
                <thead class="estatebud-table-header">
                    <tr class="estatebud-table-header-row">
                        <th class="estatebud-table-header-column"><?php echo esc_html(Helper::term('listing.planning_characteristics.zone')); ?></th>
                        <th class="estatebud-table-header-column"><?php echo esc_html(Helper::term('listing.planning_characteristics.cover_factor')); ?></th>
                        <th class="estatebud-table-header-column"><?php echo esc_html(Helper::term('listing.planning_characteristics.build_factor')); ?></th>
                        <th class="estatebud-table-header-column"><?php echo esc_html(Helper::term('listing.planning_characteristics.max_floors')); ?></th>
                        <th class="estatebud-table-header-column"><?php echo esc_html(Helper::term('listing.planning_characteristics.max_height')); ?></th>
                        <th class="estatebud-table-header-column"><?php echo esc_html(Helper::term('listing.planning_characteristics.affected_percentage')); ?></th>
                    </tr>
                </thead>
                <tbody class="estatebud-table-body">
                    <?php foreach ($planning_zones as $planning_zone): ?>
                        <tr class="estatebud-table-body-row">
                            <td class="estatebud-table-body-column"><?php echo esc_html($planning_zone['code']); ?></td>
                            <td class="estatebud-table-body-column"><?php echo esc_html($planning_zone['cover_factor']); ?></td>
                            <td class="estatebud-table-body-column"><?php echo esc_html($planning_zone['build_factor']); ?></td>
                            <td class="estatebud-table-body-column"><?php echo esc_html($planning_zone['max_floors']); ?></td>
                            <td class="estatebud-table-body-column"><?php echo esc_html($planning_zone['max_height']); ?></td>
                            <td class="estatebud-table-body-column"><?php echo esc_html($planning_zone['affected_percentage']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <?php if ($map_style !== 'fullscreen'): ?>
        <div class="estatebud-map-wrapper listing-map-wrapper">
            <div id="estatebud-listing-map">
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($listing_setting['legal_disclaimer'] ?? '')) : ?>
        <div class="estatebud-listing-disclaimer">
            <p class="estatebud-listing-disclaimer-content"><?php echo esc_html($listing_setting['legal_disclaimer']); ?></p>
        </div>
    <?php endif; ?>
    </div>

    <div class="estatebud-listing-right-side">
    <?php
    $contact_infos = [];
    switch ($listing_setting['contact_details'] ?? '') {
        case 'agent':
            if (isset($listing->agents)) {
                foreach ($listing->agents as $agent) {
                    $contact_infos[] = [
                        'name' => $agent['firstname'] . ' ' . $agent['lastname'],
                        'title' => $agent['title'] ?? '',
                        'email' => $agent['email'],
                        'phone' => !empty($agent['phone'] ?? '')
                            ? sprintf('(+%s) %s', $agent['phone_call_code'], $agent['phone'])
                            : '',
                        'avatar' => $agent['image']['100x100'] ?? ''
                    ];
                }
            }

            break;
        case 'office':
            if (isset($listing->branch)) {
                $contact_infos[] = [
                    'name' => $whois['company_name'],
                    'title' => $listing->branch['name'],
                    'email' => $listing->branch['email'] ?? '',
                    'phone' => !empty($listing->branch['phone'] ?? '')
                        ? sprintf('(+%s) %s', $listing->branch['phone_call_code'], $listing->branch['phone'])
                        : ''
                ];
            }

            break;
    }

    foreach ($contact_infos as $contact_info) {
        Helper::render_markup_from_views(
            'Public/partials/components/contact-card.php',
            array_merge($contact_info, ['settings_data' => $settings_data]),
        );
    }
    ?>
    
    <?php if (!empty($form_id)): ?>
        <div class="estatebud-listing-form-wrapper">
            <h3 class="estatebud-form-title"><?php echo esc_html(Helper::term('listing.contact.title')); ?></h3>
            <?php
                $form_data = Forms::instance()->get_form($form_id);
                $field_options = Estatebud::instance()
                    ->cache(Cache::TTL_1MO)
                    ->get_fields(['component' => 'property']);
                
                Helper::render_markup_from_views('Public/partials/components/form.php', [
                    'form_id' => $form_id,
                    'settings_data' => $settings_data,
                    'form_data' => $form_data,
                    'field_options' => $field_options,
                ]);
            ?>
        </div>
    <?php endif; ?>
    </div>
</div>

<?php if ($map_style == 'fullscreen'): ?>
<div class="estatebud-map-wrapper fullscreen-map listing-map-wrapper" >
    <div id="estatebud-listing-map" class="estatebud-fullscreen-map"></div>
</div>
<?php endif; ?>

<?php Helper::render_markup_from_views('Public/partials/components/listing-units-table.php', ['listing' => $listing]); ?>
