<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Models\Sharing;
use EstatebudConnect\Configs\Icons;
use EstatebudConnect\Models\Property;

$setting = $settings_data ?? [];
extract($setting);

if (!isset($icon_type)) {
    $icon_type = Icons::SHAPE_SHARP;
}

if (!isset($icon_style)) {
    $icon_style = Icons::STYLE_SOLID;
}

if (!isset($listing)) {
    $listing = [];
}

$enabled_sharing_providers = $settings_data['sharing_providers'] ?? [];

$icon_location_dot = Icons::get_svg_icon('location-dot', $icon_type, $icon_style, 12, 16, $branding_color);
$icon_pdf = Icons::get_svg_icon('file-pdf', $icon_type, 'regular', 24, 24, '#B8B8B8');
$icon_heart = Icons::get_svg_icon('heart', $icon_type, 'regular', 24, 24, '#B8B8B8');
$icon_share = Icons::get_svg_icon('share-nodes', $icon_type, 'regular', 24, 24, '#B8B8B8');
$icon_image = Icons::get_svg_icon('image', $icon_type, 'solid', 14, 14, '#050505');
$icon_table_layout = Icons::get_svg_icon('table-layout', $icon_type, 'solid', 14, 14, '#050505');
$icon_video = Icons::get_svg_icon('video', $icon_type, 'solid', 16, 14, '#050505');
$icon_streetview = Icons::get_svg_icon('street-view', $icon_type, 'solid', 16, 14, '#050505');
$icon_angle_left = Icons::get_svg_icon('angle-left', $icon_type, $icon_style, 23, 30, '#FFFFFF');
$icon_angle_right = Icons::get_svg_icon('angle-right', $icon_type, $icon_style, 23, 30, '#FFFFFF');

$slider_style = $listing_settings['slider_style'] ?? '';

$area = $listing->get_area();
$images = $listing->get_images();
$floorplans = $listing->get_floorplans();
$videos = $listing->get_videos();
$virtual_tours = $listing->get_virtual_tours();
$sharing = new Sharing($listing->get_url());
?>
<div class="estatebud-listing-header" data-listing-id="<?php echo esc_attr($listing->get_id()); ?>">
    <?php if (count($images)): ?>
        <?php if ($slider_style === 'fullscreen'): ?>
            <section class="estatebud-fullscreen-slider-wrapper">
                <div class="estatebud-fullscreen-slider-content">
                    <div class="estatebud-fullscreen-slider">
                        <div class="estatebud-fullscreen-slider-list">
                            <div class="estatebud-fullscreen-slider-track">
                                <?php
                                $imageCount = count($images);
                                $lastIndex = $imageCount - 1;

                                foreach ($images as $index => $image): 
                                    $shouldLoadInitially = ($index === 0 || $index === 1 || ($index === $lastIndex && $lastIndex > 1));
                                ?>
                                    <div class="estatebud-slider-item<?php echo $index === 0
                                        ? ' estatebud-slide-active estatebud-slide-center'
                                        : ''; ?>" data-index="<?php echo esc_attr($index); ?>"<?php echo $index === 0
    ? ''
    : ' aria-hidden="true" tabindex="-1"'; ?>>
                                        <img <?php echo $shouldLoadInitially ? 'src=' : 'data-src='; ?>"<?php echo esc_url(Helper::image_optimizer($image, ['h' => 720])); ?>" alt="property image" />
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="estatebud-slider-overlay">
                        <div class="estatebud-slider-details">
                            <?php if (count($images)): ?>
                                <div class="estatebud-icon-label">
                                    <?php echo wp_kses($icon_image, Icons::get_kses_ruleset()); ?>
                                    <div class="estatebud-icon-label-text"><?php echo esc_html(count($images)); ?></div>
                                </div>
                            <?php endif; ?>
                            <?php if (count($floorplans)): ?>
                                <div class="estatebud-icon-label">
                                    <?php echo wp_kses($icon_table_layout, Icons::get_kses_ruleset()); ?>
                                    <div class="estatebud-icon-label-text"><?php echo esc_html(count($floorplans)); ?></div>
                                </div>
                            <?php endif; ?>
                            <?php if (count($videos)): ?>
                                <div class="estatebud-icon-label">
                                    <?php echo wp_kses($icon_video, Icons::get_kses_ruleset()); ?>
                                    <div class="estatebud-icon-label-text"><?php echo esc_html(count($videos)); ?></div>
                                </div>
                            <?php endif; ?>
                            <?php if (count($virtual_tours)): ?>
                                <div class="estatebud-icon-label">
                                    <?php echo wp_kses($icon_streetview, Icons::get_kses_ruleset()); ?>
                                    <div class="estatebud-icon-label-text"><?php echo esc_html(count($virtual_tours)); ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="estatebud-slider-arrows">
                            <button class="button icon white slick-arrow" id="carousel_button_prev">
                                <?php echo wp_kses($icon_angle_left, Icons::get_kses_ruleset()); ?>
                            </button>
                            <button class="button icon white slick-arrow" id="carousel_button_next">
                                <?php echo wp_kses($icon_angle_right, Icons::get_kses_ruleset()); ?>
                            </button>
                        </div>
                        <div class="estatebud-slider-labels">
                            <?php foreach ($listing->get_labels() as $label) {
                                Helper::render_markup_from_views('Public/partials/components/listing-label.php', [
                                    'name' => $label['name'],
                                    'color' => $label['color']
                                ]);
                            } ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php else: ?>
            <div class="estatebud-listing-carousel">
                <div class="estatebud-listing-carousel-main-stage">
                    <div class="estatebud-property-carousel-main-stage-badge">
                        <?php foreach ($listing->get_labels() as $label) {
                            Helper::render_markup_from_views('Public/partials/components/listing-label.php', [
                                'name' => $label['name'],
                                'color' => $label['color']
                            ]);
                        } ?>
                    </div>
                    <div class="estatebud-listing-card-carousel-controls">
                        <div name="carousel-left" class="estatebud-listing-card-carousel-button" id="carousel_button_prev">
                            <?php echo wp_kses($icon_angle_left, Icons::get_kses_ruleset()); ?>
                        </div>
                        <div name="carousel-right" class="estatebud-listing-card-carousel-button" id="carousel_button_next">
                            <?php echo wp_kses($icon_angle_right, Icons::get_kses_ruleset()); ?>
                        </div>
                    </div>
                    <div class="estatebud-listing-carousel-main-stage-category">
                        <?php if (count($images)): ?>
                            <div class="estatebud-icon-label">
                                <?php echo wp_kses($icon_image, Icons::get_kses_ruleset()); ?>
                                <div class="estatebud-icon-label-text"><?php echo esc_html(count($images)); ?></div>
                            </div>
                        <?php endif; ?>
                        <?php if (count($floorplans)): ?>
                            <div class="estatebud-icon-label">
                                <?php echo wp_kses($icon_table_layout, Icons::get_kses_ruleset()); ?>
                                <div class="estatebud-icon-label-text"><?php echo esc_html(count($floorplans)); ?></div>
                            </div>
                        <?php endif; ?>
                        <?php if (count($videos)): ?>
                            <div class="estatebud-icon-label">
                                <?php echo wp_kses($icon_video, Icons::get_kses_ruleset()); ?>
                                <div class="estatebud-icon-label-text"><?php echo esc_html(count($videos)); ?></div>
                            </div>
                        <?php endif; ?>
                        <?php if (count($virtual_tours)): ?>
                            <div class="estatebud-icon-label">
                                <?php echo wp_kses($icon_streetview, Icons::get_kses_ruleset()); ?>
                                <div class="estatebud-icon-label-text"><?php echo esc_html(count($virtual_tours)); ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php 
                    $imageCount = count($images);
                    $lastIndex = $imageCount - 1;
                    
                    $displayImages = $images;
                    if ($imageCount === 1) {
                        $displayImages = [$images[0], $images[0], $images[0]];
                    } elseif ($imageCount === 2) {
                        $displayImages = [$images[0], $images[1], $images[0], $images[1]];
                    }
                    
                    foreach ($displayImages as $index => $image): 
                        $shouldLoadInitially = ($index === 0 || $index === 1 || ($index === $lastIndex && $lastIndex > 2));
                    ?>
                        <img id="<?php echo esc_attr($index); ?>" alt="property image" <?php echo $shouldLoadInitially ? 'src=' : 'data-src='; ?>"<?php echo esc_url(Helper::image_optimizer($image, ['w' => '780', 'h' => '520', 'f' => 'cover'])); ?>" class="estatebud-listing-card-status-image<?php echo $index !== 0 ? ' estatebud-hidden' : ''; ?>">
                    <?php endforeach; ?>
                </div>

                <div class="estatebud-listing-carousel-list">
                    <div class="estatebud-listing-carousel-list-first-image">
                        <?php 
                        foreach ($displayImages as $index => $image): 
                            $shouldLoadInitially = ($index === 0 || $index === 1 || $index === 2 );
                        ?>
                            <img id="<?php echo esc_attr($index); ?>" alt="property image" <?php echo $shouldLoadInitially ? 'src=' : 'data-src='; ?>"<?php echo esc_url(Helper::image_optimizer($image, ['w' => '380', 'h' => '250', 'f' => 'cover'])); ?>" class="estatebud-listing-card-status-image<?php echo $index !== 1 ? ' estatebud-hidden' : ''; ?>">
                        <?php endforeach; ?>
                    </div>
                    <div class="estatebud-listing-carousel-list-second-image">
                        <?php 
                        foreach ($displayImages as $index => $image): 
                            $shouldLoadInitially = ($index === 1 || $index === 2 || $index === 3);
                        ?>
                            <img id="<?php echo esc_attr($index); ?>" alt="property image" <?php echo $shouldLoadInitially ? 'src=' : 'data-src='; ?>"<?php echo esc_url(Helper::image_optimizer($image, ['w' => '380', 'h' => '250', 'f' => 'cover'])); ?>" class="estatebud-listing-card-status-image<?php echo $index !== 2 ? ' estatebud-hidden' : ''; ?>">
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <div class="estatebud-listing-details-wrapper">
        <div class="estatebud-listing-details">
            <?php if ($listing->is_rented()):
                if (!empty($listing->tenant['period_to']) && $listing_settings['show_availability_date'] === '1') {
                    $availableDate = wp_date(
                        get_option('date_format'),
                        strtotime($listing->tenant['period_to']) + 86400
                    );
                } ?>
            <div class="estatebud-listing-notice">
                <span class="estatebud-listing-notice-icon"><?php echo wp_kses(Icons::get_svg_icon(
                    'info-circle',
                    $icon_type,
                    $icon_style,
                    16,
                    16,
                    '#FFFFFF'
                ), Icons::get_kses_ruleset()); ?></span>
                <span class="estatebud-listing-notice-message"><?php echo esc_html(!isset($availableDate)
                    ? Helper::term('listing.disclaimer.rented')
                    : sprintf(
                        Helper::term('listing.disclaimer.rented_until_x'),
                        $availableDate
                    )); ?></span>
            </div>
            <?php
            endif; ?>
            <?php if ($listing->is_sold()): ?>
            <div class="estatebud-listing-notice estatebud-listing-notice-warning">
                <span class="estatebud-listing-notice-icon"><?php echo wp_kses(Icons::get_svg_icon(
                    'info-circle',
                    $icon_type,
                    $icon_style,
                    16,
                    16,
                    '#FFFFFF'
                ), Icons::get_kses_ruleset()); ?></span>
                <span class="estatebud-listing-notice-message"><?php echo esc_html(Helper::term('listing.disclaimer.sold')); ?></span>
            </div>
            <?php endif; ?>

            <div class="estatebud-listing-category-group">
                <div class="estatebud-listing-category-group-name"><?php echo esc_html($listing->get_type()); ?></div>
                <div class="estatebud-listing-category-group-id"><?php echo esc_html($listing->get_reference_id()); ?></div>
            </div>
            <div class="estatebud-listing-title-price-group">
                <h1 class="estatebud-listing-title-name">
                    <?php echo esc_html($listing->get_title()); ?>
                </h1>
                <div class="estatebud-listing-price">
                    <div class="estatebud-listing-main-price">
                        <?php echo esc_html(Helper::format_price($listing->get_price()) ?? Helper::term('listing.price_on_request')); ?>
                    </div>
                    <div class="estatebud-listing-discount-price<?php echo $listing->get_original_price()
                        ? ''
                        : ' estatebud-hidden'; ?>">
                        <?php echo esc_html(Helper::format_price($listing->get_original_price())); ?>
                    </div>
                    <div class="estatebud-listing-main-base-price estatebud-hidden">
                        <?php if ($listing->get_price()) {
                            echo esc_html($listing->get_price()['price']);
                        } ?>
                    </div>
                    <div class="estatebud-listing-discount-base-price estatebud-hidden">
                        <?php if ($listing->get_original_price()) {
                            echo esc_html($listing->get_original_price()['price']);
                        } ?>
                    </div>
                    <div class="estatebud-listing-price-text">
                        <?php
                        if (!empty($listing->get_price()['frequency'])) {
                            echo esc_html(Helper::term('frequency.every.' . $listing->get_price()['frequency']));
                        }
                        if ($listing->get_price()['vat']) {
                            echo esc_html(Helper::term('listing.plus_vat'));
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="estatebud-listing-details-bottom">
                <?php if (!empty($area)): ?>
                    <div class="estatebud-listing-location">
                        <?php echo wp_kses($icon_location_dot, Icons::get_kses_ruleset()); ?>
                        <div class="estatebud-listing-location-name"><?php echo esc_html($area); ?></div>
                    </div>
                <?php endif; ?>
                <div class="estatebud-listing-toolbar">
                    <div class="estatebud-listing-toolbar-item">
                        <div class="estatebud-listing-toolbar-icon" id="estatebud-pdf-template-button">
                            <?php echo wp_kses($icon_pdf, Icons::get_kses_ruleset()); ?>
                        </div>
                        <div class="estatebud-pdf-download-wrapper estatebud-hidden" id="estatebud-pdf-download-wrapper">
                            <button class="estatebud-pdf-download-button" id="estatebud-pdf-download-button">
                                <?php echo esc_html(Helper::term('listing.button.download_pdf')); ?>
                            </button>
                        </div>
                    </div>
                    <?php if ($enabled_sharing_providers): ?>
                    <div class="estatebud-listing-toolbar-item">
                        <div class="estatebud-listing-toolbar-icon" id="estatebud-social-share-button">
                            <?php echo wp_kses($icon_share, Icons::get_kses_ruleset()); ?>
                        </div>
                        <div class="estatebud-social-group estatebud-hidden" id="estatebud-social-group">
                        <?php foreach ($enabled_sharing_providers as $sharing_provider): ?>
                            <?php if ($url = $sharing->get_url($sharing_provider)): ?>
                                <?php
                                    $icon = $sharing->get_icon($sharing_provider);
                                    $sharing_icon = Icons::get_svg_icon($icon['name'], $icon['brand'] ? Icons::SHAPE_DEFAULT : Icons::SHAPE_SHARP, $icon['brand'] ? Icons::STYLE_BRANDS : Icons::STYLE_SOLID, 20, 20, '#FFFFFF');
                                ?>
                                <a class="estatebud-social-button <?php echo esc_attr(sprintf('estatebud-social-button-%s', $sharing_provider)); ?>" href="<?php echo esc_url($url); ?>" target="_blank" rel="noopener noreferrer nofollow">
                                    <?php echo wp_kses($sharing_icon, Icons::get_kses_ruleset()); ?>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="estatebud-listing-toolbar-item">
                        <div class="estatebud-listing-toolbar-icon" id="estatebud-favorite-button">
                            <?php echo wp_kses($icon_heart, Icons::get_kses_ruleset()); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>