<?php
if (!defined('WPINC')) {
    die();
}

use EstatebudConnect\Utilities\Helper;
use EstatebudConnect\Models\Settings;
use EstatebudConnect\Models\SearchExperience;

if (!isset($form_id)) {
    $form_id = '';
}

if (!isset($search_id)) {
    $search_id = '';
}

if (!isset($query_from_link)) {
    $query_from_link = [];
}

if (!isset($page_number)) {
    $page_number = 1;
}

if (!isset($map_position)) {
    $map_position = 'right';
}

if (!isset($is_favorites)) {
    $is_favorites = false;
}

if (!isset($widget_mode)) {
    $widget_mode = '';
}

if (!isset($shortcode_id)) {
    $shortcode_id = '';
}
?>

<div class="estatebud-listings-wrapper" data-shortcode-id="<?php echo esc_attr($shortcode_id); ?>">
    <?php Helper::render_markup_from_views('/Public/partials/listings/header.php', [
        'form' => $form_id,
        'search_id' => $search_id,
        'query_from_link' => $query_from_link,
        'is_favorites' => $is_favorites,
        'widget_mode' => $widget_mode,
        'shortcode_id' => $shortcode_id,
        'settings_data' => $settings_data ?? [],
        'field_options' => $field_options ?? [],
        'location_options' => $location_options ?? [],
        'search_exp_data' => $search_exp_data ?? null,
        'form_data' => $form_data ?? null,
        'listings_type' => $listings_type ?? 'property',
    ]); ?>
    <?php if (!empty($search_id) || $is_favorites === true): ?>
        <div class="estatebud-listings">
            <?php
            $map_position = $map_position ?? 'top';
            $map_default_state = $map_default_state ?? 'off';
            $listings_content_class = 'estatebud-listings-content';

            if ($map_default_state === 'on' && ($map_position === 'left' || $map_position === 'right')) {
                $listings_content_class .= ' estatebud-listings-content-map-' . esc_attr($map_position);
            }
            ?>
            <div class="<?php echo esc_attr($listings_content_class); ?>">
                <?php
                if ($map_default_state === 'on' && ($map_position === 'left' || $map_position === 'right')) {
                    $map_wrapper_style =
                        'width: 40% !important; flex-shrink: 0 !important; flex-grow: 0 !important; display: flex !important; visibility: visible !important; background: var(--estatebud-neutral-50); position: relative; overflow: hidden; z-index: 10; height: 800px !important;';
                    echo '<div class="estatebud-map-wrapper estatebud-map-wrapper-is-active" data-shortcode-id="' .
                        esc_attr($shortcode_id) .
                        '" style="' .
                        esc_attr($map_wrapper_style) .
                        '"></div>';
                } ?>
                <?php Helper::render_markup_from_views('/Public/partials/components/loading.php', [
                    'page_number' => $page_number,
                    'map_position' => $map_position,
                    'map_default_state' => $map_default_state,
                    'settings_data' => $settings_data,
                ]); ?>
            </div>
        </div>
    <?php endif; ?>
</div>